/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.interfaces;

import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalExternalAlgorithm;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StandardLocalInfraAlgorithm
extends StandardLocalExternalAlgorithm {
    private Logger LOGGER = LoggerFactory.getLogger(StandardLocalInfraAlgorithm.class);
    private static final String SEND_MESSAGE_METHOD = "/messages/write-message";

    public void sendNotification(String subject, String body) throws Exception {
        this.LOGGER.debug("Emailing System->Starting request of email in scope " + this.config.getGcubeScope());
        if (!this.sendMessage(this.config.getGcubeToken(), this.config.getGcubeUserName(), subject, body)) {
            this.LOGGER.error("error sending message to {}", (Object)this.config.getGcubeUserName());
            throw new Exception("error sending message to " + this.config.getGcubeUserName());
        }
    }

    private boolean sendMessage(String token, String email, String subject, String body) throws Exception {
        String socialServiceEnpoint = this.retrieveSocialServiceEnpoint();
        this.LOGGER.debug("contacting social service endpoint {}", (Object)(socialServiceEnpoint + SEND_MESSAGE_METHOD + "?gcube-token=" + token));
        PostMethod putMessage = new PostMethod(socialServiceEnpoint + SEND_MESSAGE_METHOD + "?gcube-token=" + token);
        JSONObject obj = new JSONObject();
        obj.put((Object)"subject", (Object)subject);
        obj.put((Object)"body", (Object)body);
        JSONArray list = new JSONArray();
        list.add((Object)email);
        obj.put((Object)"recipients", (Object)list);
        putMessage.setRequestEntity((RequestEntity)new StringRequestEntity(obj.toJSONString(), "application/json", "UTF-8"));
        this.LOGGER.debug("json request is {}", (Object)obj.toJSONString());
        HttpClient httpClient = new HttpClient();
        int returnedStatus = -1;
        try {
            returnedStatus = httpClient.executeMethod((HttpMethod)putMessage);
            this.LOGGER.info("response from social networking service is {}", (Object)returnedStatus);
            return returnedStatus >= 200 && returnedStatus <= 205;
        }
        catch (Exception e) {
            this.LOGGER.error("error trying to send invitation", (Throwable)e);
            throw new Exception("error trying to send invitation", e);
        }
    }

    private String retrieveSocialServiceEnpoint() throws Exception {
        XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
        query.addCondition("$resource/Profile/ServiceClass/text() eq 'Portal'");
        query.addCondition("$resource/Profile/ServiceName/text() eq 'SocialNetworking'");
        query.addVariable("$entry", "$resource/Profile/AccessPoint/RunningInstanceInterfaces/Endpoint");
        query.addCondition("$entry/@EntryName/string() eq 'jersey-servlet'");
        query.setResult("$entry/text()");
        DiscoveryClient client = ICFactory.client();
        List socialServiceEnpoints = client.submit((Query)query);
        if (socialServiceEnpoints.size() == 0) {
            throw new Exception("Social servioce enpooint not found in the current scope " + ScopeProvider.instance.get());
        }
        String socialServiceEnpoint = (String)socialServiceEnpoints.get(0);
        return socialServiceEnpoint + "/2";
    }
}

