/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.signals;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.gcube.contentmanagement.graphtools.utils.MathFunctions;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.signals.SignalConverter;

public class PeriodicityDetector {
    static int defaultSamplingRate = 8000;
    static float defaultSignalLengthTimeinSec = 5.0f;
    static float defaultHiddenFrequency = 2.0f;
    static float defaultMinPossibleFreq = 0.0f;
    static float defaultMaxPossibleFreq = 1000.0f;
    static float defaultSNratio = 0.0f;
    static float defaultFreqError = 1.0f;
    public int currentSamplingRate;
    public int currentWindowShiftSamples;
    public int currentWindowAnalysisSamples;
    public double[][] currentspectrum;
    public double meanF = 0.0;
    public double lowermeanF = 0.0;
    public double uppermeanF = 0.0;
    public double meanPeriod = 0.0;
    public double lowermeanPeriod = 0.0;
    public double uppermeanPeriod = 0.0;
    public double startPeriodTime = 0.0;
    public double endPeriodTime = 0.0;
    public double startPeriodSampleIndex = 0.0;
    public double endPeriodSampleIndex = 0.0;
    public double periodicityStrength = 0.0;
    public double minFrequency;
    public double maxFrequency;

    public String getPeriodicityStregthInterpretation() {
        if (this.periodicityStrength > 0.6) {
            return "High";
        }
        if (this.periodicityStrength <= 0.6 && this.periodicityStrength > 0.5) {
            return "Moderate";
        }
        if (this.periodicityStrength <= 0.5 && this.periodicityStrength > 0.3) {
            return "Weak";
        }
        if (this.periodicityStrength >= 0.3) {
            return "Very Low";
        }
        return "None";
    }

    public String getPowerSpectrumStregthInterpretation(double powerStrength) {
        if (powerStrength > 3.0) {
            return "High";
        }
        if (powerStrength <= 3.0 && powerStrength > 2.5) {
            return "Moderate";
        }
        if (powerStrength <= 2.5 && powerStrength > 2.0) {
            return "Weak";
        }
        if (powerStrength >= 1.4) {
            return "Very Low";
        }
        return "None";
    }

    public void demo() throws Exception {
        double[] signal = this.produceNoisySignal(defaultSignalLengthTimeinSec, defaultSamplingRate, defaultHiddenFrequency, defaultSNratio);
        AnalysisLogger.getLogger().debug((Object)("Signal samples: " + signal.length));
        double F = this.detectFrequency(signal, defaultSamplingRate, defaultMinPossibleFreq, defaultMaxPossibleFreq, defaultFreqError, -1, true);
        AnalysisLogger.getLogger().debug((Object)("Detected F:" + F + " indecision [" + this.lowermeanF + " , " + this.uppermeanF + "]"));
    }

    public static void main(String[] args) throws Exception {
        PeriodicityDetector processor = new PeriodicityDetector();
        processor.demo();
    }

    public double[] produceNoisySignal(float signalLengthTimeinSec, int samplingRate, float frequency, float SNratio) {
        double[] sin = SignalConverter.generateSinSignal((int)signalLengthTimeinSec * samplingRate, 1.0f / (float)samplingRate, frequency);
        for (int i = 0; i < sin.length; ++i) {
            sin[i] = sin[i] + (double)SNratio * Math.random();
        }
        return sin;
    }

    public double detectFrequency(double[] signal, boolean display) throws Exception {
        return this.detectFrequency(signal, 1, 0.0f, 1.0f, 1.0f, -1, display);
    }

    public double detectFrequency(double[] signal) throws Exception {
        return this.detectFrequency(signal, false);
    }

    public double detectFrequency(double[] signal, int samplingRate, float minPossibleFreq, float maxPossibleFreq, float wantedFreqError, int FFTnsamples, boolean display) throws Exception {
        int wLength = 0;
        long pow = 0L;
        if (wantedFreqError > -1.0f) {
            pow = Math.round(Math.log((float)samplingRate / wantedFreqError) / Math.log(2.0));
            if (pow <= 1L) {
                pow = Math.round(Math.log((float)signal.length / (float)("" + signal.length).length()) / Math.log(2.0));
            }
            AnalysisLogger.getLogger().debug((Object)("Suggested pow for window length=" + pow));
        } else {
            if (FFTnsamples < 2) {
                FFTnsamples = 2;
            } else if (FFTnsamples > signal.length) {
                FFTnsamples = signal.length;
            }
            pow = Math.round(Math.log(FFTnsamples) / Math.log(2.0));
        }
        wLength = (int)Math.pow(2.0, pow);
        AnalysisLogger.getLogger().debug((Object)("Suggested windows length (samples)=" + wLength));
        AnalysisLogger.getLogger().debug((Object)("Suggested windows length (s)=" + (float)wLength / (float)samplingRate + " s"));
        int windowAnalysisSamples = (int)Math.pow(2.0, 14.0);
        windowAnalysisSamples = wLength;
        int windowShiftSamples = Math.round((float)windowAnalysisSamples / 2.0f);
        float windowShiftTime = (float)SignalConverter.sample2Time(windowShiftSamples, samplingRate);
        float error = (float)samplingRate / (float)windowAnalysisSamples;
        AnalysisLogger.getLogger().debug((Object)("Error in the Measure will be: " + error + " Hz"));
        AnalysisLogger.getLogger().debug((Object)("A priori Min Freq: " + minPossibleFreq + " s"));
        AnalysisLogger.getLogger().debug((Object)("A priori Max Freq: " + maxPossibleFreq + " s"));
        if (maxPossibleFreq >= (float)samplingRate) {
            maxPossibleFreq = (float)samplingRate / 2.0f - 0.1f * (float)samplingRate / 2.0f;
        }
        if (minPossibleFreq == 0.0f) {
            minPossibleFreq = 0.1f;
        }
        this.minFrequency = minPossibleFreq;
        this.maxFrequency = maxPossibleFreq;
        this.currentSamplingRate = samplingRate;
        this.currentWindowShiftSamples = windowShiftSamples;
        this.currentWindowAnalysisSamples = windowAnalysisSamples;
        double[][] spectrum = SignalConverter.spectrogram("spectrogram", signal, samplingRate, windowShiftSamples, windowAnalysisSamples, false);
        if (display) {
            SignalConverter.displaySpectrogram(spectrum, signal, "complete spectrogram", samplingRate, windowShiftSamples, windowAnalysisSamples);
        }
        spectrum = SignalConverter.cutSpectrum(spectrum, minPossibleFreq, maxPossibleFreq, windowAnalysisSamples, samplingRate);
        if (display) {
            SignalConverter.displaySpectrogram(spectrum, signal, "clean spectrogram", samplingRate, windowShiftSamples, windowAnalysisSamples);
        }
        SignalConverter signalMaximumAnalyzer = new SignalConverter();
        double[] maxfrequencies = signalMaximumAnalyzer.takeMaxFrequenciesInSpectrogram(spectrum, samplingRate, windowAnalysisSamples, minPossibleFreq);
        double[] powers = signalMaximumAnalyzer.averagepower;
        this.currentspectrum = spectrum;
        AnalysisLogger.getLogger().debug((Object)("Number of frequency peaks " + maxfrequencies.length));
        SignalConverter signalconverter = new SignalConverter();
        maxfrequencies = signalconverter.takeLongestStableTract(maxfrequencies, 0.01);
        if (maxfrequencies == null) {
            return 0.0;
        }
        this.startPeriodTime = SignalConverter.spectrogramTimeFromIndex(signalconverter.startStableTractIdx, windowShiftTime);
        this.endPeriodTime = SignalConverter.spectrogramTimeFromIndex(signalconverter.endStableTractIdx, windowShiftTime);
        this.startPeriodSampleIndex = SignalConverter.time2Sample(this.startPeriodTime, samplingRate);
        this.endPeriodSampleIndex = Math.min(SignalConverter.time2Sample(this.endPeriodTime, samplingRate), signal.length - 1);
        float power = 0.0f;
        int counter = 0;
        for (int i = signalconverter.startStableTractIdx; i < signalconverter.endStableTractIdx; ++i) {
            power = MathFunctions.incrementPerc(power, (float)powers[i], counter);
            ++counter;
        }
        this.periodicityStrength = power;
        if (this.periodicityStrength == -0.0) {
            this.periodicityStrength = 0.0;
        }
        double meanF = MathFunctions.mean(maxfrequencies);
        double possibleperiod = 2.0 / meanF;
        AnalysisLogger.getLogger().debug((Object)("TimeSeriesAnalysis->Frequency " + meanF));
        AnalysisLogger.getLogger().debug((Object)("TimeSeriesAnalysis->Periodicity " + possibleperiod));
        double maxperiod = Math.min(signal.length, this.currentWindowAnalysisSamples);
        if (meanF <= (double)minPossibleFreq || meanF >= (double)maxPossibleFreq || possibleperiod == 0.0 || possibleperiod > maxperiod) {
            AnalysisLogger.getLogger().debug((Object)("TimeSeriesAnalysis->Invalid periodicity " + (meanF <= (double)minPossibleFreq) + " , " + (meanF >= (double)maxPossibleFreq) + " , " + (possibleperiod == 0.0) + " , " + (possibleperiod > maxperiod)));
            meanF = 0.0;
            this.meanF = 0.0;
            this.lowermeanF = 0.0;
            this.uppermeanF = 0.0;
            this.meanPeriod = 0.0;
            this.lowermeanPeriod = 0.0;
            this.uppermeanPeriod = 0.0;
            this.periodicityStrength = 0.0;
            this.startPeriodTime = 0.0;
            this.endPeriodTime = 0.0;
            this.startPeriodSampleIndex = 0.0;
            this.endPeriodSampleIndex = 0.0;
        } else {
            AnalysisLogger.getLogger().debug((Object)("TimeSeriesAnalysis->periodicity is valid " + possibleperiod));
            this.meanF = meanF;
            this.lowermeanF = Math.max(meanF - (double)error, (double)minPossibleFreq);
            this.uppermeanF = Math.min(meanF + (double)error, this.maxFrequency);
            this.meanPeriod = possibleperiod;
            this.lowermeanPeriod = 2.0 / this.lowermeanF;
            this.uppermeanPeriod = 2.0 / this.uppermeanF;
        }
        return meanF;
    }

    public void adjustParameters(double[] signal, int samplingRate, float minPossibleFreq, float maxPossibleFreq, float wantedFreqError, int FFTnsamples) {
        int wLength = 0;
        long pow = 0L;
        if (wantedFreqError > -1.0f) {
            pow = Math.round(Math.log((float)samplingRate / wantedFreqError) / Math.log(2.0));
            if (pow <= 1L) {
                pow = Math.round(Math.log((float)signal.length / (float)("" + signal.length).length()) / Math.log(2.0));
            }
            AnalysisLogger.getLogger().debug((Object)("Suggested pow for window length=" + pow));
        } else {
            if (FFTnsamples < 2) {
                FFTnsamples = 2;
            } else if (FFTnsamples > signal.length) {
                FFTnsamples = signal.length;
            }
            pow = Math.round(Math.log(FFTnsamples) / Math.log(2.0));
        }
        wLength = (int)Math.pow(2.0, pow);
        AnalysisLogger.getLogger().debug((Object)("Suggested windows length (samples)=" + wLength));
        AnalysisLogger.getLogger().debug((Object)("Suggested windows length (s)=" + (float)wLength / (float)samplingRate + " s"));
        int windowAnalysisSamples = (int)Math.pow(2.0, 14.0);
        windowAnalysisSamples = wLength;
        int windowShiftSamples = Math.round((float)windowAnalysisSamples / 2.0f);
        float windowShiftTime = (float)SignalConverter.sample2Time(windowShiftSamples, samplingRate);
        float error = (float)samplingRate / (float)windowAnalysisSamples;
        AnalysisLogger.getLogger().debug((Object)("Error in the Measure will be: " + error + " Hz"));
        AnalysisLogger.getLogger().debug((Object)("A priori Min Freq: " + minPossibleFreq + " s"));
        AnalysisLogger.getLogger().debug((Object)("A priori Max Freq: " + maxPossibleFreq + " s"));
        if (maxPossibleFreq >= (float)samplingRate) {
            maxPossibleFreq = (float)samplingRate / 2.0f - 0.1f * (float)samplingRate / 2.0f;
        }
        if (minPossibleFreq == 0.0f) {
            minPossibleFreq = 0.1f;
        }
        this.minFrequency = minPossibleFreq;
        this.maxFrequency = maxPossibleFreq;
        this.currentSamplingRate = samplingRate;
        this.currentWindowShiftSamples = windowShiftSamples;
        this.currentWindowAnalysisSamples = windowAnalysisSamples;
    }

    public LinkedHashMap<String, String> detectAllFrequencies(double[] signal, int samplingRate, float minPossibleFreq, float maxPossibleFreq, float wantedFreqError, int FFTnsamples, float sensitivity, boolean display) throws Exception {
        this.adjustParameters(signal, samplingRate, minPossibleFreq, maxPossibleFreq, wantedFreqError, FFTnsamples);
        double frequencyRes = (double)samplingRate / 2.0 / (double)this.currentWindowAnalysisSamples;
        AnalysisLogger.getLogger().debug((Object)("Frequency Resolution: " + frequencyRes));
        double[][] spectrum = SignalConverter.spectrogram("spectrogram", signal, samplingRate, this.currentWindowShiftSamples, this.currentWindowAnalysisSamples, false);
        if (display) {
            SignalConverter.displaySpectrogram(spectrum, signal, "complete spectrogram", samplingRate, this.currentWindowShiftSamples, this.currentWindowAnalysisSamples);
        }
        spectrum = SignalConverter.cutSpectrum(spectrum, minPossibleFreq, maxPossibleFreq, this.currentWindowAnalysisSamples, samplingRate);
        if (display) {
            SignalConverter.displaySpectrogram(spectrum, signal, "clean spectrogram", samplingRate, this.currentWindowShiftSamples, this.currentWindowAnalysisSamples);
        }
        float windowShiftTime = (float)SignalConverter.sample2Time(this.currentWindowShiftSamples, samplingRate);
        float windowLengthTime = (float)SignalConverter.sample2Time(this.currentWindowAnalysisSamples, samplingRate);
        float signalTime = (float)SignalConverter.sample2Time(signal.length, samplingRate);
        this.currentspectrum = spectrum;
        SignalConverter signalMaximumAnalyzer = new SignalConverter();
        ArrayList<Double>[] maxfrequencies = signalMaximumAnalyzer.takePeaksInSpectrogramFrames(spectrum, samplingRate, this.currentWindowAnalysisSamples, minPossibleFreq);
        LinkedHashMap<String, String> peaks = new LinkedHashMap<String, String>();
        double maxperiod = (double)Math.min(signal.length, this.currentWindowAnalysisSamples) * (double)samplingRate;
        double error = 1.96 * frequencyRes;
        for (int i = 0; i < maxfrequencies.length; ++i) {
            double startTime = SignalConverter.spectrogramTimeFromIndex(i, windowShiftTime);
            double endTime = Math.min(startTime + (double)windowLengthTime, (double)signalTime);
            int counter = 0;
            int freqCounter = 0;
            Double previousFreq = 0.0;
            Double previousPeriod = -100.0;
            String prefix = "";
            if (maxfrequencies.length > 1) {
                prefix = " (Section " + (i + 1) + ")";
            }
            for (Double peakFreq : maxfrequencies[i]) {
                double period = 1.0 / peakFreq;
                double power = signalMaximumAnalyzer.currentSpikesPowerSpectra[i].get(freqCounter);
                double periodResolution = sensitivity / (float)samplingRate;
                if (Math.abs(previousPeriod - period) > periodResolution && peakFreq - previousFreq > error && peakFreq >= (double)minPossibleFreq && peakFreq <= (double)maxPossibleFreq && period > 0.0 && period < maxperiod * (double)0.55f && !this.getPowerSpectrumStregthInterpretation(power).equalsIgnoreCase("None")) {
                    AnalysisLogger.getLogger().debug((Object)("DISCREPANCY WITH RESPECT TO THE PREVIOUS FREQ:" + (peakFreq - previousFreq)));
                    AnalysisLogger.getLogger().debug((Object)("RATIO WITH RESPECT TO THE PREVIOUS FREQ:" + (peakFreq - previousFreq) / error));
                    if (counter == 0) {
                        AnalysisLogger.getLogger().debug((Object)("Section " + (i + 1)));
                        peaks.put("*StartTime_In_Spectrogram" + prefix, "" + startTime);
                        peaks.put("*EndTime_In_Spectrogram" + prefix, "" + endTime);
                    }
                    double lowermeanF = Math.max(peakFreq - error, (double)minPossibleFreq);
                    double uppermeanF = Math.min(peakFreq + error, (double)maxPossibleFreq);
                    double upperUncertPeriod = 0.0;
                    double lowerUncertPeriod = 0.0;
                    if (peakFreq - previousFreq > error) {
                        upperUncertPeriod = MathFunctions.roundDecimal(1.0 / lowermeanF, 2);
                        lowerUncertPeriod = MathFunctions.roundDecimal(1.0 / uppermeanF, 2);
                    } else {
                        upperUncertPeriod = MathFunctions.roundDecimal(period + periodResolution / 2.0, 2);
                        lowerUncertPeriod = Math.max((double)(1 / samplingRate), MathFunctions.roundDecimal(period - periodResolution / 2.0, 2));
                    }
                    peaks.put("Period_" + (counter + 1) + prefix, MathFunctions.roundDecimal(period, 2) + " ~ [" + lowerUncertPeriod + ";" + upperUncertPeriod + "]");
                    peaks.put("Frequency_" + (counter + 1) + prefix, MathFunctions.roundDecimal(peakFreq, 2) + " ~ [" + MathFunctions.roundDecimal(lowermeanF, 2) + ";" + MathFunctions.roundDecimal(uppermeanF, 2) + "]");
                    peaks.put("Strength_of_Periodicity_" + (counter + 1) + prefix, MathFunctions.roundDecimal(signalMaximumAnalyzer.currentSpikesPowerSpectra[i].get(freqCounter), 2) + " (" + this.getPowerSpectrumStregthInterpretation(signalMaximumAnalyzer.currentSpikesPowerSpectra[i].get(freqCounter)) + ")");
                    int minFidx = SignalConverter.frequencyIndex(minPossibleFreq, this.currentWindowAnalysisSamples, samplingRate);
                    double spectrogramidx = SignalConverter.spectrumFreq2Idx(peakFreq.floatValue(), samplingRate, this.currentWindowAnalysisSamples) - minFidx;
                    AnalysisLogger.getLogger().debug((Object)("SpectorgramIdx_" + (counter + 1) + ":" + spectrogramidx));
                    AnalysisLogger.getLogger().debug((Object)("Strength_of_Periodicity_" + (counter + 1) + ":" + signalMaximumAnalyzer.currentSpikesPowerSpectra[i].get(freqCounter)));
                    AnalysisLogger.getLogger().debug((Object)("Strength_of_Periodicity_Interpretation" + (counter + 1) + ":" + this.getPowerSpectrumStregthInterpretation(signalMaximumAnalyzer.currentSpikesPowerSpectra[i].get(freqCounter))));
                    AnalysisLogger.getLogger().debug((Object)("Frequency_" + (counter + 1) + ":" + peakFreq));
                    AnalysisLogger.getLogger().debug((Object)("UpperFrequencyConfidence_" + (counter + 1) + ":" + uppermeanF));
                    AnalysisLogger.getLogger().debug((Object)("LowerFrequencyConfidence_" + (counter + 1) + ":" + lowermeanF));
                    AnalysisLogger.getLogger().debug((Object)("Period:" + period));
                    AnalysisLogger.getLogger().debug((Object)("UpperFrequencyPeriod_" + (counter + 1) + ":" + 1.0 / lowermeanF));
                    AnalysisLogger.getLogger().debug((Object)("LowerFrequencyPeriod_" + (counter + 1) + ":" + 1.0 / uppermeanF));
                    AnalysisLogger.getLogger().debug((Object)"");
                    ++counter;
                    previousFreq = peakFreq;
                    previousPeriod = period;
                }
                ++freqCounter;
            }
            if (counter != 0) continue;
            peaks.put("Periodicity_" + (counter + 1) + prefix, "No periodicities found");
        }
        return peaks;
    }
}

