/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.processing;

import org.gcube.contentmanagement.graphtools.utils.HttpRequest;
import org.gcube.dataanalysis.ecoengine.configuration.ALG_PROPS;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.gcube.dataanalysis.ecoengine.connectors.RemoteGenerationManager;
import org.gcube.dataanalysis.ecoengine.connectors.RemoteHspecInputObject;
import org.gcube.dataanalysis.ecoengine.connectors.RemoteHspecOutputObject;
import org.gcube.dataanalysis.ecoengine.connectors.livemonitor.ResourceLoad;
import org.gcube.dataanalysis.ecoengine.connectors.livemonitor.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RainyCloudGenerator {
    private static Logger logger = LoggerFactory.getLogger(RainyCloudGenerator.class);
    AlgorithmConfiguration config;
    private boolean interruptProcessing;
    RemoteGenerationManager remoteGenerationManager;
    RemoteHspecInputObject rhio;

    public RainyCloudGenerator(AlgorithmConfiguration config) {
        this.setConfiguration(config);
        this.init();
    }

    public RainyCloudGenerator() {
    }

    public float getStatus() {
        RemoteHspecOutputObject oo = this.remoteGenerationManager.retrieveCompleteStatus();
        if (oo.status.equals("DONE")) {
            this.shutdown();
            return 100.0f;
        }
        float remoteStatus = (float)this.remoteGenerationManager.retrieveCompletion();
        return remoteStatus == 100.0f ? 99.0f : remoteStatus;
    }

    public void init() {
        this.interruptProcessing = false;
        this.rhio = new RemoteHspecInputObject();
        this.rhio.userName = this.config.getParam("ServiceUserName");
        this.rhio.environment = this.config.getParam("RemoteEnvironment");
        this.rhio.configuration = this.config.getGeneralProperties();
        this.rhio.generativeModel = this.config.getModel();
        String jdbcUrl = this.config.getParam("DatabaseURL");
        String userName = this.config.getParam("DatabaseUserName");
        String password = this.config.getParam("DatabasePassword");
        jdbcUrl = jdbcUrl + ";username=" + userName + ";password=" + password;
        this.rhio.hcafTableName.tableName = this.config.getParam("CsquarecodesTable");
        this.rhio.hcafTableName.jdbcUrl = jdbcUrl;
        this.rhio.hspecDestinationTableName.tableName = this.config.getParam("DistributionTable");
        this.rhio.hspecDestinationTableName.jdbcUrl = jdbcUrl;
        this.rhio.hspenTableName.tableName = this.config.getParam("EnvelopeTable");
        this.rhio.hspenTableName.jdbcUrl = jdbcUrl;
        this.rhio.occurrenceCellsTable.tableName = "maxminlat_" + this.config.getParam("EnvelopeTable");
        this.rhio.occurrenceCellsTable.jdbcUrl = jdbcUrl;
        this.rhio.nWorkers = this.config.getNumberOfResources();
        this.rhio.is2050 = this.config.getModel().contains("2050");
        this.rhio.isNativeGeneration = this.config.getModel().contains("NATIVE");
        this.remoteGenerationManager = new RemoteGenerationManager(this.config.getParam("RemoteCalculator"));
    }

    public void setConfiguration(AlgorithmConfiguration config) {
        this.config = config;
    }

    public void shutdown() {
        this.interruptProcessing = true;
    }

    public String getResourceLoad() {
        String returnString = "[]";
        try {
            RemoteHspecOutputObject rhoo = this.remoteGenerationManager.retrieveCompleteStatus();
            if (rhoo.metrics.throughput.size() > 1) {
                ResourceLoad rs = new ResourceLoad(rhoo.metrics.throughput.get(0), rhoo.metrics.throughput.get(1).longValue());
                returnString = rs.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return returnString;
    }

    public String getResources() {
        Resources res = new Resources();
        try {
            RemoteHspecOutputObject rhoo = this.remoteGenerationManager.retrieveCompleteStatus();
            res.list = rhoo.metrics.load;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (res != null && res.list != null) {
            return HttpRequest.toJSon(res.list).replace("resId", "resID");
        }
        return "[]";
    }

    public String getLoad() {
        RemoteHspecOutputObject rhoo = this.remoteGenerationManager.retrieveCompleteStatus();
        String returnString = "[]";
        if (rhoo.metrics.throughput != null && rhoo.metrics.throughput.size() > 1) {
            ResourceLoad rs = new ResourceLoad(rhoo.metrics.throughput.get(0), rhoo.metrics.throughput.get(1).longValue());
            returnString = rs.toString();
        }
        return returnString;
    }

    public void generate() throws Exception {
        try {
            this.remoteGenerationManager.submitJob(this.rhio);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.trace("REMOTE PROCESSING STARTED");
        boolean finish = false;
        while (!finish && !this.interruptProcessing) {
            float status = this.getStatus();
            if (status == 100.0f) {
                finish = true;
            }
            Thread.sleep(500L);
        }
        logger.trace("REMOTE PROCESSING ENDED");
    }

    public ALG_PROPS[] getSupportedAlgorithms() {
        ALG_PROPS[] p = new ALG_PROPS[]{ALG_PROPS.SPECIES_VS_CSQUARE_REMOTE_FROM_DATABASE};
        return p;
    }

    public INFRASTRUCTURE getInfrastructure() {
        return INFRASTRUCTURE.D4SCIENCE;
    }
}

