/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.lexicalmatcher.analysis.run;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.Engine;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.LexicalEngineConfiguration;
import org.gcube.contentmanagement.lexicalmatcher.analysis.guesser.data.Category;
import org.gcube.contentmanagement.lexicalmatcher.analysis.guesser.data.CategoryOrderedList;
import org.gcube.contentmanagement.lexicalmatcher.analysis.guesser.data.DBObjectTranslator;
import org.gcube.contentmanagement.lexicalmatcher.analysis.guesser.data.SingleResult;
import org.gcube.contentmanagement.lexicalmatcher.analysis.guesser.data.TSObjectTransformer;
import org.gcube.contentmanagement.lexicalmatcher.analysis.guesser.interfaces.Reference;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategoryGuesser {
    private static Logger logger = LoggerFactory.getLogger(CategoryGuesser.class);
    private static final int MAXRESULTS = 10;
    private static final String cfgFile = "lexicalguesser/lexicalGuesser.properties";
    private static final String LogFile = "lexicalguesser/ALog.properties";
    private CategoryOrderedList col;
    private Engine processor;
    private CategoryOrderedList originalCol;
    private LexicalEngineConfiguration config;
    private boolean oneshotMode;
    private static final int maxTriesClassification = 3;
    private int triesCounter = 0;
    ArrayList<SingleResult> lastResults;

    public static void showResults(ArrayList<SingleResult> results) {
        logger.warn("CLASSIFICATION RESULT:\n");
        int i = 1;
        for (SingleResult result : results) {
            if (result.getColumn() != null) {
                logger.warn(i + ": " + result.getCategory() + " - " + result.getColumn() + " ; SCORE: " + result.getStringScore() + "%");
            } else {
                logger.warn(i + ": " + result.getCategory() + " ; SCORE: " + result.getStringScore() + "%");
            }
            ++i;
        }
    }

    public static void AccuracyCalc(CategoryGuesser guesser, String configPath, String seriesName, String column, int attempts, String correctFamily, String correctColumn) throws Exception {
        CategoryGuesser.AccuracyCalc(null, guesser, configPath, seriesName, column, attempts, correctFamily, correctColumn);
    }

    public static void AccuracyCalc(LexicalEngineConfiguration externalcfg, CategoryGuesser guesser, String configPath, String seriesName, String column, int attempts, String correctFamily, String correctColumn) throws Exception {
        int familyscore = 0;
        int columnscore = 0;
        for (int i = 0; i < attempts; ++i) {
            guesser.runGuesser(seriesName, column, externalcfg);
            ArrayList<SingleResult> results = guesser.getClassification();
            String result = results.toString();
            CategoryGuesser.showResults(results);
            logger.info("CLASSIFICATION RESULT " + result + " " + CategoryGuesser.resultString(result, correctFamily, correctColumn));
            if (CategoryGuesser.CheckCompleteResult(result, correctFamily, correctColumn)) {
                ++columnscore;
            }
            if (!CategoryGuesser.CheckFamilyResult(result, correctFamily)) continue;
            ++familyscore;
        }
        double percColumn = (double)columnscore / (double)attempts * 100.0;
        double percFamily = (double)familyscore / (double)attempts * 100.0;
        logger.info("->ACCURACY ON FAMILY " + correctFamily + ":" + percFamily + " ACCURACY ON COLUMN " + correctColumn + ":" + percColumn);
    }

    public static String resultString(String result, String family, String column) {
        result = result.toUpperCase();
        family = family.toUpperCase();
        column = column.toUpperCase();
        return "FAMILY REC: " + result.contains(family) + " COLUMN REC: " + result.contains(family + "=" + column);
    }

    public static boolean CheckCompleteResult(String result, String family, String column) {
        result = result.toUpperCase();
        family = family.toUpperCase();
        column = column.toUpperCase();
        return result.contains(family + "=" + column);
    }

    public static boolean CheckFamilyResult(String result, String family) {
        return (result = result.toUpperCase()).contains((family = family.toUpperCase()) + "=");
    }

    public void runGuesser(String seriesName, String columnName, LexicalEngineConfiguration externalConfig) throws Exception {
        this.runGuesser(seriesName, columnName, externalConfig, null, null);
    }

    public void runGuesser(String seriesName, String columnName) throws Exception {
        this.runGuesser(seriesName, columnName, null, null, null);
    }

    public void runGuesser(String seriesName, String columnName, LexicalEngineConfiguration externalConfig, String CategoryFilter, String ColumnFilter) throws Exception {
        this.runGuesser(seriesName, columnName, externalConfig, CategoryFilter, ColumnFilter, null);
    }

    public void runGuesser(String SingletonString, LexicalEngineConfiguration externalConfig, String CategoryFilter, String ColumnFilter) throws Exception {
        this.oneshotMode = true;
        this.runGuesser(null, null, externalConfig, CategoryFilter, ColumnFilter, SingletonString);
    }

    public void init(String categoryFilter, String columnFilter, LexicalEngineConfiguration externalConfig) throws Exception {
        String cfgFileCompletePath = cfgFile;
        logger.trace("******************INITIALIZING******************");
        this.config = new LexicalEngineConfiguration();
        this.config.configureByStream(cfgFileCompletePath);
        if (externalConfig != null) {
            this.config.mergeConfig(externalConfig);
        }
        this.processor = new Engine(this.config, columnFilter);
        SessionFactory dbSession = this.processor.getDBSession(this.config);
        DBObjectTranslator dbo = new DBObjectTranslator();
        if (this.col == null) {
            logger.trace("******************Order Category******************");
            if (externalConfig == null) {
                externalConfig = new LexicalEngineConfiguration();
            }
            if (externalConfig.getCategories() != null && externalConfig.getCategories().size() > 0) {
                dbo.categories = externalConfig.getCategories();
            } else {
                dbo.buildCategoriesStructure(dbSession, externalConfig.getReferenceTable(), externalConfig.getReferenceColumn(), externalConfig.getIdColumn(), externalConfig.getNameHuman(), externalConfig.getDescription());
            }
            this.col = TSObjectTransformer.transform2List(dbo, this.config, categoryFilter);
            logger.trace("***************End Ordering********************");
            this.originalCol = this.col.generateNovelList();
        } else {
            this.col = this.originalCol.generateNovelList();
        }
        this.oneshotMode = false;
    }

    public void initSingleMatcher(LexicalEngineConfiguration externalConfig, String ColumnFilter) throws Exception {
        String cfgFileCompletePath = cfgFile;
        this.config = new LexicalEngineConfiguration();
        this.config.configureByStream(cfgFileCompletePath);
        if (externalConfig != null) {
            this.config.mergeConfig(externalConfig);
        }
        this.processor = new Engine(this.config, ColumnFilter);
        this.oneshotMode = true;
    }

    public void init(String categoryFilter, String columnFilter) throws Exception {
        this.init(categoryFilter, columnFilter, null);
    }

    public void init(LexicalEngineConfiguration externalConfig) throws Exception {
        this.init(null, null, externalConfig);
    }

    public void init() throws Exception {
        this.init(null, null, null);
    }

    public void refreshReferences() {
        this.col = null;
    }

    public ArrayList<SingleResult> getLastResults() {
        return this.lastResults;
    }

    public void runGuesser(String seriesName, String columnName, LexicalEngineConfiguration externalConfig, String CategoryFilter, String ColumnFilter, String SingletonString) throws Exception {
        SessionFactory dbSession = null;
        String cfgFileCompletePath = cfgFile;
        logger.debug("Guessing Table " + seriesName + " column " + columnName);
        if (externalConfig != null) {
            this.config = new LexicalEngineConfiguration();
            this.config.configureByStream(cfgFileCompletePath);
            this.config.mergeConfig(externalConfig);
            this.processor = new Engine(this.config, ColumnFilter);
        } else {
            if (this.config == null) {
                this.config = new LexicalEngineConfiguration();
                this.config.configure(cfgFileCompletePath);
            }
            if (this.processor == null) {
                this.processor = new Engine(this.config, ColumnFilter);
            } else {
                this.processor.resetEngine(this.config, ColumnFilter);
            }
        }
        dbSession = this.processor.getDBSession(this.config);
        DBObjectTranslator dbo = new DBObjectTranslator();
        logger.trace("******************Order Category******************");
        if (externalConfig != null) {
            ArrayList<Category> externalcategories = externalConfig.getCategories();
            if (externalcategories != null && externalcategories.size() > 0) {
                dbo.categories = externalConfig.getCategories();
                dbo.calculateCategoriesWeights(dbSession);
            } else {
                dbo.buildCategoriesStructure(dbSession, this.config.getReferenceTable(), this.config.getReferenceColumn(), this.config.getIdColumn(), this.config.getNameHuman(), this.config.getDescription());
            }
        }
        this.col = TSObjectTransformer.transform2List(dbo, this.config, CategoryFilter);
        logger.trace("***************End Ordering********************");
        this.originalCol = this.col.generateNovelList();
        logger.warn("Starting Calculation...wait...");
        long t0 = System.currentTimeMillis();
        this.processor.calcLikeThread(this.col, seriesName, columnName, SingletonString);
        ArrayList<SingleResult> checkingResults = null;
        checkingResults = this.getClassification();
        while ((checkingResults == null || checkingResults.size() == 0) && this.triesCounter < 3) {
            logger.warn("..another processing pass is required. Attempt number " + (this.triesCounter + 1));
            ++this.triesCounter;
            float differencialThr = this.config.getCategoryDiscardDifferencialThreshold();
            float acceptanceThr = this.config.getEntryAcceptanceThreshold();
            this.config.setCategoryDiscardDifferencialThreshold(Math.max(differencialThr - 20.0f, 0.0f));
            this.config.setEntryAcceptanceThreshold(Math.max(acceptanceThr - 20.0f, 0.0f));
            logger.trace("Performing next processing pass");
            this.runGuesser(seriesName, columnName, externalConfig, CategoryFilter, ColumnFilter, SingletonString);
            logger.debug("End processing pass");
            checkingResults = this.getClassification();
            if (this.triesCounter != 0) continue;
            break;
        }
        long t1 = System.currentTimeMillis() - t0;
        logger.warn("...End Calculation in " + t1 + "ms");
        this.triesCounter = 0;
        this.lastResults = checkingResults;
        if (this.oneshotMode) {
            dbSession.close();
        }
    }

    public ArrayList<SingleResult> getClassificationOLD() {
        ArrayList<SingleResult> results = new ArrayList<SingleResult>();
        int size = this.processor.bestCategories.size();
        for (int i = 0; i < size; ++i) {
            results.add(new SingleResult(this.processor.bestCategories.get(i), this.processor.bestColumns.get(i), this.processor.bestScores.get(i), null, "0"));
        }
        return results;
    }

    public ArrayList<SingleResult> getDetailedMatches() {
        if (this.processor.getSingletonMatches() != null) {
            float threshold = this.config.getSingleEntryRecognitionMaxDeviation();
            ArrayList<SingleResult> results = this.processor.getSingletonMatches();
            double minScore = 0.0;
            if (results.size() > 0) {
                minScore = results.get(0).getScore() - (double)threshold;
            }
            int size = results.size();
            for (int i = 0; i < size; ++i) {
                SingleResult sr = results.get(i);
                if (!(sr.getScore() < minScore)) continue;
                results.remove(i);
                --i;
                --size;
            }
            return this.processor.getSingletonMatches();
        }
        return new ArrayList<SingleResult>();
    }

    public String getDetailedSingletonEntry() {
        if (this.processor.getSingletonElement() != null) {
            return this.processor.getSingletonElement();
        }
        return "";
    }

    public ArrayList<SingleResult> getClassificationPlain() {
        double score;
        int i;
        ArrayList<SingleResult> results = new ArrayList<SingleResult>();
        int size = this.processor.bestCategories.size();
        double maxscore = 0.0;
        for (i = 0; i < size; ++i) {
            score = this.processor.bestScores.get(i);
            if (!(maxscore < score)) continue;
            maxscore = score;
        }
        for (i = 0; i < size; ++i) {
            score = this.processor.bestScores.get(i);
            if (!((score = score / (maxscore + (double)(size > 1 ? 1 : 0)) * 100.0) > (double)this.config.categoryDiscardDifferencialThreshold)) continue;
            Reference ref = this.col.getCategory(this.processor.bestCategories.get(i));
            results.add(new SingleResult(this.processor.bestCategories.get(i), this.processor.bestColumns.get(i), score, ref.getTableName(), ref.getIndex()));
        }
        return results;
    }

    public ArrayList<SingleResult> getClassification() {
        int i;
        ArrayList<SingleResult> results = new ArrayList<SingleResult>();
        int size = this.processor.bestCategories.size();
        double maxscore = 0.0;
        BigDecimal sumElements = BigDecimal.ZERO;
        ArrayList<Double> subscores = new ArrayList<Double>();
        for (i = 0; i < size; ++i) {
            BigInteger catElements = this.col.getScoresTable().get(this.processor.bestCategories.get(i)).getCategoryElements();
            sumElements = sumElements.add(new BigDecimal(catElements));
        }
        for (i = 0; i < size; ++i) {
            double score = this.processor.bestScores.get(i);
            BigInteger catElements = this.col.getScoresTable().get(this.processor.bestCategories.get(i)).getCategoryElements();
            double weight = new BigDecimal(catElements).divide(sumElements, 2, 4).doubleValue();
            if (weight >= 3.0) {
                weight = 2.0 * Math.log(weight * 100.0) / 10.0;
            } else if (weight >= 0.5 && weight <= 1.0) {
                weight = Math.log(weight * 100.0) / 100.0;
            } else if (weight < 0.05) {
                weight = 0.05;
            }
            logger.warn("WEIGHT FOR CATEGORY " + this.processor.bestCategories.get(i) + "-" + this.processor.bestColumns.get(i) + " : " + weight + " SCORE " + score);
            score *= weight;
            score = Math.min(1.0, score);
            if (maxscore < score) {
                maxscore = score;
            }
            subscores.add(score);
        }
        for (i = 0; i < size; ++i) {
            double score = (Double)subscores.get(i);
            if (!((score = score / (maxscore + (double)(size > 1 ? 1 : 0)) * 100.0) > (double)this.config.categoryDiscardDifferencialThreshold)) continue;
            int index = results.size();
            int j = 0;
            for (SingleResult res : results) {
                if (res.getScore() < score) {
                    index = j;
                }
                ++j;
            }
            Reference ref = this.col.getCategory(this.processor.bestCategories.get(i));
            SingleResult sr = new SingleResult(this.processor.bestCategories.get(i), this.processor.bestColumns.get(i), score, ref.getTableName(), ref.getIndex());
            if (!this.isnotRepetition(sr, results)) continue;
            results.add(index, sr);
        }
        int s = results.size();
        if (s > 10) {
            int diff = size - 10;
            for (int i2 = 0; i2 < diff; ++i2) {
                s = results.size();
                results.remove(s - 1);
            }
        }
        return results;
    }

    private ArrayList<SingleResult> deleteDuplicates(ArrayList<SingleResult> results) {
        HashMap<String, SingleResult> map = new HashMap<String, SingleResult>();
        ArrayList<SingleResult> newResults = new ArrayList<SingleResult>();
        for (SingleResult res : results) {
            String index = res.toString();
            SingleResult sr = (SingleResult)map.get(index.toString());
            if (sr != null) continue;
            map.put(index, res);
            newResults.add(sr);
        }
        return newResults;
    }

    private boolean isnotRepetition(SingleResult result, ArrayList<SingleResult> previous) {
        boolean notrepeated = true;
        int size = previous.size();
        for (int i = 0; i < size; ++i) {
            SingleResult sr = previous.get(i);
            if (!sr.getCategory().equalsIgnoreCase(result.getCategory()) || !sr.getColumn().equalsIgnoreCase(result.getColumn())) continue;
            notrepeated = true;
            break;
        }
        return notrepeated;
    }

    public void shutdown() {
        try {
            if (!this.processor.getDBSession().isClosed()) {
                this.processor.getDBSession().close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

