/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.lexicalmatcher.analysis.guesser.treeStructure.chunks;

import java.math.BigInteger;
import java.util.ArrayList;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.Engine;
import org.gcube.contentmanagement.lexicalmatcher.analysis.guesser.data.DBObjectTranslator;
import org.gcube.contentmanagement.lexicalmatcher.analysis.guesser.data.Entry;
import org.gcube.contentmanagement.lexicalmatcher.analysis.guesser.treeStructure.chunks.Chunk;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceChunk
extends Chunk {
    private static Logger logger = LoggerFactory.getLogger(ReferenceChunk.class);
    private String categoryName;
    private String categoryTableName;
    private ArrayList<Entry> referenceEntries;
    private BigInteger startPoint;
    private int chunkSize;

    public ReferenceChunk(String CategoryName, String CategoryTableName, BigInteger StartPoint, int ChunkSize, Engine engine) {
        super(engine);
        this.chunkSize = ChunkSize;
        this.categoryName = CategoryName;
        this.categoryTableName = CategoryTableName;
        this.startPoint = StartPoint;
        logger.trace("ReferenceChunk-> \t\tTOOK CATEGORY CHUNK FOR CATEGORY: " + this.categoryName + " - index : " + this.startPoint);
    }

    public ArrayList<Entry> getReferenceEntries() throws Exception {
        DBObjectTranslator dbo = new DBObjectTranslator();
        SessionFactory sess = this.engine.getDBSession();
        this.referenceEntries = dbo.retrieveEntries(sess, this.categoryTableName, this.startPoint, this.chunkSize);
        return this.referenceEntries;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getCategoryName() {
        return this.categoryName;
    }
}

