/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.lexicalmatcher.analysis.guesser.treeStructure.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.swing.JApplet;
import org.gcube.contentmanagement.lexicalmatcher.analysis.guesser.treeStructure.graph.CustomListenableDirectedWeightedGraph;
import org.gcube.contentmanagement.lexicalmatcher.analysis.guesser.treeStructure.graph.CustomWeightedEdge;
import org.gcube.contentmanagement.lexicalmatcher.analysis.guesser.treeStructure.graph.GraphFramer;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgrapht.Graph;
import org.jgrapht.ext.JGraphModelAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphDisplayer
extends JApplet {
    private static Logger logger = LoggerFactory.getLogger(GraphDisplayer.class);
    private static final Color DEFAULT_BG_COLOR = Color.decode("#FAFBFF");
    private static final Dimension DEFAULT_SIZE = new Dimension(530, 320);
    private JGraphModelAdapter m_jgAdapter;
    public static int WIDTH = 1000;
    public static int HEIGHT = 800;
    public static int WIDTHBOX = 1280;
    public static int HEIGHTBOX = 1024;
    private int newxposition = 10;
    private int newyposition = 10;
    private CustomListenableDirectedWeightedGraph g = new CustomListenableDirectedWeightedGraph(CustomWeightedEdge.class);
    private int nodesCounter = 0;
    private static final int minx = 10;
    private static final int miny = 10;
    ArrayList<String> VertexNames;
    HashMap<String, String> Edges;

    public void generatePosition(int lastxPosition, int lastyposition) {
        int rangex = WIDTH - lastxPosition;
        Random a = new Random();
        int newx = lastxPosition + 70 + (int)((double)rangex * a.nextDouble());
        boolean epsilon = true;
        int newy = lastyposition + (int)((double)((float)epsilon * 20.0f) * Math.random());
        if (newx > WIDTH) {
            newx = WIDTH - 100;
        }
        if (newx < lastxPosition - 90) {
            newx = lastxPosition + 90;
        }
        if (newy > HEIGHT) {
            newy = HEIGHT - 10;
        }
        if (newy < 0) {
            newy = 0;
        }
        this.newxposition = newx;
        this.newyposition = newy;
    }

    @Override
    public void init() {
        logger.debug("INIZIALIZZATO!");
        JGraph jgraph = new JGraph((GraphModel)this.m_jgAdapter);
        this.adjustDisplaySettings(jgraph);
        this.getContentPane().add((Component)jgraph);
        this.resize(DEFAULT_SIZE);
        logger.debug("RESIZED!");
    }

    public void generateGraph() {
        for (String v : this.VertexNames) {
            this.genPositionVertex(v);
        }
    }

    public void generateRandomGraph() {
        for (String v : this.VertexNames) {
            int randx = 10 + (int)((double)(WIDTH - 100) * Math.random());
            int randy = 10 + (int)((double)(HEIGHT - 100) * Math.random());
            this.positionVertexAt(v, randx, randy);
        }
    }

    public void generateUpTo5StarGraph() {
        HashMap<String, Integer> vertexFrequencies = new HashMap<String, Integer>();
        for (String string : this.Edges.values()) {
            System.out.println(string + "-" + vertexFrequencies.get(string));
            if (vertexFrequencies.get(string) != null) {
                int f = (Integer)vertexFrequencies.get(string);
                vertexFrequencies.put(string, new Integer(f + 1));
                continue;
            }
            vertexFrequencies.put(string, new Integer(0));
        }
        for (String string : this.VertexNames) {
            if (this.Edges.get(string) != null) continue;
            boolean trovato = false;
            for (String starvertex : this.Edges.values()) {
                if (!string.equals(starvertex)) continue;
                trovato = true;
                break;
            }
            if (trovato) continue;
            System.out.println("aggiunto vertice isolato " + string);
            vertexFrequencies.put(string, new Integer(0));
        }
        System.out.println("FEQS " + vertexFrequencies.toString());
        ArrayList<String> starList = new ArrayList<String>();
        for (String vertex : vertexFrequencies.keySet()) {
            int freq = (Integer)vertexFrequencies.get(vertex);
            int i = 0;
            boolean trovato = false;
            for (String element : starList) {
                int referfreq = (Integer)vertexFrequencies.get(element);
                if (referfreq < freq) {
                    starList.add(i, vertex);
                    trovato = true;
                    break;
                }
                ++i;
            }
            if (trovato) continue;
            starList.add(vertex);
        }
        System.out.println(starList.toString());
        int n = 200;
        int[] boundedXIndexex = new int[]{n, WIDTH - n, n, WIDTH - n, WIDTH / 2};
        int[] boundedYIndexex = new int[]{n, n, HEIGHT - n, HEIGHT - n, HEIGHT / 2};
        int sizeStar = starList.size();
        for (int i = 0; i < sizeStar; ++i) {
            this.positionVertexAt(starList.get(i), boundedXIndexex[i], boundedYIndexex[i]);
            int countelems = 0;
            for (String edge : this.Edges.keySet()) {
                if (!this.Edges.get(edge).equals(starList.get(i))) continue;
                ++countelems;
            }
            if (countelems <= 0) continue;
            double subdivision = 360 / countelems;
            double angle = 105.0;
            double radius = 200.0;
            System.out.println("Numero di elementi nella stella: " + countelems + " suddivisioni: " + subdivision);
            for (String edge : this.Edges.keySet()) {
                if (!this.Edges.get(edge).equals(starList.get(i))) continue;
                int currentx = boundedXIndexex[i];
                int currenty = boundedYIndexex[i];
                int epsilonx = (int)(radius * Math.cos(Math.toRadians(angle)));
                int epsilony = (int)(radius * Math.sin(Math.toRadians(angle)));
                System.out.println("angolo attuale: " + angle + " x0: " + currentx + " y0 " + currenty + " ex " + epsilonx + " ey " + epsilony);
                this.positionVertexAt(edge, currentx + epsilonx, currenty + epsilony);
                angle += subdivision;
            }
        }
    }

    private void genPositionVertex(String vertexName) {
        if (this.nodesCounter > 0) {
            if (this.nodesCounter % 2 == 0) {
                this.newxposition = 10 + (int)(20.0 * Math.random());
                this.newyposition += 100;
            } else {
                this.generatePosition(this.newxposition, this.newyposition);
            }
        }
        this.positionVertexAt(vertexName, this.newxposition, this.newyposition);
        ++this.nodesCounter;
    }

    public GraphDisplayer() {
        this.m_jgAdapter = new JGraphModelAdapter((Graph)this.g);
        this.VertexNames = new ArrayList();
        this.Edges = new HashMap();
    }

    public void addVertex(String name) {
        this.g.addVertex(name);
        this.VertexNames.add(name);
    }

    public void addEdge(String v1, String v2, double bi) {
        CustomWeightedEdge ed = (CustomWeightedEdge)((Object)this.g.addEdge(v1, v2));
        this.g.setEdgeWeight(ed, bi);
        this.Edges.put(v1, v2);
    }

    private void adjustDisplaySettings(JGraph jg) {
        jg.setPreferredSize(DEFAULT_SIZE);
        Color c = DEFAULT_BG_COLOR;
        String colorStr = null;
        try {
            colorStr = this.getParameter("bgcolor");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (colorStr != null) {
            c = Color.decode(colorStr);
        }
        jg.setBackground(c);
    }

    private void positionVertexAt(Object vertex, int x, int y) {
        DefaultGraphCell cell = this.m_jgAdapter.getVertexCell(vertex);
        AttributeMap attr = cell.getAttributes();
        Rectangle2D b = GraphConstants.getBounds((Map)attr);
        GraphConstants.setBounds((Map)attr, (Rectangle2D)new Rectangle(x, y, (int)((double)(((String)vertex).length() + 50) + b.getWidth()), (int)b.getHeight()));
        HashMap<DefaultGraphCell, AttributeMap> cellAttr = new HashMap<DefaultGraphCell, AttributeMap>();
        cellAttr.put(cell, attr);
        this.m_jgAdapter.edit(cellAttr, null, null, null);
    }

    @Override
    public void start() {
        this.repaint();
    }

    public static void main(String[] args) {
        String[] nodi;
        GraphFramer starter = new GraphFramer("Grafo");
        for (String nodo : nodi = new String[]{"ciao", "come", "stai", "oggi", "domani", "dopodomani"}) {
            starter.graphDisplayer.addVertex(nodo);
        }
        for (int j = 0; j < nodi.length; ++j) {
            int i0 = (int)((double)nodi.length * Math.random());
            int i1 = (int)((double)nodi.length * Math.random());
            System.out.println("i0: " + i0 + " i1: " + i1);
            if (i0 == i1) continue;
            starter.graphDisplayer.addEdge(nodi[i0], nodi[i1], 0.0);
        }
        starter.graphDisplayer.generateGraph();
        starter.go();
    }
}

