/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.clustering;

import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.tools.OperatorService;
import java.util.ArrayList;
import java.util.List;
import org.gcube.dataanalysis.ecoengine.clustering.DBScan;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnTypesList;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.ServiceType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.ServiceParameters;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.utils.ResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KMeans
extends DBScan {
    private static Logger logger = LoggerFactory.getLogger(KMeans.class);
    private String kk;
    private String maxRuns;
    private String maxOptimizations;
    ResourceFactory resourceManager;

    @Override
    public void setConfiguration(AlgorithmConfiguration config) {
        if (config != null) {
            this.kk = config.getParam("k");
            this.maxRuns = config.getParam("max_runs");
            this.maxOptimizations = config.getParam("max_optimization_steps");
            this.OccurrencePointsClusterLabel = config.getParam("OccurrencePointsClusterLabel");
            this.OccurrencePointsTable = config.getParam("OccurrencePointsTable").toLowerCase();
            this.OccurrencePointsClusterTable = config.getParam("OccurrencePointsClusterTable").toLowerCase();
            this.FeaturesColumnNames = config.getParam("FeaturesColumnNames");
            this.minPoints = config.getParam("min_points");
            this.config = config;
        }
    }

    @Override
    public void compute() throws Exception {
        try {
            if (this.config == null || this.kk == null || this.maxRuns == null || this.maxOptimizations == null) {
                throw new Exception("KMeans: Error incomplete parameters");
            }
            logger.debug("KMeans: Settin up the cluster");
            com.rapidminer.operator.clustering.clusterer.KMeans kmeans = (com.rapidminer.operator.clustering.clusterer.KMeans)OperatorService.createOperator((String)"KMeans");
            kmeans.setParameter("k", this.kk);
            kmeans.setParameter("max_runs", this.maxRuns);
            kmeans.setParameter("max_optimization_steps", this.maxOptimizations);
            kmeans.setParameter("keep_example_set", "true");
            kmeans.setParameter("add_cluster_attribute", "true");
            IOContainer innerInput = new IOContainer(new IOObject[]{this.points});
            logger.debug("KMeans: Clustering...");
            long ti = System.currentTimeMillis();
            IOContainer output = kmeans.apply(innerInput);
            logger.debug("KMEANS: ...ELAPSED CLUSTERING TIME: " + (System.currentTimeMillis() - ti));
            logger.debug("KMeans: ...Clustering Finished");
            this.status = 70.0f;
            IOObject[] outputvector = output.getIOObjects();
            this.BuildClusterTable(outputvector);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.shutdown();
            this.status = 100.0f;
        }
    }

    @Override
    public List<StatisticalType> getInputParameters() {
        ArrayList<StatisticalType> parameters = new ArrayList<StatisticalType>();
        ArrayList<TableTemplates> templateOccs = new ArrayList<TableTemplates>();
        templateOccs.add(TableTemplates.GENERIC);
        InputTable p1 = new InputTable(templateOccs, "OccurrencePointsTable", "Occurrence Points Table. Max 4000 points", "occurrences");
        ColumnTypesList p2 = new ColumnTypesList("OccurrencePointsTable", "FeaturesColumnNames", "column Names for the features", false);
        PrimitiveType p0 = new PrimitiveType(String.class.getName(), null, PrimitiveTypes.STRING, "OccurrencePointsClusterLabel", "table name of the resulting distribution", "OccCluster_");
        ServiceType p3 = new ServiceType(ServiceParameters.RANDOMSTRING, "OccurrencePointsClusterTable", "table name of the distribution", "occCluster_");
        PrimitiveType p4 = new PrimitiveType(Integer.class.getName(), null, PrimitiveTypes.NUMBER, "k", "expected Number of Clusters", "3");
        PrimitiveType p5 = new PrimitiveType(Integer.class.getName(), null, PrimitiveTypes.NUMBER, "max_runs", "max runs of the clustering procedure", "10");
        PrimitiveType p12 = new PrimitiveType(Integer.class.getName(), null, PrimitiveTypes.NUMBER, "max_optimization_steps", "max number of internal optimization steps", "5");
        PrimitiveType p13 = new PrimitiveType(Integer.class.getName(), null, PrimitiveTypes.NUMBER, "min_points", "number of points which define an outlier set", "2");
        parameters.add(p1);
        parameters.add(p2);
        parameters.add(p0);
        parameters.add(p3);
        parameters.add(p4);
        parameters.add(p5);
        parameters.add(p12);
        parameters.add(p13);
        DatabaseType.addDefaultDBPars(parameters);
        return parameters;
    }

    @Override
    public String getDescription() {
        return "A clustering algorithm for real valued vectors that relies on the k-means algorithm, i.e. a method aiming to partition n observations into k clusters in which each observation belongs to the cluster with the nearest mean, serving as a prototype of the cluster.  A Maximum of 4000 points is allowed.";
    }

    @Override
    public String getResourceLoad() {
        if (this.resourceManager == null) {
            this.resourceManager = new ResourceFactory();
        }
        return this.resourceManager.getResourceLoad(1);
    }

    @Override
    public String getResources() {
        return ResourceFactory.getResources(100.0f);
    }
}

