/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.transducers;

import org.gcube.contentmanagement.lexicalmatcher.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.transducers.OccurrencePointsMerger;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;

public class OccurrencePointsIntersector
extends OccurrencePointsMerger {
    public OccurrencePointsIntersector() {
        this.firstbest = true;
    }

    @Override
    public String getDescription() {
        return "A transducer algorithm that produces a table of species occurrence points that are contained in both the two starting tables where points equivalence is identified via user defined comparison thresholds. Works with up to 10000 points per table. Between two ocurrence sets, it keeps the elements of the Right Set that are similar to elements in the Left Set.";
    }

    @Override
    protected void prepareFinalTable() throws Exception {
        DatabaseFactory.executeSQLUpdate(DatabaseUtils.createBlankTableFromAnotherStatement(this.leftTableName, this.finalTableName), this.dbconnection);
    }

    @Override
    protected void manageHighProbability(float probability, OccurrencePointsMerger.OccurrenceRecord leftOcc, OccurrencePointsMerger.OccurrenceRecord rightOcc) {
        this.objectstoinsert.add(rightOcc);
    }

    @Override
    protected void manageLowProbability(float probability, OccurrencePointsMerger.OccurrenceRecord leftOcc, OccurrencePointsMerger.OccurrenceRecord rightOcc) {
    }
}

