/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.interfaces;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.interfaces.Evaluator;
import org.gcube.dataanalysis.ecoengine.utils.ResourceFactory;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataAnalysis
implements Evaluator {
    private static Logger logger = LoggerFactory.getLogger(DataAnalysis.class);
    protected ResourceFactory resourceManager;
    protected int processedRecords;
    protected float status;
    protected AlgorithmConfiguration config;
    protected SessionFactory connection;
    LinkedHashMap<String, String> out;

    public abstract LinkedHashMap<String, String> analyze() throws Exception;

    @Override
    public void compute() throws Exception {
        this.status = 0.0f;
        this.out = new LinkedHashMap();
        try {
            this.out = this.analyze();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            this.shutdown();
            this.status = 100.0f;
        }
    }

    @Override
    public StatisticalType getOutput() {
        PrimitiveType p = new PrimitiveType(Map.class.getName(), PrimitiveType.stringMap2StatisticalMap(this.out), PrimitiveTypes.MAP, "AnalysisResult", "Analysis Values");
        return p;
    }

    @Override
    public String getResourceLoad() {
        if (this.resourceManager == null) {
            this.resourceManager = new ResourceFactory();
        }
        return this.resourceManager.getResourceLoad(this.processedRecords);
    }

    @Override
    public String getResources() {
        return ResourceFactory.getResources(100.0f);
    }

    @Override
    public INFRASTRUCTURE getInfrastructure() {
        return INFRASTRUCTURE.LOCAL;
    }

    @Override
    public float getStatus() {
        return this.status;
    }

    public static void visualizeResults(HashMap<String, Object> results) {
        for (String key : results.keySet()) {
            PrimitiveType keyp = (PrimitiveType)results.get(key);
            System.out.println(key + ":" + keyp.getContent());
        }
    }

    @Override
    public void init() throws Exception {
        this.init(true);
    }

    public void init(boolean initRapidMiner) throws Exception {
        this.connection = AlgorithmConfiguration.getConnectionFromConfig(this.config);
        if (initRapidMiner) {
            this.config.initRapidMiner();
        }
    }

    @Override
    public void setConfiguration(AlgorithmConfiguration config) {
        this.config = config;
    }

    @Override
    public void shutdown() {
        try {
            logger.debug("Closing DB connections");
            this.connection.close();
        }
        catch (Exception e) {
            logger.debug("Error in closing DB connections " + e.getLocalizedMessage());
        }
    }
}

