/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.connectors;

import org.gcube.contentmanagement.graphtools.utils.HttpRequest;
import org.gcube.dataanalysis.ecoengine.connectors.RemoteHspecInputObject;
import org.gcube.dataanalysis.ecoengine.connectors.RemoteHspecOutputObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteGenerationManager {
    private static Logger logger = LoggerFactory.getLogger(RemoteGenerationManager.class);
    private final String submissionMethod = "submit";
    private final String statusMethod = "status/";
    private String submissionID;
    private String username;
    private String endpoint;

    public RemoteGenerationManager(String generatorEndPoint) {
        this.endpoint = generatorEndPoint.charAt(generatorEndPoint.length() - 1) == '/' ? generatorEndPoint : generatorEndPoint + "/";
    }

    public void submitJob(RemoteHspecInputObject rhio) throws Exception {
        logger.warn("RemoteGenerationManager: retrieving job information");
        RemoteHspecOutputObject rhoo = null;
        this.username = rhio.userName;
        try {
            rhoo = (RemoteHspecOutputObject)HttpRequest.postJSonData(this.endpoint + "submit", rhio, RemoteHspecOutputObject.class);
            logger.trace("RemoteGenerationManager: job information retrieved");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.trace("RemoteGenerationManager: ERROR - job information NOT retrieved");
            throw e;
        }
        if (rhoo == null || rhoo.id == null) {
            logger.warn("RemoteGenerationManager: ERROR - job ID NOT retrieved " + rhoo.error);
            throw new Exception("RemoteGenerationManager: ERROR - job ID NOT retrieved " + rhoo.error);
        }
        logger.warn("RemoteGenerationManager: job ID retrieved ");
        this.submissionID = rhoo.id;
    }

    public double retrieveCompletion() {
        RemoteHspecOutputObject rhoo = this.retrieveCompleteStatus();
        try {
            double completion = Double.parseDouble(rhoo.completion);
            return completion;
        }
        catch (Exception e) {
            logger.warn("RemoteGenerationManager: ERROR - cannot retrieve information from remote site ", (Throwable)e);
            return 0.0;
        }
    }

    public RemoteHspecOutputObject retrieveCompleteStatus() {
        RemoteHspecOutputObject rhoo = null;
        try {
            rhoo = (RemoteHspecOutputObject)HttpRequest.getJSonData(this.endpoint + "status/" + this.submissionID, null, RemoteHspecOutputObject.class);
        }
        catch (Exception e) {
            logger.warn("RemoteGenerationManager: ERROR - cannot retrieve information from remote site ", (Throwable)e);
        }
        return rhoo;
    }
}

