package org.gcube.dataanalysis.ecoengine.test.checks;

import java.util.HashMap;
import java.util.List;

import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.interfaces.Generator;
import org.gcube.dataanalysis.ecoengine.processing.factories.GeneratorsFactory;

public class TestSingleHSPECGeneration {
	/**
	 * example of parallel processing on a single machine the procedure will generate a new table for a distribution on suitable species
	 * 
	 */

public static void main(String[] args) throws Exception {
		
		List<Generator>  generators = GeneratorsFactory.getGenerators(testConfigLocal());
		generators.get(0).init();
		generate(generators.get(0));
		generators = null;
		
}

	
	private static void generate(Generator generator) throws Exception {

		if (generator != null) {
			TestSingleHSPECGeneration tgs = new TestSingleHSPECGeneration();
			ThreadCalculator tc = tgs.new ThreadCalculator(generator);
			Thread t = new Thread(tc);
			t.start();
			while (generator.getStatus() < 100) {

				String resLoad = generator.getResourceLoad();
				String ress = generator.getResources();
				String species = generator.getLoad();
				System.out.println("LOAD: " + resLoad);
				System.out.println("RESOURCES: " + ress);
				System.out.println("SPECIES: " + species);
				System.out.println("STATUS: " + generator.getStatus());
				Thread.sleep(1000);
			}
		} else
			AnalysisLogger.getLogger().trace("Generator Algorithm Not Supported");

	}

	public class ThreadCalculator implements Runnable {
		Generator dg;

		public ThreadCalculator(Generator dg) {
			this.dg = dg;
		}

		public void run() {
			try {

				dg.compute();

			} catch (Exception e) {
			}
		}

	}
	

	private static AlgorithmConfiguration testConfigLocal() {
		
		AlgorithmConfiguration config = new AlgorithmConfiguration();
		config.setConfigPath("./cfg/");
		config.setPersistencePath("./");
		config.setNumberOfResources(5);
		config.setModel("AQUAMAPS_SUITABLE");
		
		config.setParam("DistributionTable","hspec_suitable_baskingshark_aquamaps");
		config.setParam("CsquarecodesTable","hcaf_d");
		config.setParam("EnvelopeTable","hspen_baskingshark");
		config.setParam("PreprocessedTable", "maxminlat_hspen");
		config.setParam("CreateTable","true");
		/*
		config.setParam("DatabaseUserName","gcube");
		config.setParam("DatabasePassword","d4science2");
		config.setParam("DatabaseURL","jdbc:postgresql://localhost/testdb");
		config.setParam("DatabaseDriver","org.postgresql.Driver");
		*/
		
		return config;
	}
}
