/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.processing;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.gcube.contentmanagement.graphtools.utils.HttpRequest;
import org.gcube.contentmanagement.graphtools.utils.MathFunctions;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.ALG_PROPS;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.gcube.dataanalysis.ecoengine.connectors.livemonitor.ResourceLoad;
import org.gcube.dataanalysis.ecoengine.connectors.livemonitor.Resources;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.interfaces.Generator;
import org.gcube.dataanalysis.ecoengine.interfaces.SpatialProbabilityDistribution;
import org.gcube.dataanalysis.ecoengine.interfaces.SpatialProbabilityDistributionTable;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;
import org.hibernate.SessionFactory;

public class LocalSplitGenerator
implements Generator {
    private AlgorithmConfiguration config;
    private ExecutorService executorService;
    private int numberOfThreadsToUse;
    private boolean[] threadActivity;
    private SessionFactory dbHibConnection;
    private boolean stopInterrupt;
    private boolean flushInterrupt;
    private boolean forceflush;
    private SpatialProbabilityDistributionTable distributionModel;
    private int processedSpeciesCounter;
    private int spaceVectorsNumber;
    private List<Object> environmentVectors;
    private long lastTime;
    private int lastProcessedRecordsNumber;
    private int processedRecordsCounter;
    private float status;
    private int chunksize;
    private Timer writerScheduler;
    ConcurrentLinkedQueue<String> probabilityBuffer;
    String probabilityInsertionStatement = "insert into %1$s (speciesid,csquarecode,probability %ADDEDINFORMATION%) VALUES %2$s";

    public LocalSplitGenerator(AlgorithmConfiguration config) {
        this.setConfiguration(config);
        this.init();
    }

    public LocalSplitGenerator() {
    }

    @Override
    public float getStatus() {
        return this.status;
    }

    @Override
    public String getResourceLoad() {
        long tk = System.currentTimeMillis();
        double activity = Double.valueOf(this.processedRecordsCounter - this.lastProcessedRecordsNumber) * 1000.0 / Double.valueOf(tk - this.lastTime);
        this.lastTime = tk;
        this.lastProcessedRecordsNumber = this.processedRecordsCounter;
        ResourceLoad rs = new ResourceLoad(tk, activity);
        return rs.toString();
    }

    @Override
    public String getResources() {
        Resources res = new Resources();
        try {
            for (int i = 0; i < this.numberOfThreadsToUse; ++i) {
                try {
                    double value = this.threadActivity[i] ? 100.0 : 0.0;
                    res.addResource("Thread_" + (i + 1), value);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (res != null && res.list != null) {
            return HttpRequest.toJSon(res.list).replace("resId", "resID");
        }
        return "";
    }

    @Override
    public String getLoad() {
        long tk = System.currentTimeMillis();
        double activity = this.processedSpeciesCounter;
        ResourceLoad rs = new ResourceLoad(tk, activity);
        return rs.toString();
    }

    @Override
    public void init() {
        AnalysisLogger.setLogger(this.config.getConfigPath() + AlgorithmConfiguration.defaultLoggerFile);
        this.stopInterrupt = false;
        this.flushInterrupt = false;
        this.forceflush = false;
        this.initDBSession();
        try {
            this.initModel();
        }
        catch (Exception e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().error((Object)e);
        }
        this.probabilityBuffer = new ConcurrentLinkedQueue();
        String addedinfo = this.distributionModel.getAdditionalMetaInformation();
        addedinfo = addedinfo == null ? "" : "," + addedinfo.trim();
        this.probabilityInsertionStatement = this.probabilityInsertionStatement.replace("%ADDEDINFORMATION%", addedinfo);
        if (!this.distributionModel.isSynchronousProbabilityWrite()) {
            AnalysisLogger.getLogger().trace((Object)"init()->insertion scheduler initialized");
            this.writerScheduler = new Timer();
            this.writerScheduler.schedule((TimerTask)new DatabaseWriter(), 0L, (long)AlgorithmConfiguration.refreshResourcesTime);
        }
    }

    private void initModel() throws Exception {
        Properties p = AlgorithmConfiguration.getProperties(this.config.getConfigPath() + AlgorithmConfiguration.algorithmsFile);
        String objectclass = p.getProperty(this.config.getModel());
        this.distributionModel = (SpatialProbabilityDistributionTable)Class.forName(objectclass).newInstance();
        this.distributionModel.init(this.config, this.dbHibConnection);
    }

    @Override
    public void setConfiguration(AlgorithmConfiguration config) {
        this.config = config;
        this.numberOfThreadsToUse = config.getNumberOfResources() == 0 ? 1 : config.getNumberOfResources();
    }

    public void initializeThreads() {
        this.executorService = Executors.newFixedThreadPool(this.numberOfThreadsToUse);
        this.threadActivity = new boolean[this.numberOfThreadsToUse];
        for (int j = 0; j < this.threadActivity.length; ++j) {
            this.threadActivity[j] = false;
        }
    }

    public void initDBSession() {
        try {
            if (this.config != null && this.config.getConfigPath() != null) {
                String defaultDatabaseFile = this.config.getConfigPath() + AlgorithmConfiguration.defaultConnectionFile;
                this.config.setDatabaseDriver(this.config.getParam("DatabaseDriver"));
                this.config.setDatabaseUserName(this.config.getParam("DatabaseUserName"));
                this.config.setDatabasePassword(this.config.getParam("DatabasePassword"));
                this.config.setDatabaseURL(this.config.getParam("DatabaseURL"));
                this.dbHibConnection = DatabaseFactory.initDBConnection(defaultDatabaseFile, this.config);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().trace((Object)e);
        }
    }

    private void createTable() throws Exception {
        if (this.config.getParam("CreateTable") != null && this.config.getParam("CreateTable").equalsIgnoreCase("true")) {
            try {
                AnalysisLogger.getLogger().trace((Object)("recreating table: drop table " + this.config.getParam("DistributionTable")));
                DatabaseFactory.executeSQLUpdate("drop table " + this.config.getParam("DistributionTable"), this.dbHibConnection);
                AnalysisLogger.getLogger().trace((Object)"recreating table->OK");
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().trace((Object)("recreating table->" + e.getLocalizedMessage()));
            }
            DatabaseFactory.executeUpdateNoTransaction(this.distributionModel.getDistributionTableStatement(), this.config.getDatabaseDriver(), this.config.getDatabaseUserName(), this.config.getDatabasePassword(), this.config.getDatabaseURL(), true);
            AnalysisLogger.getLogger().trace((Object)"createTable()->OK!");
        }
    }

    @Override
    public void shutdown() {
        this.executorService.shutdown();
        this.stopInterrupt = true;
        if (!this.distributionModel.isSynchronousProbabilityWrite()) {
            while (!this.flushInterrupt) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e) {}
            }
        }
        if (this.writerScheduler != null) {
            try {
                this.writerScheduler.cancel();
                this.writerScheduler.purge();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        AnalysisLogger.getLogger().trace((Object)"CLOSING CONNECTIONS");
        this.dbHibConnection.close();
    }

    private void wait4Thread(int index) {
        while (this.threadActivity[index]) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void compute() throws Exception {
        long tstart = System.currentTimeMillis();
        try {
            AnalysisLogger.getLogger().trace((Object)("generate->Using algorithm " + this.distributionModel.getName()));
            AnalysisLogger.getLogger().trace((Object)"generate->Check for table creation");
            this.createTable();
            AnalysisLogger.getLogger().trace((Object)"generate->Take area reference");
            this.environmentVectors = DatabaseFactory.executeSQLQuery(this.distributionModel.getGeographicalInfoQuery(), this.dbHibConnection);
            AnalysisLogger.getLogger().trace((Object)"generate->Take species reference");
            List<Object> speciesVectors = DatabaseFactory.executeSQLQuery(this.distributionModel.getMainInfoQuery(), this.dbHibConnection);
            AnalysisLogger.getLogger().trace((Object)"generate->got all information");
            this.spaceVectorsNumber = this.environmentVectors.size();
            int speciesVectorNumber = speciesVectors.size();
            this.chunksize = this.spaceVectorsNumber / this.numberOfThreadsToUse;
            if (this.chunksize == 0) {
                this.chunksize = 1;
            }
            int numOfChunks = this.spaceVectorsNumber / this.chunksize;
            if (this.spaceVectorsNumber % this.chunksize != 0) {
                ++numOfChunks;
            }
            AnalysisLogger.getLogger().trace((Object)("generate->Calculation Started with " + numOfChunks + " chunks and " + speciesVectorNumber + " species"));
            this.initializeThreads();
            int overallcounter = 0;
            this.processedSpeciesCounter = 0;
            for (Object species : speciesVectors) {
                int currentThread = 0;
                long computationT0 = System.currentTimeMillis();
                this.distributionModel.singleStepPreprocess(species, this.spaceVectorsNumber);
                AnalysisLogger.getLogger().trace((Object)("-------------------------------------------------> species " + this.distributionModel.getMainInfoID(species) + " - n. " + (this.processedSpeciesCounter + 1)));
                for (int k = 0; k < numOfChunks; ++k) {
                    int start = k * this.chunksize;
                    this.wait4Thread(currentThread);
                    this.startNewTCalc(currentThread, species, start);
                    if (++currentThread >= this.numberOfThreadsToUse) {
                        currentThread = 0;
                    }
                    this.status = (float)overallcounter / (float)(speciesVectorNumber * numOfChunks) * 100.0f;
                    if (this.status == 100.0f) {
                        this.status = 99.0f;
                    }
                    ++overallcounter;
                }
                for (int i = 0; i < this.numberOfThreadsToUse; ++i) {
                    this.wait4Thread(i);
                }
                if (this.distributionModel.isSynchronousProbabilityWrite()) {
                    this.probabilityBuffer = (ConcurrentLinkedQueue)this.distributionModel.filterProbabilitySet(this.probabilityBuffer);
                    DatabaseWriter dbw = new DatabaseWriter();
                    dbw.flushBuffer();
                }
                long computationT1 = System.currentTimeMillis();
                AnalysisLogger.getLogger().trace((Object)("generate->Species Computation Finished in " + (computationT1 - computationT0) + " ms"));
                ++this.processedSpeciesCounter;
                this.distributionModel.singleStepPostprocess(species, this.spaceVectorsNumber);
                if (!this.stopInterrupt) continue;
                break;
            }
            long computationT2 = System.currentTimeMillis();
            AnalysisLogger.getLogger().trace((Object)("generate->All Species Computed in " + (computationT2 - tstart) + " ms"));
        }
        catch (Exception e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().error((Object)e);
            throw e;
        }
        finally {
            try {
                this.distributionModel.postProcess();
                this.shutdown();
            }
            catch (Exception e) {}
            long tend = System.currentTimeMillis();
            long ttotal = tend - tstart;
            AnalysisLogger.getLogger().warn((Object)("generate->Distribution Generator->Algorithm finished in: " + (double)ttotal / 60000.0 + " min\n"));
            this.status = 100.0f;
        }
    }

    private void startNewTCalc(int index, Object speciesVector, int start) {
        this.threadActivity[index] = true;
        ThreadCalculator tc = new ThreadCalculator(index, speciesVector, start);
        this.executorService.submit(tc);
    }

    @Override
    public ALG_PROPS[] getSupportedAlgorithms() {
        ALG_PROPS[] p = new ALG_PROPS[]{ALG_PROPS.SPECIES_VS_CSQUARE_FROM_DATABASE, ALG_PROPS.PARALLEL_SPECIES_VS_CSQUARE_FROM_DATABASE};
        return p;
    }

    @Override
    public INFRASTRUCTURE getInfrastructure() {
        return INFRASTRUCTURE.LOCAL;
    }

    @Override
    public List<StatisticalType> getInputParameters() {
        return new ArrayList<StatisticalType>();
    }

    @Override
    public StatisticalType getOutput() {
        return this.distributionModel.getOutput();
    }

    @Override
    public SpatialProbabilityDistribution getAlgorithm() {
        return this.distributionModel;
    }

    @Override
    public String getDescription() {
        return "A generator based on tabular data production, which splits a distribution on different threads along the species dimension";
    }

    private class DatabaseWriter
    extends TimerTask {
        @Override
        public void run() {
            try {
                if (LocalSplitGenerator.this.forceflush) {
                    AnalysisLogger.getLogger().trace((Object)"\t...flushing on db");
                    this.flushBuffer();
                    AnalysisLogger.getLogger().trace((Object)"\t...finished flushing on db");
                    LocalSplitGenerator.this.forceflush = false;
                }
                if (LocalSplitGenerator.this.stopInterrupt) {
                    AnalysisLogger.getLogger().trace((Object)"\t...finally flushing on db");
                    this.flushBuffer();
                    AnalysisLogger.getLogger().trace((Object)"\t...finished finally flushing on db");
                    LocalSplitGenerator.this.flushInterrupt = true;
                    this.cancel();
                } else if (LocalSplitGenerator.this.probabilityBuffer != null && LocalSplitGenerator.this.probabilityBuffer.size() > AlgorithmConfiguration.chunkSize) {
                    this.writeOnDB(AlgorithmConfiguration.chunkSize);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                AnalysisLogger.getLogger().error((Object)e);
                LocalSplitGenerator.this.flushInterrupt = true;
            }
        }

        public void flushBuffer() {
            if (LocalSplitGenerator.this.probabilityBuffer != null && LocalSplitGenerator.this.probabilityBuffer.size() > 0) {
                while (LocalSplitGenerator.this.probabilityBuffer.size() > AlgorithmConfiguration.chunkSize) {
                    this.writeOnDB(AlgorithmConfiguration.chunkSize);
                }
                this.writeOnDB(LocalSplitGenerator.this.probabilityBuffer.size());
            }
        }

        private void writeOnDB(int endIndex) {
            if (endIndex > 0) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < endIndex; ++i) {
                    sb.append("(" + LocalSplitGenerator.this.distributionModel.filterProbabiltyRow(LocalSplitGenerator.this.probabilityBuffer.poll()) + ")");
                    if (i >= endIndex - 1) continue;
                    sb.append(",");
                }
                String insertionString = String.format(LocalSplitGenerator.this.probabilityInsertionStatement, LocalSplitGenerator.this.config.getParam("DistributionTable"), sb.toString());
                try {
                    DatabaseFactory.executeSQLUpdate(insertionString, LocalSplitGenerator.this.dbHibConnection);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                AnalysisLogger.getLogger().trace((Object)("writeOnDB()->PROBABILITIES BUFFER REMAINING:" + LocalSplitGenerator.this.probabilityBuffer.size()));
                Object var2_2 = null;
            }
        }
    }

    private class ThreadCalculator
    implements Callable<Integer> {
        int threadIndex;
        int spaceindex;
        Object speciesVector;

        public ThreadCalculator(int threadIndex, Object speciesVector, int start) {
            this.threadIndex = threadIndex;
            this.speciesVector = speciesVector;
            this.spaceindex = start;
        }

        @Override
        public Integer call() {
            int max = Math.min(this.spaceindex + LocalSplitGenerator.this.chunksize, LocalSplitGenerator.this.spaceVectorsNumber);
            String speciesID = LocalSplitGenerator.this.distributionModel.getMainInfoID(this.speciesVector);
            for (int i = this.spaceindex; i < max; ++i) {
                float prob = LocalSplitGenerator.this.distributionModel.calcProb(this.speciesVector, LocalSplitGenerator.this.environmentVectors.get(i));
                String geographicalID = LocalSplitGenerator.this.distributionModel.getGeographicalID(LocalSplitGenerator.this.environmentVectors.get(i));
                if ((double)prob > 0.1) {
                    String additionalInformation = LocalSplitGenerator.this.distributionModel.getAdditionalInformation(this.speciesVector, LocalSplitGenerator.this.environmentVectors.get(i));
                    if (additionalInformation == null) {
                        additionalInformation = "";
                    } else if (additionalInformation.length() > 0) {
                        additionalInformation = "," + additionalInformation.trim();
                    }
                    LocalSplitGenerator.this.probabilityBuffer.offer("'" + speciesID + "','" + geographicalID + "','" + MathFunctions.roundDecimal(prob, 2) + "'" + additionalInformation);
                }
                LocalSplitGenerator.this.processedRecordsCounter++;
            }
            ((LocalSplitGenerator)LocalSplitGenerator.this).threadActivity[this.threadIndex] = false;
            return 0;
        }
    }
}

