/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.test.checks;

import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.interfaces.Clusterer;
import org.gcube.dataanalysis.ecoengine.processing.factories.ClusterersFactory;

public class TestClusterer {
    public static void main(String[] args) throws Exception {
        System.out.println("TEST 1");
        List<Clusterer> clus = ClusterersFactory.getClusterers(TestClusterer.testConfigLocal());
        clus.get(0).init();
        TestClusterer.cluster(clus.get(0));
        clus = null;
    }

    private static void cluster(Clusterer clus) throws Exception {
        if (clus != null) {
            TestClusterer tgs;
            TestClusterer testClusterer = tgs = new TestClusterer();
            testClusterer.getClass();
            ThreadCalculator tc = testClusterer.new ThreadCalculator(clus);
            Thread t = new Thread(tc);
            t.start();
            while (clus.getStatus() < 100.0f) {
                System.out.println("STATUS: " + clus.getStatus());
                Thread.sleep(1000L);
            }
        } else {
            AnalysisLogger.getLogger().trace((Object)"Generator Algorithm Not Supported");
        }
    }

    private static AlgorithmConfiguration testConfigLocal() {
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setConfigPath("./cfg/");
        config.setPersistencePath("./");
        config.setParam("OccurrencePointsTable", "occurrence_species_id5397d3c4_a7eb_4227_adb4_d9d7d36e8b21");
        config.setParam("FeaturesColumnNames", "recordedby#basisofrecord#locality");
        config.setParam("OccurrencePointsClusterTable", "occCluster_gp");
        config.setParam("epsilon", "10");
        config.setParam("min_points", "1");
        config.setConfigPath("./cfg/");
        config.setPersistencePath("./");
        config.setNumberOfResources(1);
        config.setAgent("DBSCAN");
        config.setParam("DatabaseUserName", "utente");
        config.setParam("DatabasePassword", "d4science");
        config.setParam("DatabaseURL", "jdbc:postgresql://dbtest.next.research-infrastructures.eu/testdb");
        config.setParam("DatabaseDriver", "org.postgresql.Driver");
        return config;
    }

    public class ThreadCalculator
    implements Runnable {
        Clusterer dg;

        public ThreadCalculator(Clusterer dg) {
            this.dg = dg;
        }

        @Override
        public void run() {
            try {
                this.dg.compute();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

