/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.test.checks;

import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.interfaces.Generator;
import org.gcube.dataanalysis.ecoengine.processing.factories.GeneratorsFactory;

public class TestsTESTGeneration {
    public static void main(String[] args) throws Exception {
        System.out.println("TEST 1");
        List<Generator> generators = GeneratorsFactory.getGenerators(TestsTESTGeneration.testConfig());
        generators.get(0).init();
        TestsTESTGeneration.generate(generators.get(0));
        generators = null;
    }

    private static void generate(Generator generator) throws Exception {
        if (generator != null) {
            TestsTESTGeneration tgs;
            TestsTESTGeneration testsTESTGeneration = tgs = new TestsTESTGeneration();
            testsTESTGeneration.getClass();
            ThreadCalculator tc = testsTESTGeneration.new ThreadCalculator(generator);
            Thread t = new Thread(tc);
            t.start();
            while (generator.getStatus() < 100.0f) {
                String resLoad = generator.getResourceLoad();
                String ress = generator.getResources();
                String species = generator.getLoad();
                System.out.println("LOAD: " + resLoad);
                System.out.println("RESOURCES: " + ress);
                System.out.println("SPECIES: " + species);
                System.out.println("STATUS: " + generator.getStatus());
                Thread.sleep(1000L);
            }
        } else {
            AnalysisLogger.getLogger().trace((Object)"Generator Algorithm Not Supported");
        }
    }

    private static AlgorithmConfiguration testConfig() {
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setConfigPath("./cfg/");
        config.setPersistencePath("./");
        config.setNumberOfResources(2);
        config.setModel("TEST");
        return config;
    }

    public class ThreadCalculator
    implements Runnable {
        Generator dg;

        public ThreadCalculator(Generator dg) {
            this.dg = dg;
        }

        @Override
        public void run() {
            try {
                this.dg.compute();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

