/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.processing.factories;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.ALG_PROPS;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.interfaces.Model;
import org.gcube.dataanalysis.ecoengine.interfaces.Modeler;
import org.gcube.dataanalysis.ecoengine.processing.factories.ProcessorsFactory;

public class ModelersFactory {
    public static Modeler getModeler(AlgorithmConfiguration config) throws Exception {
        Modeler modlr = (Modeler)ProcessorsFactory.getProcessor(config, config.getConfigPath() + AlgorithmConfiguration.generatorsFile);
        return modlr;
    }

    public static List<String> getModels(String configPath) throws Exception {
        List<String> models = ProcessorsFactory.getClasses(configPath + AlgorithmConfiguration.modelsFile);
        return models;
    }

    public static List<String> getModelers(String configPath) throws Exception {
        List<String> modelers = ProcessorsFactory.getClasses(configPath + AlgorithmConfiguration.modelersFile);
        return modelers;
    }

    public static List<StatisticalType> getModelParameters(String configPath, String algorithmName) throws Exception {
        List<StatisticalType> inputs = ProcessorsFactory.getParameters(configPath + AlgorithmConfiguration.modelsFile, algorithmName);
        return inputs;
    }

    public static String getDescription(String configPath, String algorithmName) throws Exception {
        String input = ProcessorsFactory.getDescription(configPath + AlgorithmConfiguration.modelsFile, algorithmName);
        return input;
    }

    public static List<Modeler> getModelers(AlgorithmConfiguration config) throws Exception {
        ArrayList<Modeler> modelers = new ArrayList<Modeler>();
        try {
            AnalysisLogger.setLogger(config.getConfigPath() + AlgorithmConfiguration.defaultLoggerFile);
            String algorithm = config.getModel();
            Properties p = AlgorithmConfiguration.getProperties(config.getConfigPath() + AlgorithmConfiguration.modelsFile);
            String algorithmclass = p.getProperty(algorithm);
            Object algclass = Class.forName(algorithmclass).newInstance();
            if (algclass instanceof Modeler) {
                Modeler g = (Modeler)algclass;
                g.setConfiguration(config);
                modelers.add(g);
            } else {
                Model mod = (Model)algclass;
                ALG_PROPS[] algp = mod.getProperties();
                Properties pg = AlgorithmConfiguration.getProperties(config.getConfigPath() + AlgorithmConfiguration.modelersFile);
                for (Object modelerName : pg.values()) {
                    Modeler gen = (Modeler)Class.forName((String)modelerName).newInstance();
                    gen.setConfiguration(config);
                    ALG_PROPS[] supportedAlgs = gen.getSupportedModels();
                    boolean genSuitable = false;
                    block3: for (ALG_PROPS prop : algp) {
                        for (ALG_PROPS gprop : supportedAlgs) {
                            if (gprop != prop) continue;
                            genSuitable = true;
                            gen.setmodel(mod);
                            continue block3;
                        }
                    }
                    if (!genSuitable) continue;
                    ModelersFactory.addModeler2List(modelers, gen);
                }
            }
            return modelers;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void addModeler2List(List<Modeler> modelers, Modeler mod) {
        int i = 0;
        boolean inserted = false;
        for (Modeler g : modelers) {
            if (g.getInfrastructure().compareTo(mod.getInfrastructure()) > 0) {
                modelers.add(i, mod);
                inserted = true;
                break;
            }
            ++i;
        }
        if (!inserted) {
            modelers.add(mod);
        }
    }
}

