/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.graphtools.plotting.graphs;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.gcube.contentmanagement.graphtools.abstracts.GenericStandaloneGraph;
import org.gcube.contentmanagement.graphtools.utils.MathFunctions;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.CategoryTick;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.text.TextBlock;
import org.jfree.text.TextBlockAnchor;
import org.jfree.text.TextLine;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;

public class TransectLineGraph
extends GenericStandaloneGraph {
    private static final long serialVersionUID = 1L;

    public TransectLineGraph(String title) {
        super(title);
    }

    @Override
    protected Dataset generateDataset() {
        String series1 = "First";
        String series2 = "Second";
        String series3 = "Third";
        String type1 = "Type 1";
        String type2 = "Type 2";
        String type3 = "Type 3";
        String type4 = "Type 4";
        String type5 = "Type 5";
        String type6 = "Type 6";
        String type7 = "Type 7";
        String type8 = "Type 8";
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue(1.0, (Comparable)((Object)series1), (Comparable)((Object)type1));
        dataset.addValue(4.0, (Comparable)((Object)series1), (Comparable)((Object)type2));
        dataset.addValue(3.0, (Comparable)((Object)series1), (Comparable)((Object)type3));
        dataset.addValue(5.0, (Comparable)((Object)series1), (Comparable)((Object)type4));
        dataset.addValue(5.0, (Comparable)((Object)series1), (Comparable)((Object)type5));
        dataset.addValue(7.0, (Comparable)((Object)series1), (Comparable)((Object)type6));
        dataset.addValue(7.0, (Comparable)((Object)series1), (Comparable)((Object)type7));
        dataset.addValue(8.0, (Comparable)((Object)series1), (Comparable)((Object)type8));
        dataset.addValue(5.0, (Comparable)((Object)series2), (Comparable)((Object)type1));
        dataset.addValue(7.0, (Comparable)((Object)series2), (Comparable)((Object)type2));
        dataset.addValue(6.0, (Comparable)((Object)series2), (Comparable)((Object)type3));
        dataset.addValue(8.0, (Comparable)((Object)series2), (Comparable)((Object)type4));
        dataset.addValue(4.0, (Comparable)((Object)series2), (Comparable)((Object)type5));
        dataset.addValue(4.0, (Comparable)((Object)series2), (Comparable)((Object)type6));
        dataset.addValue(2.0, (Comparable)((Object)series2), (Comparable)((Object)type7));
        dataset.addValue(1.0, (Comparable)((Object)series2), (Comparable)((Object)type8));
        dataset.addValue(4.0, (Comparable)((Object)series3), (Comparable)((Object)type1));
        dataset.addValue(3.0, (Comparable)((Object)series3), (Comparable)((Object)type2));
        dataset.addValue(2.0, (Comparable)((Object)series3), (Comparable)((Object)type3));
        dataset.addValue(3.0, (Comparable)((Object)series3), (Comparable)((Object)type4));
        dataset.addValue(6.0, (Comparable)((Object)series3), (Comparable)((Object)type5));
        dataset.addValue(3.0, (Comparable)((Object)series3), (Comparable)((Object)type6));
        dataset.addValue(4.0, (Comparable)((Object)series3), (Comparable)((Object)type7));
        dataset.addValue(3.0, (Comparable)((Object)series3), (Comparable)((Object)type8));
        return dataset;
    }

    @Override
    protected JFreeChart createChart(Dataset dataset) {
        DefaultCategoryDataset dataset1 = new DefaultCategoryDataset();
        DefaultCategoryDataset dataset2 = new DefaultCategoryDataset();
        DefaultCategoryDataset dataset0 = (DefaultCategoryDataset)dataset;
        ArrayList<Integer> relevantindexes = new ArrayList<Integer>();
        for (Object row : dataset0.getRowKeys()) {
            int spikescounter = 0;
            int pointscounter = 0;
            int allcounter = 0;
            int mincolumns = 0;
            int maxcolumns = dataset0.getColumnCount() - 1;
            int medcolumns = maxcolumns / 2;
            for (Object column : dataset0.getColumnKeys()) {
                double value = dataset0.getValue((Comparable)((Object)((String)row)), (Comparable)((Object)((String)column))).doubleValue();
                String xlab = (String)column;
                String annotation = "";
                String x1lab = xlab;
                int commaindex = xlab.indexOf(";");
                if (commaindex > 0) {
                    annotation = xlab.substring(commaindex + 1);
                    x1lab = xlab.substring(0, commaindex);
                    dataset2.addValue(value, (Comparable)((Object)((String)row)), (Comparable)((Object)(allcounter + 1 + ": " + annotation)));
                    ++spikescounter;
                    relevantindexes.add(allcounter);
                } else {
                    if (allcounter == mincolumns || allcounter == maxcolumns || allcounter == medcolumns) {
                        relevantindexes.add(allcounter);
                    }
                    dataset2.addValue(value, (Comparable)((Object)((String)row)), (Comparable)((Object)("" + (allcounter + 1))));
                    ++pointscounter;
                }
                ++allcounter;
                dataset1.addValue(value, (Comparable)((Object)((String)row)), (Comparable)((Object)x1lab));
            }
        }
        JFreeChart chart = ChartFactory.createLineChart((String)" ", (String)"", (String)"", (CategoryDataset)dataset1, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        chart.setTitle(new TextTitle(" ", new Font("sansserif", 1, 60)));
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.white);
        plot.setDomainCrosshairVisible(true);
        plot.setDomainGridlinesVisible(true);
        plot.setRangeCrosshairVisible(true);
        plot.setRenderer((CategoryItemRenderer)new LineAndShapeRenderer(true, false));
        plot.setAxisOffset(new RectangleInsets(1.0, 1.0, 1.0, 1.0));
        plot.setDomainAxis(0, (CategoryAxis)new CustomXAxis("", dataset1, relevantindexes));
        CategoryAxis categoryaxis1 = plot.getDomainAxis(0);
        categoryaxis1.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        plot.mapDatasetToDomainAxis(0, 0);
        plot.setDataset(1, (CategoryDataset)dataset2);
        plot.setDomainAxis(1, (CategoryAxis)new CustomXAxis("", dataset2, relevantindexes));
        CategoryAxis categoryaxis2 = plot.getDomainAxis(1);
        categoryaxis2.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        plot.mapDatasetToDomainAxis(1, 1);
        plot.setDomainAxisLocation(1, AxisLocation.TOP_OR_LEFT);
        chart.setPadding(new RectangleInsets(30.0, 30.0, 90.0, 90.0));
        this.big = true;
        chart.getPlot().setBackgroundPaint((Paint)Color.white);
        return chart;
    }

    static JFreeChart createStaticChart(Dataset dataset) {
        DefaultCategoryDataset dataset1 = new DefaultCategoryDataset();
        DefaultCategoryDataset dataset2 = new DefaultCategoryDataset();
        DefaultCategoryDataset dataset0 = (DefaultCategoryDataset)dataset;
        ArrayList<Integer> relevantindexes = new ArrayList<Integer>();
        for (Object row : dataset0.getRowKeys()) {
            int spikescounter = 0;
            int pointscounter = 0;
            int allcounter = 0;
            int mincolumns = 0;
            int maxcolumns = dataset0.getColumnCount() - 1;
            int medcolumns = maxcolumns / 2;
            for (Object column : dataset0.getColumnKeys()) {
                double value = dataset0.getValue((Comparable)((Object)((String)row)), (Comparable)((Object)((String)column))).doubleValue();
                String xlab = (String)column;
                String annotation = "";
                String x1lab = xlab;
                int commaindex = xlab.indexOf(";");
                if (commaindex > 0) {
                    annotation = xlab.substring(commaindex + 1);
                    x1lab = xlab.substring(0, commaindex);
                    dataset2.addValue(value, (Comparable)((Object)((String)row)), (Comparable)((Object)(allcounter + 1 + ": " + annotation)));
                    ++spikescounter;
                    relevantindexes.add(allcounter);
                } else {
                    if (allcounter == mincolumns || allcounter == maxcolumns || allcounter == medcolumns) {
                        relevantindexes.add(allcounter);
                    }
                    dataset2.addValue(value, (Comparable)((Object)((String)row)), (Comparable)((Object)("" + (allcounter + 1))));
                    ++pointscounter;
                }
                ++allcounter;
                dataset1.addValue(value, (Comparable)((Object)((String)row)), (Comparable)((Object)x1lab));
            }
        }
        JFreeChart chart = ChartFactory.createLineChart((String)" ", (String)"", (String)"", (CategoryDataset)dataset1, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        chart.setTitle(new TextTitle(" ", new Font("sansserif", 1, 60)));
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.white);
        plot.setDomainCrosshairVisible(true);
        plot.setDomainGridlinesVisible(true);
        plot.setRangeCrosshairVisible(true);
        plot.setRenderer((CategoryItemRenderer)new LineAndShapeRenderer(true, false));
        plot.setAxisOffset(new RectangleInsets(1.0, 1.0, 1.0, 1.0));
        plot.setDomainAxis(0, (CategoryAxis)new CustomXAxis("", dataset1, relevantindexes));
        CategoryAxis categoryaxis1 = plot.getDomainAxis(0);
        categoryaxis1.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        plot.mapDatasetToDomainAxis(0, 0);
        plot.setDataset(1, (CategoryDataset)dataset2);
        plot.setDomainAxis(1, (CategoryAxis)new CustomXAxis("", dataset2, relevantindexes));
        CategoryAxis categoryaxis2 = plot.getDomainAxis(1);
        categoryaxis2.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        plot.mapDatasetToDomainAxis(1, 1);
        plot.setDomainAxisLocation(1, AxisLocation.TOP_OR_LEFT);
        chart.setPadding(new RectangleInsets(30.0, 30.0, 90.0, 90.0));
        chart.getPlot().setBackgroundPaint((Paint)Color.white);
        return chart;
    }

    @Override
    protected GenericStandaloneGraph getInstance(String title) {
        return new TransectLineGraph(title);
    }

    static class CustomXAxis
    extends CategoryAxis {
        DefaultCategoryDataset dataset;
        List<Integer> samplingindexes;

        public List refreshTicks(Graphics2D graphics2d, AxisState axisstate, Rectangle2D rectangle2d, RectangleEdge rectangleedge) {
            ArrayList<CategoryTick> arraylist = new ArrayList<CategoryTick>();
            int size = this.dataset.getColumnCount();
            int i = 0;
            while (i < size) {
                TextBlock tb = new TextBlock();
                if (MathFunctions.isIn(this.samplingindexes, i)) {
                    String xlab = (String)this.dataset.getColumnKeys().get(i);
                    tb.addLine(new TextLine(xlab, new Font("sansserif", 1, 8)));
                } else {
                    tb.addLine(new TextLine(""));
                }
                arraylist.add(new CategoryTick((Comparable)((Object)("p" + i)), tb, TextBlockAnchor.CENTER_RIGHT, TextAnchor.CENTER_RIGHT, 0.0));
                ++i;
            }
            return arraylist;
        }

        public CustomXAxis(String s, DefaultCategoryDataset d, List<Integer> indexes) {
            super(s);
            this.dataset = d;
            this.samplingindexes = indexes;
        }
    }
}

