/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.graphtools.utils;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.gcube.portlets.user.timeseries.charts.support.types.Point;

public class MathFunctions {
    public static void main(String[] args) {
        System.out.println(" " + MathFunctions.roundDecimal(300.23454, 2));
    }

    public static double roundDecimal(double number, int decimalposition) {
        double n = (double)Math.round(number * Math.pow(10.0, decimalposition)) / Math.pow(10.0, decimalposition);
        return n;
    }

    public static float incrementPerc(float perc, float quantity, int N) {
        if (N == 0) {
            return quantity;
        }
        float out = 0.0f;
        int N_plus_1 = N + 1;
        out = (float)(((double)perc + (double)quantity / (double)N) * ((double)N / (double)N_plus_1));
        return out;
    }

    public static ArrayList<Integer> generateRandoms(int numberOfRandoms, int min, int max) {
        ArrayList<Integer> randomsSet = new ArrayList<Integer>();
        if (numberOfRandoms == -1) {
            int i = min;
            while (i < max) {
                randomsSet.add(i);
                ++i;
            }
        } else {
            int numofrandstogenerate = 0;
            numofrandstogenerate = numberOfRandoms <= max ? numberOfRandoms : max;
            if (numofrandstogenerate == 0) {
                randomsSet.add(0);
            } else {
                int i = 0;
                while (i < numofrandstogenerate) {
                    int RNum = -1;
                    RNum = (int)((double)max * Math.random()) + min;
                    while (randomsSet.contains(RNum)) {
                        RNum = (int)((double)max * Math.random()) + min;
                    }
                    if (RNum >= 0) {
                        randomsSet.add(RNum);
                    }
                    ++i;
                }
            }
        }
        return randomsSet;
    }

    public static int[] generateSequence(int elements) {
        int[] sequence = new int[elements];
        int i = 0;
        while (i < elements) {
            sequence[i] = i;
            ++i;
        }
        return sequence;
    }

    public static BigInteger chunk2Index(int chunkIndex, int chunkSize) {
        return BigInteger.valueOf(chunkIndex).multiply(BigInteger.valueOf(chunkSize));
    }

    public static double mean(double[] p) {
        double sum = 0.0;
        int i = 0;
        while (i < p.length) {
            sum += p[i];
            ++i;
        }
        return sum / (double)p.length;
    }

    public static double[] derivative(double[] a) {
        double[] d = new double[a.length];
        double max = 1.0;
        if (a.length > 0) {
            int i = 0;
            while (i < a.length) {
                double current;
                double previous = current = a[i];
                if (i > 0) {
                    previous = a[i - 1];
                }
                d[i] = current - previous;
                if (Math.abs(d[i]) > max) {
                    max = Math.abs(d[i]);
                }
                ++i;
            }
            i = 0;
            while (i < a.length) {
                d[i] = d[i] / max;
                ++i;
            }
        }
        return d;
    }

    public static boolean[] findSpikes(double[] derivative, double threshold) {
        boolean[] d = new boolean[derivative.length];
        if (d.length > 0) {
            d[0] = false;
            int i = 1;
            while (i < derivative.length - 1) {
                if (derivative[i] / derivative[i + 1] < 0.0) {
                    if (threshold > 0.0 && Math.abs(derivative[i]) > threshold) {
                        d[i] = true;
                    }
                } else {
                    d[i] = false;
                }
                ++i;
            }
            d[derivative.length - 1] = false;
        }
        return d;
    }

    public static boolean[] findSpikes(double[] derivative) {
        return MathFunctions.findSpikes(derivative, -1.0);
    }

    public static double[] points2Double(List<Point<? extends Number, ? extends Number>> pointslist, int seriesIndex, int numbOfPoints) {
        double[] points = new double[numbOfPoints];
        int y = 0;
        while (y < numbOfPoints) {
            double value;
            points[y] = value = pointslist.get(seriesIndex).getEntries().get(y).getValue().doubleValue();
            ++y;
        }
        return points;
    }

    public static boolean isIn(List<Integer> indexarray, int index) {
        int size = indexarray.size();
        int i = 0;
        while (i < size) {
            if (index == indexarray.get(i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static List<Integer> findZeros(double[] points) {
        int size = points.length;
        ArrayList<Integer> zeros = new ArrayList<Integer>();
        int i = 0;
        while (i < size) {
            if (points[i] == 0.0) {
                int start = i;
                int end = i;
                int j = i + 1;
                while (j < size) {
                    if (points[j] != 0.0) {
                        end = j - 1;
                        break;
                    }
                    ++j;
                }
                int center = start + (end - start) / 2;
                zeros.add(center);
                i = end;
            }
            ++i;
        }
        return zeros;
    }

    public static double[] logSubdivision(double start, double end, int numberOfParts) {
        if (end <= start) {
            return null;
        }
        if (start == 0.0) {
            start = 0.01;
        }
        double logStart = Math.log(start);
        double logEnd = Math.log(end);
        double step = 0.0;
        if (numberOfParts > 0) {
            double difference = logEnd - logStart;
            step = difference / (double)numberOfParts;
        }
        double[] linearpoints = new double[numberOfParts + 1];
        int i = 0;
        while (i < numberOfParts + 1) {
            linearpoints[i] = Math.exp(logStart + (double)i * step);
            if (linearpoints[i] < 0.011) {
                linearpoints[i] = 0.0;
            }
            ++i;
        }
        return linearpoints;
    }
}

