/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.graphtools.plotting.graphs;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.List;
import org.gcube.contentmanagement.graphtools.abstracts.GenericStandaloneGraph;
import org.gcube.portlets.user.timeseries.charts.support.types.GraphData;
import org.gcube.portlets.user.timeseries.charts.support.types.Point;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class ScatterGraphNumeric
extends GenericStandaloneGraph {
    private static final long serialVersionUID = 1L;

    public ScatterGraphNumeric(String title) {
        super(title);
    }

    @Override
    protected Dataset generateDataset() {
        return null;
    }

    @Override
    protected JFreeChart createChart(Dataset dataset) {
        JFreeChart jfreechart = ChartFactory.createScatterPlot((String)"", (String)"", (String)"", (XYDataset)((XYDataset)dataset), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        XYPlot xyplot = (XYPlot)jfreechart.getPlot();
        xyplot.setNoDataMessage("NO DATA");
        xyplot.setDomainPannable(true);
        xyplot.setRangePannable(true);
        xyplot.setDomainZeroBaselineVisible(true);
        xyplot.setRangeZeroBaselineVisible(true);
        xyplot.setDomainGridlineStroke((Stroke)new BasicStroke(0.0f));
        xyplot.setDomainMinorGridlineStroke((Stroke)new BasicStroke(0.0f));
        xyplot.setDomainGridlinePaint((Paint)Color.blue);
        xyplot.setRangeGridlineStroke((Stroke)new BasicStroke(0.0f));
        xyplot.setRangeMinorGridlineStroke((Stroke)new BasicStroke(0.0f));
        xyplot.setRangeGridlinePaint((Paint)Color.blue);
        xyplot.setDomainMinorGridlinesVisible(true);
        xyplot.setRangeMinorGridlinesVisible(true);
        XYLineAndShapeRenderer xylineandshaperenderer = (XYLineAndShapeRenderer)xyplot.getRenderer();
        xylineandshaperenderer.setSeriesOutlinePaint(0, (Paint)Color.black);
        xylineandshaperenderer.setUseOutlinePaint(true);
        NumberAxis numberaxis = (NumberAxis)xyplot.getDomainAxis();
        numberaxis.setAutoRangeIncludesZero(false);
        numberaxis.setTickMarkInsideLength(2.0f);
        numberaxis.setTickMarkOutsideLength(2.0f);
        numberaxis.setMinorTickCount(2);
        numberaxis.setMinorTickMarksVisible(true);
        NumberAxis numberaxis1 = (NumberAxis)xyplot.getRangeAxis();
        numberaxis1.setTickMarkInsideLength(2.0f);
        numberaxis1.setTickMarkOutsideLength(2.0f);
        numberaxis1.setMinorTickCount(2);
        numberaxis1.setMinorTickMarksVisible(true);
        return jfreechart;
    }

    static JFreeChart createStaticChart(Dataset dataset) {
        JFreeChart jfreechart = ChartFactory.createScatterPlot((String)"", (String)"", (String)"", (XYDataset)((XYDataset)dataset), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        XYPlot xyplot = (XYPlot)jfreechart.getPlot();
        xyplot.setNoDataMessage("NO DATA");
        xyplot.setDomainPannable(true);
        xyplot.setRangePannable(true);
        xyplot.setDomainZeroBaselineVisible(true);
        xyplot.setRangeZeroBaselineVisible(true);
        xyplot.setDomainGridlineStroke((Stroke)new BasicStroke(0.0f));
        xyplot.setDomainMinorGridlineStroke((Stroke)new BasicStroke(0.0f));
        xyplot.setDomainGridlinePaint((Paint)Color.blue);
        xyplot.setRangeGridlineStroke((Stroke)new BasicStroke(0.0f));
        xyplot.setRangeMinorGridlineStroke((Stroke)new BasicStroke(0.0f));
        xyplot.setRangeGridlinePaint((Paint)Color.blue);
        xyplot.setDomainMinorGridlinesVisible(true);
        xyplot.setRangeMinorGridlinesVisible(true);
        XYLineAndShapeRenderer xylineandshaperenderer = (XYLineAndShapeRenderer)xyplot.getRenderer();
        xylineandshaperenderer.setSeriesOutlinePaint(0, (Paint)Color.black);
        xylineandshaperenderer.setUseOutlinePaint(true);
        NumberAxis numberaxis = (NumberAxis)xyplot.getDomainAxis();
        numberaxis.setAutoRangeIncludesZero(false);
        numberaxis.setTickMarkInsideLength(2.0f);
        numberaxis.setTickMarkOutsideLength(2.0f);
        numberaxis.setMinorTickCount(2);
        numberaxis.setMinorTickMarksVisible(true);
        NumberAxis numberaxis1 = (NumberAxis)xyplot.getRangeAxis();
        numberaxis1.setTickMarkInsideLength(2.0f);
        numberaxis1.setTickMarkOutsideLength(2.0f);
        numberaxis1.setMinorTickCount(2);
        numberaxis1.setMinorTickMarksVisible(true);
        return jfreechart;
    }

    @Override
    protected Dataset convert2Dataset(GraphData st) {
        List<Point<? extends Number, ? extends Number>> pointslist = st.getData();
        int numbOfRows = pointslist.size();
        XYSeriesCollection xyseriescollection = new XYSeriesCollection();
        if (numbOfRows > 0) {
            int numbOfCols = pointslist.get(0).getEntries().size();
            int x = 0;
            while (x < numbOfRows) {
                String serieslabel = pointslist.get(x).getLabel();
                XYSeries xyseries = new XYSeries((Comparable)((Object)serieslabel));
                int y = 0;
                while (y < numbOfCols) {
                    double value = pointslist.get(x).getEntries().get(y).getValue().doubleValue();
                    xyseries.add((double)(y + 1), value);
                    ++y;
                }
                xyseriescollection.addSeries(xyseries);
                ++x;
            }
        }
        return xyseriescollection;
    }

    @Override
    protected GenericStandaloneGraph getInstance(String title) {
        return new ScatterGraphNumeric(title);
    }
}

