/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.models.cores.neuralnetworks.neurosolutions;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import org.gcube.dataanalysis.ecoengine.models.cores.neuralnetworks.neurosolutions.LineReader;
import org.gcube.dataanalysis.ecoengine.models.cores.neuralnetworks.neurosolutions.Neuron;
import org.gcube.dataanalysis.ecoengine.models.cores.neuralnetworks.neurosolutions.Pattern;
import org.gcube.dataanalysis.ecoengine.models.cores.neuralnetworks.neurosolutions.PatternSet;
import org.gcube.dataanalysis.ecoengine.models.cores.neuralnetworks.neurosolutions.Randomizer;
import org.gcube.dataanalysis.ecoengine.models.cores.neuralnetworks.neurosolutions.Synapse;

public class NeuralNet
implements Serializable {
    Neuron[] neurons;
    Synapse[] synapses;
    int nolayers;
    Layer[] layers;
    private Randomizer randomizer;
    int[] topology;

    public NeuralNet(String path, Randomizer randomizer) {
        this.randomizer = randomizer;
        LineReader linereader = new LineReader(path);
        while (linereader.NextLineSplitted()) {
            if (linereader.column[0].compareTo("#neurons") == 0) {
                this.neurons = new Neuron[Integer.parseInt(linereader.column[1])];
            }
            if (linereader.column[0].compareTo("#synapses") == 0) {
                this.synapses = new Synapse[Integer.parseInt(linereader.column[1])];
            }
            if (linereader.column[0].compareTo("i") == 0) {
                this.neurons[Integer.parseInt((String)linereader.column[1])] = new Neuron(Integer.parseInt(linereader.column[1]));
            }
            if (linereader.column[0].compareTo("n") == 0) {
                this.neurons[Integer.parseInt((String)linereader.column[1])] = new Neuron(Integer.parseInt(linereader.column[1]), Integer.parseInt(linereader.column[2]), Double.parseDouble(linereader.column[3]), linereader.column[4].charAt(0), Double.parseDouble(linereader.column[5]), Double.parseDouble(linereader.column[6]), randomizer);
            }
            if (linereader.column[0].compareTo("s") != 0) continue;
            this.synapses[Integer.parseInt((String)linereader.column[1])] = new Synapse(this.neurons[Integer.parseInt(linereader.column[2])], this.neurons[Integer.parseInt(linereader.column[3])], randomizer);
        }
        linereader = null;
        int temp_maxlayer = 0;
        int i = 0;
        while (i < this.neurons.length) {
            if (this.neurons[i].layer > temp_maxlayer) {
                temp_maxlayer = this.neurons[i].layer;
            }
            ++i;
        }
        this.nolayers = temp_maxlayer + 1;
        this.layers = new Layer[this.nolayers];
        i = 0;
        while (i < this.nolayers) {
            this.layers[i] = new Layer(i);
            ++i;
        }
        this.NeuronsInOut();
    }

    public static double[] preprocessObjects(Object[] vector) {
        double[] out = new double[vector.length];
        int i = 0;
        while (i < vector.length) {
            double element = 0.0;
            if (vector[i] != null) {
                element = Double.parseDouble("" + vector[i]);
            }
            out[i] = element;
            ++i;
        }
        return out;
    }

    public double[] getNegativeCase() {
        double[] out = new double[]{};
        if (this.topology.length > 0) {
            out = new double[this.topology[this.topology.length - 1]];
            int i = 0;
            while (i < out.length) {
                out[i] = -1.0;
                ++i;
            }
        }
        return out;
    }

    public double[] getPositiveCase() {
        double[] out = new double[]{};
        if (this.topology.length > 0) {
            out = new double[this.topology[this.topology.length - 1]];
            int i = 0;
            while (i < out.length) {
                out[i] = 1.0;
                ++i;
            }
        }
        return out;
    }

    public static int[] setupInnerLayers(int ... numberOfNeurons) {
        int[] layers = null;
        if (numberOfNeurons.length > 0) {
            layers = new int[numberOfNeurons.length];
            int i = 0;
            while (i < numberOfNeurons.length) {
                layers[i] = numberOfNeurons[i];
                ++i;
            }
        }
        return layers;
    }

    public NeuralNet(int N, int M, int[] t) {
        Randomizer randomizer = new Randomizer();
        int[] noofneurons = null;
        double[] learnratecoeff = null;
        char[] axonfamily = null;
        double[] momentumrate = null;
        double[] flatness = null;
        int len = 2;
        if (t != null) {
            len += t.length;
        }
        noofneurons = new int[len];
        learnratecoeff = new double[len];
        axonfamily = new char[len];
        momentumrate = new double[len];
        flatness = new double[len];
        noofneurons[0] = N;
        learnratecoeff[0] = 1.0;
        axonfamily[0] = 116;
        momentumrate[0] = 0.0;
        flatness[0] = 1.0;
        int i = 1;
        while (i < len - 1) {
            noofneurons[i] = t[i - 1];
            learnratecoeff[i] = 1.0;
            axonfamily[i] = 116;
            momentumrate[i] = 0.4;
            flatness[i] = 1.0;
            ++i;
        }
        noofneurons[len - 1] = M;
        learnratecoeff[len - 1] = 1.0;
        axonfamily[len - 1] = 116;
        momentumrate[len - 1] = 0.4;
        flatness[len - 1] = 1.0;
        this.init(noofneurons, learnratecoeff, axonfamily, momentumrate, flatness, randomizer);
    }

    public void init(int[] noofneurons, double[] learningratecoefficient, char[] axonfamily, double[] momentumrate, double[] axonfuncflatness, Randomizer randomizer) {
        this.randomizer = randomizer;
        this.topology = noofneurons;
        int temp_nooflayers = noofneurons.length;
        this.nolayers = noofneurons.length;
        int temp_noofneurons = 0;
        int i = 0;
        while (i < temp_nooflayers) {
            temp_noofneurons += noofneurons[i];
            ++i;
        }
        this.neurons = new Neuron[temp_noofneurons];
        int temp_noofsynapses = 0;
        int i2 = 0;
        while (i2 < temp_nooflayers - 1) {
            temp_noofsynapses += noofneurons[i2] * noofneurons[i2 + 1];
            ++i2;
        }
        this.synapses = new Synapse[temp_noofsynapses];
        int temp_neuronidcounter = 0;
        int i3 = 0;
        while (i3 < noofneurons[0]) {
            this.neurons[temp_neuronidcounter] = new Neuron(temp_neuronidcounter);
            ++temp_neuronidcounter;
            ++i3;
        }
        i3 = 1;
        while (i3 < temp_nooflayers) {
            int j = 0;
            while (j < noofneurons[i3]) {
                this.neurons[temp_neuronidcounter] = new Neuron(temp_neuronidcounter, i3, axonfuncflatness[i3], axonfamily[i3], momentumrate[i3], learningratecoefficient[i3], randomizer);
                ++temp_neuronidcounter;
                ++j;
            }
            ++i3;
        }
        this.layers = new Layer[temp_nooflayers];
        i3 = 0;
        while (i3 < temp_nooflayers) {
            this.layers[i3] = new Layer(i3);
            ++i3;
        }
        int temp_synapseidcounter = 0;
        int i4 = 0;
        while (i4 < temp_nooflayers - 1) {
            int j = 0;
            while (j < this.layers[i4].neurons.length) {
                int k = 0;
                while (k < this.layers[i4 + 1].neurons.length) {
                    this.synapses[temp_synapseidcounter++] = new Synapse(this.layers[i4].neurons[j], this.layers[i4 + 1].neurons[k], randomizer);
                    ++k;
                }
                ++j;
            }
            ++i4;
        }
        this.NeuronsInOut();
    }

    public NeuralNet(int[] noofneurons, double[] learningratecoefficient, char[] axonfamily, double[] momentumrate, double[] axonfuncflatness, Randomizer randomizer) {
        this.init(noofneurons, learningratecoefficient, axonfamily, momentumrate, axonfuncflatness, randomizer);
    }

    private void NeuronsInOut() {
        int i = 0;
        while (i < this.neurons.length) {
            Neuron[] temp_neuronsin = null;
            Neuron[] temp_neuronsout = null;
            int incounter = 0;
            int outcounter = 0;
            int j = 0;
            while (j < this.synapses.length) {
                if (this.synapses[j].sourceunit == this.neurons[i]) {
                    ++outcounter;
                }
                if (this.synapses[j].targetunit == this.neurons[i]) {
                    ++incounter;
                }
                ++j;
            }
            temp_neuronsin = new Neuron[incounter];
            Synapse[] temp_synapsesin = new Synapse[incounter];
            temp_neuronsout = new Neuron[outcounter];
            Synapse[] temp_synapsesout = new Synapse[outcounter];
            incounter = 0;
            outcounter = 0;
            j = 0;
            while (j < this.synapses.length) {
                if (this.synapses[j].sourceunit == this.neurons[i]) {
                    temp_neuronsout[outcounter] = this.synapses[j].targetunit;
                    temp_synapsesout[outcounter++] = this.synapses[j];
                }
                if (this.synapses[j].targetunit == this.neurons[i]) {
                    temp_neuronsin[incounter] = this.synapses[j].sourceunit;
                    temp_synapsesin[incounter++] = this.synapses[j];
                }
                ++j;
            }
            this.neurons[i].InsOuts(temp_neuronsin, temp_neuronsout, temp_synapsesin, temp_synapsesout);
            ++i;
        }
    }

    public void SaveConfig(String path) throws IOException {
        File outputFile = new File(path);
        FileWriter out = new FileWriter(outputFile);
        out.write("// Input units:\n");
        out.write("#neurons;" + this.neurons.length + "\n");
        out.write("// type;ID;layer;flatness;axonfamily;momentum;learningrate\n");
        int i = 0;
        while (i < this.neurons.length) {
            if (this.neurons[i].layer == 0) {
                out.write("i;" + i + ";0\n");
            } else {
                out.write("n;" + i + ";" + this.neurons[i].layer + ";" + this.neurons[i].axonfuncflatness + ";" + this.neurons[i].axonfamily + ";" + this.neurons[i].momentumrate + ";" + this.neurons[i].learningratecoefficient + "\n");
            }
            ++i;
        }
        out.write("#synapses;" + this.synapses.length + "\n");
        out.write("// type; ID; sourceunit; targetunit\n");
        i = 0;
        while (i < this.synapses.length) {
            out.write("s;" + i + ";" + this.synapses[i].sourceunit.id + ";" + this.synapses[i].targetunit.id + "\n");
            ++i;
        }
        out.close();
    }

    public void LoadWeights(String path) {
        LineReader linereader = new LineReader(path);
        while (linereader.NextLineSplitted()) {
            if (linereader.column[0].compareTo("w") == 0) {
                this.synapses[Integer.parseInt((String)linereader.column[1])].weight = Double.parseDouble(linereader.column[2]);
            }
            if (linereader.column[0].compareTo("t") != 0) continue;
            this.neurons[Integer.parseInt((String)linereader.column[1])].threshold = Double.parseDouble(linereader.column[2]);
        }
        linereader = null;
    }

    public void SaveWeights(String path) throws IOException {
        File outputFile = new File(path);
        FileWriter out = new FileWriter(outputFile);
        int i = 0;
        while (i < this.synapses.length) {
            out.write("w; " + i + "; " + this.synapses[i].weight + "\n");
            ++i;
        }
        out.write("\n");
        i = 0;
        while (i < this.neurons.length) {
            out.write("t; " + i + "; " + this.neurons[i].threshold + "\n");
            ++i;
        }
        out.close();
    }

    public void FeedForward(double[] inputs) {
        int i = 0;
        while (i < this.layers[0].neurons.length) {
            this.layers[0].neurons[i].output = inputs[i];
            ++i;
        }
        i = 1;
        while (i < this.nolayers) {
            int j = 0;
            while (j < this.layers[i].neurons.length) {
                this.layers[i].neurons[j].UpdateOutput();
                ++j;
            }
            ++i;
        }
    }

    public double[] Output(double[] inputs) {
        this.FeedForward(inputs);
        double[] tempoutputs = new double[this.layers[this.nolayers - 1].neurons.length];
        int i = 0;
        while (i < this.layers[this.nolayers - 1].neurons.length) {
            tempoutputs[i] = this.layers[this.nolayers - 1].neurons[i].output;
            ++i;
        }
        return tempoutputs;
    }

    public double CrossValErrorRatio(PatternSet patternset) {
        int noofoutputunits = this.layers[this.nolayers - 1].neurons.length;
        double[] abserrors = new double[noofoutputunits];
        int i = 0;
        while (i < noofoutputunits) {
            abserrors[i] = 0.0;
            ++i;
        }
        double errorratio = 0.0;
        double[] temp_output = new double[noofoutputunits];
        int j = 0;
        while (j < patternset.crossvalpatterns.length) {
            temp_output = this.Output(patternset.crossvalpatterns[j].input);
            int i2 = 0;
            while (i2 < noofoutputunits) {
                int n = i2;
                abserrors[n] = abserrors[n] + Math.abs(temp_output[i2] - patternset.crossvalpatterns[j].target[i2]);
                ++i2;
            }
            ++j;
        }
        int i3 = 0;
        while (i3 < noofoutputunits) {
            int n = i3;
            abserrors[n] = abserrors[n] / (double)patternset.crossvalpatterns.length;
            errorratio += abserrors[i3] / patternset.crossvaldeviations[i3];
            ++i3;
        }
        return errorratio /= (double)noofoutputunits;
    }

    public double TestErrorRatio(PatternSet patternset) {
        int noofoutputunits = this.layers[this.nolayers - 1].neurons.length;
        double[] abserrors = new double[noofoutputunits];
        int i = 0;
        while (i < noofoutputunits) {
            abserrors[i] = 0.0;
            ++i;
        }
        double errorratio = 0.0;
        double[] temp_output = new double[noofoutputunits];
        int j = 0;
        while (j < patternset.testpatterns.length) {
            temp_output = this.Output(patternset.testpatterns[j].input);
            int i2 = 0;
            while (i2 < noofoutputunits) {
                int n = i2;
                abserrors[n] = abserrors[n] + Math.abs(temp_output[i2] - patternset.testpatterns[j].target[i2]);
                ++i2;
            }
            ++j;
        }
        int i3 = 0;
        while (i3 < noofoutputunits) {
            int n = i3;
            abserrors[n] = abserrors[n] / (double)patternset.testpatterns.length;
            errorratio += abserrors[i3] / patternset.testdeviations[i3];
            ++i3;
        }
        return errorratio /= (double)noofoutputunits;
    }

    public void IncrementalTrainPatterns(Pattern[] patterns, double rate) {
        int patternsnottrained = patterns.length;
        int indexofpatterntotrain = -1;
        int i = 0;
        while (i < patterns.length) {
            patterns[i].selected = false;
            ++i;
        }
        i = 0;
        while (i < patterns.length) {
            int patterntotrain = this.randomizer.random.nextInt(patternsnottrained);
            int counter = 0;
            int j = 0;
            while (j < patterns.length) {
                if (!patterns[j].selected) {
                    if (counter != patterntotrain) {
                        ++counter;
                    } else if (counter == patterntotrain) {
                        indexofpatterntotrain = j;
                        break;
                    }
                }
                ++j;
            }
            this.IncrementalTrain(rate, patterns[indexofpatterntotrain]);
            patterns[indexofpatterntotrain].selected = true;
            --patternsnottrained;
            ++i;
        }
        i = 0;
        while (i < patterns.length) {
            patterns[i].selected = false;
            ++i;
        }
    }

    public void IncrementalTrain(double rate, Pattern pattern) {
        this.FeedForward(pattern.input);
        int j = 0;
        while (j < this.layers[this.nolayers - 1].neurons.length) {
            this.layers[this.nolayers - 1].neurons[j].OutputIncrementalTrain(rate, pattern.target[j]);
            ++j;
        }
        int i = this.nolayers - 2;
        while (i > 0) {
            int j2 = 0;
            while (j2 < this.layers[i].neurons.length) {
                this.layers[i].neurons[j2].HiddenIncrementalTrain(rate);
                ++j2;
            }
            --i;
        }
    }

    public void MinibatchTrainPatterns(Pattern[] patterns, double rate, int nopatterns) {
        int patternsnottrained = patterns.length;
        if (nopatterns > patterns.length) {
            nopatterns = patterns.length;
        }
        if (nopatterns < 1) {
            nopatterns = 1;
        }
        int indexofpatterntotrain = -1;
        int[] indexesofpatternstotrain = new int[nopatterns];
        int i = 0;
        while (i < patterns.length) {
            patterns[i].selected = false;
            ++i;
        }
        while (patternsnottrained > 0) {
            int noofpatternsselected = 0;
            while (noofpatternsselected < nopatterns && patternsnottrained > 0) {
                int patterntotrain = this.randomizer.random.nextInt(patternsnottrained);
                --patternsnottrained;
                int counter = 0;
                i = 0;
                while (i < patterns.length) {
                    if (!patterns[i].selected) {
                        if (counter != patterntotrain) {
                            ++counter;
                        } else if (counter == patterntotrain) {
                            indexofpatterntotrain = i;
                            break;
                        }
                    }
                    ++i;
                }
                indexesofpatternstotrain[++noofpatternsselected - 1] = indexofpatterntotrain;
                patterns[indexofpatterntotrain].selected = true;
            }
            Pattern[] patternsselected = null;
            patternsselected = new Pattern[noofpatternsselected];
            i = 0;
            while (i < noofpatternsselected) {
                patternsselected[i] = patterns[indexesofpatternstotrain[i]];
                ++i;
            }
            this.BatchTrainPatterns(patternsselected, rate);
        }
        i = 0;
        while (i < patterns.length) {
            patterns[i].selected = false;
            ++i;
        }
    }

    public void BatchTrainPatterns(Pattern[] patterns, double rate) {
        int i = 0;
        while (i < patterns.length) {
            this.BatchTrain(rate, patterns[i]);
            ++i;
        }
        i = 0;
        while (i < this.neurons.length) {
            if (this.neurons[i].layer != 0) {
                this.neurons[i].BatchUpdateWeights(patterns.length);
            }
            ++i;
        }
    }

    public void BatchTrain(double rate, Pattern pattern) {
        this.FeedForward(pattern.input);
        int j = 0;
        while (j < this.layers[this.nolayers - 1].neurons.length) {
            this.layers[this.nolayers - 1].neurons[j].OutputBatchTrain(rate, pattern.target[j]);
            ++j;
        }
        int i = this.nolayers - 2;
        while (i > 0) {
            int j2 = 0;
            while (j2 < this.layers[i].neurons.length) {
                this.layers[i].neurons[j2].HiddenBatchTrain(rate);
                ++j2;
            }
            --i;
        }
    }

    class Layer
    implements Serializable {
        Neuron[] neurons;

        public Layer(int layerno) {
            int counter = 0;
            int i = 0;
            while (i < NeuralNet.this.neurons.length) {
                if (NeuralNet.this.neurons[i].layer == layerno) {
                    ++counter;
                }
                ++i;
            }
            this.neurons = new Neuron[counter];
            counter = 0;
            i = 0;
            while (i < NeuralNet.this.neurons.length) {
                if (NeuralNet.this.neurons[i].layer == layerno) {
                    this.neurons[counter++] = NeuralNet.this.neurons[i];
                }
                ++i;
            }
        }
    }
}

