/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.test.checks;

import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.interfaces.ComputationalAgent;
import org.gcube.dataanalysis.ecoengine.processing.factories.ClusterersFactory;

public class TestClusterer {
    public static void main(String[] args) throws Exception {
        System.out.println("TEST 1");
        List<ComputationalAgent> clus = ClusterersFactory.getClusterers(TestClusterer.testConfigLocal2());
        clus.get(0).init();
        TestClusterer.cluster(clus.get(0));
        clus = null;
    }

    private static void cluster(ComputationalAgent clus) throws Exception {
        if (clus != null) {
            TestClusterer tgs;
            TestClusterer testClusterer = tgs = new TestClusterer();
            testClusterer.getClass();
            ThreadCalculator tc = testClusterer.new ThreadCalculator(clus);
            Thread t = new Thread(tc);
            t.start();
            while (clus.getStatus() < 100.0f) {
                System.out.println("STATUS: " + clus.getStatus());
                Thread.sleep(1000L);
            }
        } else {
            AnalysisLogger.getLogger().trace((Object)"Generator Algorithm Not Supported");
        }
    }

    private static AlgorithmConfiguration testConfigLocal() {
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setConfigPath("./cfg/");
        config.setPersistencePath("./");
        config.setParam("OccurrencePointsTable", "mahoutclustering");
        config.setParam("FeaturesColumnNames", "recordedby#basisofrecord#locality");
        config.setParam("OccurrencePointsClusterTable", "occCluster_mahout");
        config.setParam("epsilon", "10");
        config.setParam("min_points", "1");
        config.setConfigPath("./cfg/");
        config.setPersistencePath("./");
        config.setNumberOfResources(1);
        config.setAgent("DBSCAN");
        config.setParam("DatabaseUserName", "utente");
        config.setParam("DatabasePassword", "d4science");
        config.setParam("DatabaseURL", "jdbc:postgresql://dbtest.next.research-infrastructures.eu/testdb");
        config.setParam("DatabaseDriver", "org.postgresql.Driver");
        return config;
    }

    private static AlgorithmConfiguration testConfigLocal2() {
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setConfigPath("./cfg/");
        config.setPersistencePath("./");
        config.setParam("OccurrencePointsTable", "generic_idbff59a4c_cada_4447_96b1_5d9a67f89fe8");
        config.setParam("FeaturesColumnNames", "x#y");
        config.setParam("OccurrencePointsClusterTable", "occCluster_nafo");
        config.setParam("k", "10");
        config.setParam("max_runs", "300");
        config.setParam("max_optimization_steps", "1");
        config.setParam("min_points", "1");
        config.setConfigPath("./cfg/");
        config.setPersistencePath("./");
        config.setNumberOfResources(1);
        config.setAgent("KMEANS");
        return config;
    }

    public class ThreadCalculator
    implements Runnable {
        ComputationalAgent dg;

        public ThreadCalculator(ComputationalAgent dg) {
            this.dg = dg;
        }

        @Override
        public void run() {
            try {
                this.dg.compute();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

