/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.graphtools.utils;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;

public class HttpRequest {
    public static String sendGetRequest(String endpoint, String requestParameters) {
        String result = null;
        if (endpoint.startsWith("http://")) {
            try {
                String line;
                String urlStr = endpoint;
                if (requestParameters != null && requestParameters.length() > 0) {
                    urlStr = String.valueOf(urlStr) + "?" + requestParameters;
                }
                URL url = new URL(urlStr);
                URLConnection conn = url.openConnection();
                BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuffer sb = new StringBuffer();
                while ((line = rd.readLine()) != null) {
                    sb.append(line);
                }
                rd.close();
                result = sb.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static void postData(Reader data, URL endpoint, Writer output) throws Exception {
        HttpURLConnection urlc = null;
        try {
            try {
                urlc = (HttpURLConnection)endpoint.openConnection();
                try {
                    urlc.setRequestMethod("POST");
                }
                catch (ProtocolException e) {
                    throw new Exception("Shouldn't happen: HttpURLConnection doesn't support POST??", e);
                }
                urlc.setDoOutput(true);
                urlc.setDoInput(true);
                urlc.setUseCaches(false);
                urlc.setAllowUserInteraction(false);
                urlc.setRequestProperty("Content-type", "text/xml; charset=UTF-8");
                OutputStream out = urlc.getOutputStream();
                try {
                    try {
                        OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
                        HttpRequest.pipe(data, writer);
                        ((Writer)writer).close();
                    }
                    catch (IOException e) {
                        throw new Exception("IOException while posting data", e);
                    }
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
                InputStream in = urlc.getInputStream();
                try {
                    try {
                        InputStreamReader reader = new InputStreamReader(in);
                        HttpRequest.pipe(reader, output);
                        ((Reader)reader).close();
                    }
                    catch (IOException e) {
                        throw new Exception("IOException while reading response", e);
                    }
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (IOException e) {
                throw new Exception("Connection error (is server running at " + endpoint + " ?): " + e);
            }
        }
        finally {
            if (urlc != null) {
                urlc.disconnect();
            }
        }
    }

    public static Object getJSonData(String endpoint, String requestParameters, Type outputClass) throws Exception {
        String output = HttpRequest.sendGetRequest(endpoint, requestParameters);
        Gson gson = new Gson();
        Object rebuiltJson = gson.fromJson(output.toString(), outputClass);
        return rebuiltJson;
    }

    public static String toJSon(Object obj) {
        Gson gson = new Gson();
        String jsonString = gson.toJson(obj);
        return jsonString;
    }

    public static Object postJSonData(String endpoint, Object obj, Type outputClass) throws Exception {
        HttpURLConnection urlc = null;
        try {
            String line;
            URL url = new URL(endpoint);
            urlc = (HttpURLConnection)url.openConnection();
            try {
                urlc.setRequestMethod("POST");
            }
            catch (ProtocolException e) {
                throw new Exception("Error in HttpURLConnection", e);
            }
            urlc.setDoOutput(true);
            urlc.setDoInput(true);
            urlc.setUseCaches(false);
            urlc.setAllowUserInteraction(false);
            urlc.setRequestProperty("Content-type", "application/json; charset=UTF-8");
            OutputStreamWriter writer = null;
            Gson gson = new Gson();
            if (obj != null) {
                OutputStream out = urlc.getOutputStream();
                writer = new OutputStreamWriter(out);
                String jsonString = gson.toJson(obj);
                AnalysisLogger.getLogger().trace((Object)("INPUT JSON:\n" + jsonString));
                writer.write(jsonString);
                writer.flush();
            }
            StringBuffer answer = new StringBuffer();
            BufferedReader reader = new BufferedReader(new InputStreamReader(urlc.getInputStream()));
            while ((line = reader.readLine()) != null) {
                answer.append(line);
            }
            if (obj != null) {
                writer.close();
            }
            reader.close();
            Object rebuiltJson = gson.fromJson(answer.toString(), outputClass);
            return rebuiltJson;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static void pipe(Reader reader, Writer writer) throws IOException {
        char[] buf = new char[1024];
        int read = 0;
        while ((read = reader.read(buf)) >= 0) {
            writer.write(buf, 0, read);
        }
        writer.flush();
    }

    public static String sendPostRequest(String endpoint, String requestParameters) {
        String data = requestParameters;
        try {
            String line;
            URL url = new URL(endpoint);
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());
            writer.write(data);
            writer.flush();
            StringBuffer answer = new StringBuffer();
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = reader.readLine()) != null) {
                answer.append(line);
            }
            writer.close();
            reader.close();
            return answer.toString();
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static String ManageCDATA(String phrase) {
        return phrase.replace("<![CDATA[", "").replace("]]>", "");
    }

    public static String AddCDATA(String phrase) {
        return "<![CDATA[" + phrase + "]]>";
    }

    public static int checkUrl(String url, final String username, final String password) {
        int checkConn = -1;
        try {
            if (username != null && password != null) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(username, password.toCharArray());
                    }
                });
            }
            URL checkurl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)checkurl.openConnection();
            checkConn = conn.getResponseCode();
            conn.disconnect();
        }
        catch (Exception e) {
            System.out.println("ERROR in URL " + e.getMessage());
        }
        return checkConn;
    }

    public static void main(String[] args) {
        String url = "http://geoserver-dev.d4science-ii.research-infrastructures.eu/geoserver/rest/layergroups/group4402c0cff-27e3-4606-a2f1-993ad37c3dfb.json";
        int d = HttpRequest.checkUrl(url, "admin", "gcube@geo2010");
        System.out.println(d);
    }
}

