/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.transducers;

import java.util.ArrayList;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.lexicalmatcher.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnType;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.ServiceType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.ServiceParameters;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.transducers.OccurrencePointsMerger;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;

public class OccurrencePointsInSeaOnEarth
extends OccurrencePointsMerger {
    private static String inthesea = "select * into %1$s from (select distinct a.* from %2$s as a join hcaf_d as b on ((b.centerlat-a.%3$s)*(b.centerlat-a.%3$s)+(b.centerlong-a.%4$s)*(b.centerlong-a.%4$s)<= 0.125) and b.oceanarea>0) as t";
    private static String onearth = "select * into %1$s from (select distinct a.* from %2$s as a join hcaf_d as b on ((b.centerlat-a.%3$s)*(b.centerlat-a.%3$s)+(b.centerlong-a.%4$s)*(b.centerlong-a.%4$s)<= 0.125) and b.landdist<=0.3) as t";
    static String tableNameF = "OccurrencePointsTableName";
    static String filterTypeF = "FilterType";
    String tableName;
    inseasonearth filter;

    @Override
    public List<StatisticalType> getInputParameters() {
        ArrayList<TableTemplates> templatesOccurrence = new ArrayList<TableTemplates>();
        templatesOccurrence.add(TableTemplates.OCCURRENCE_SPECIES);
        PrimitiveType p0 = new PrimitiveType(String.class.getName(), null, PrimitiveTypes.STRING, finalTableNameL, "the name of the produced table", "Occ_");
        InputTable p1 = new InputTable(templatesOccurrence, tableNameF, "The table containing the occurrence points", "");
        ColumnType p3 = new ColumnType(tableNameF, longitudeColumn, "column with longitude values", "decimallongitude", false);
        ColumnType p4 = new ColumnType(tableNameF, latitudeColumn, "column with latitude values", "decimallatitude", false);
        ServiceType p9 = new ServiceType(ServiceParameters.RANDOMSTRING, finalTableNameF, "Name of the resulting table", "processedOccurrences_");
        PrimitiveType p10 = new PrimitiveType(Enum.class.getName(), inseasonearth.values(), PrimitiveTypes.ENUMERATED, filterTypeF, "The filter type", "" + (Object)((Object)inseasonearth.MARINE));
        ArrayList<StatisticalType> inputs = new ArrayList<StatisticalType>();
        inputs.add(p0);
        inputs.add(p1);
        inputs.add(p3);
        inputs.add(p4);
        inputs.add(p9);
        inputs.add(p10);
        DatabaseType.addDefaultDBPars(inputs);
        return inputs;
    }

    @Override
    public void init() throws Exception {
        AnalysisLogger.setLogger(String.valueOf(this.config.getConfigPath()) + AlgorithmConfiguration.defaultLoggerFile);
        this.lonFld = this.config.getParam(longitudeColumn);
        this.latFld = this.config.getParam(latitudeColumn);
        this.tableName = this.config.getParam(tableNameF);
        this.finalTableName = this.config.getParam(finalTableNameF);
        this.finalTableLabel = this.config.getParam(finalTableNameL);
        this.filter = inseasonearth.valueOf(this.config.getParam(filterTypeF));
        this.status = 0.0f;
    }

    @Override
    public String getDescription() {
        return "An algorithm for filtering only the points lying in the seas or on the earth. It acts on occurrence points of species coming from the Species Discovery Facility of D4Science";
    }

    @Override
    protected void prepareFinalTable() throws Exception {
        DatabaseFactory.executeSQLUpdate(DatabaseUtils.createBlankTableFromAnotherStatement(this.tableName, this.finalTableName), this.dbconnection);
    }

    @Override
    public void compute() throws Exception {
        try {
            AnalysisLogger.getLogger().trace((Object)"Initializing DB Connection");
            this.dbconnection = DatabaseUtils.initDBSession(this.config);
            AnalysisLogger.getLogger().trace((Object)"Taking Table Description");
            AnalysisLogger.getLogger().trace((Object)("Creating merged table: " + this.finalTableName));
            try {
                DatabaseFactory.executeSQLUpdate(DatabaseUtils.dropTableStatement(this.finalTableName), this.dbconnection);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.status = 10.0f;
            String generationquery = "";
            generationquery = this.filter == inseasonearth.MARINE ? String.format(inthesea, this.finalTableName, this.tableName, this.latFld, this.lonFld) : String.format(onearth, this.finalTableName, this.tableName, this.latFld, this.lonFld);
            AnalysisLogger.getLogger().trace((Object)("Applying filter " + this.filter.name()));
            AnalysisLogger.getLogger().trace((Object)("Applying query " + generationquery));
            DatabaseFactory.executeSQLUpdate(generationquery, this.dbconnection);
            AnalysisLogger.getLogger().trace((Object)"Final Table created!");
        }
        finally {
            if (this.dbconnection != null) {
                try {
                    this.dbconnection.close();
                }
                catch (Exception exception) {}
            }
            this.status = 100.0f;
            AnalysisLogger.getLogger().trace((Object)"Occ Points Processing Finished and db closed");
        }
    }

    public static enum inseasonearth {
        MARINE,
        TERRESTRIAL;

    }
}

