/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.spatialdistributions;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.ServiceType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.ServiceParameters;
import org.gcube.dataanalysis.ecoengine.models.cores.neuralnetworks.Neural_Network;
import org.gcube.dataanalysis.ecoengine.spatialdistributions.AquamapsNative;
import org.hibernate.SessionFactory;

public class AquamapsNN
extends AquamapsNative {
    private Neural_Network neuralnet;

    @Override
    public String getName() {
        return "AQUAMAPS_NATIVE_NEURAL_NETWORK";
    }

    @Override
    public String getDescription() {
        return "Aquamaps Native Algorithm calculated by neural network";
    }

    @Override
    public List<StatisticalType> getInputParameters() {
        List<StatisticalType> parameters = super.getInputParameters();
        PrimitiveType p1 = new PrimitiveType(String.class.getName(), null, PrimitiveTypes.STRING, "SpeciesName", "Name of the Species for which the distribution has to be produced", "Fis-30189");
        PrimitiveType p2 = new PrimitiveType(String.class.getName(), null, PrimitiveTypes.STRING, "NeuralNetworkName", "The name of the Neural Network", "neuralnet_");
        ServiceType p3 = new ServiceType(ServiceParameters.USERNAME, "UserName", "LDAP username");
        parameters.add(p1);
        parameters.add(p2);
        parameters.add(p3);
        return parameters;
    }

    @Override
    public void init(AlgorithmConfiguration config, SessionFactory dbHibConnection) {
        super.init(config, dbHibConnection);
        String persistencePath = config.getPersistencePath();
        String filename = String.valueOf(persistencePath) + "neuralnetwork_" + config.getParam("SpeciesName") + "_" + config.getParam("UserName") + "_" + config.getParam("NeuralNetworkName").replace(" ", "");
        this.neuralnet = AquamapsNN.loadNN(filename);
    }

    @Override
    public float calcProb(Object mainInfo, Object area) {
        String species = this.getMainInfoID(mainInfo);
        String csquarecode = (String)((Object[])area)[0];
        Object[] wholevector = (Object[])area;
        Object[] inputvector = new Object[wholevector.length - 6];
        int i = 0;
        while (i < inputvector.length) {
            inputvector[i] = wholevector[i + 1];
            ++i;
        }
        float probability = 0.0f;
        probability = this.propagate(inputvector);
        return probability;
    }

    private synchronized float propagate(Object[] inputvector) {
        double[] output = new double[1];
        try {
            output = this.neuralnet.propagate(Neural_Network.preprocessObjects(inputvector));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        float probability = (float)output[0];
        return probability;
    }

    @Override
    public float getInternalStatus() {
        return 100.0f;
    }

    public static synchronized Neural_Network loadNN(String nomeFile) {
        Neural_Network nn = null;
        FileInputStream stream = null;
        try {
            try {
                stream = new FileInputStream(nomeFile);
                ObjectInputStream ois = new ObjectInputStream(stream);
                nn = (Neural_Network)ois.readObject();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                AnalysisLogger.getLogger().debug((Object)("Error in reading the object from file " + nomeFile + " ."));
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        return nn;
    }
}

