/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.transducers;

import java.util.ArrayList;
import java.util.List;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveTypesList;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.TablesList;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.evaluation.bioclimate.BioClimateAnalysis;
import org.gcube.dataanalysis.ecoengine.transducers.BioClimateHSPECTransducer;

public class BioClimateHCAFTransducer
extends BioClimateHSPECTransducer {
    private String[] hcafTables;
    private String[] hcafTablesNames;

    @Override
    public void init() throws Exception {
        this.bioClimate = new BioClimateAnalysis(this.config.getConfigPath(), this.config.getPersistencePath(), this.config.getParam("DatabaseURL"), this.config.getParam("DatabaseUserName"), this.config.getParam("DatabasePassword"), false);
        this.hcafTables = this.config.getParam("HCAF_Table_List").split(AlgorithmConfiguration.getListSeparator());
        this.hcafTablesNames = this.config.getParam("HCAF_Table_Names").split(AlgorithmConfiguration.getListSeparator());
    }

    @Override
    public String getDescription() {
        return "Evaluates the climatic changes impact on the variation of the ocean features contained in Hcaf tables";
    }

    @Override
    public List<StatisticalType> getInputParameters() {
        ArrayList<StatisticalType> parameters = new ArrayList<StatisticalType>();
        ArrayList<TableTemplates> templateHspec = new ArrayList<TableTemplates>();
        templateHspec.add(TableTemplates.HCAF);
        TablesList p7 = new TablesList(templateHspec, "HCAF_Table_List", "list of HCAF tables to analyze", false);
        PrimitiveTypesList p8 = new PrimitiveTypesList(String.class.getName(), PrimitiveTypes.STRING, "HCAF_Table_Names", "list of HCAF table names to be used as labels", false);
        parameters.add(p7);
        parameters.add(p8);
        DatabaseType.addDefaultDBPars(parameters);
        return parameters;
    }

    @Override
    public void compute() throws Exception {
        this.status = 0.1f;
        try {
            try {
                this.bioClimate.hcafEvolutionAnalysis(this.hcafTables, this.hcafTablesNames);
                this.producedImages = this.bioClimate.getProducedImages();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            this.status = 100.0f;
        }
    }
}

