/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.configuration;

import com.rapidminer.RapidMiner;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.LexicalEngineConfiguration;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;
import org.hibernate.SessionFactory;

public class AlgorithmConfiguration
extends LexicalEngineConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static String defaultConnectionFile = "DestinationDBHibernate.cfg.xml";
    public static String defaultLoggerFile = "ALog.properties";
    public static String algorithmsFile = "algorithms.properties";
    public static String nodeAlgorithmsFile = "nodealgorithms.properties";
    public static String generatorsFile = "generators.properties";
    public static String modelsFile = "models.properties";
    public static String modelersFile = "modelers.properties";
    public static String evaluatorsFile = "evaluators.properties";
    public static String clusterersFile = "clusterers.properties";
    public static String transducererFile = "transducerers.properties";
    public static String userperspectiveFile = "userperspective.properties";
    public static String RapidMinerOperatorsFile = "operators.xml";
    public static String StatisticalManagerService = "StatisticalManager";
    public static String StatisticalManagerClass = "Services";
    public static String listSeparator = "#";
    public static int chunkSize = 100000;
    public static int refreshResourcesTime = 10;
    private String configPath;
    private String persistencePath;
    private String tableSpace;
    private List<String> endpoints;
    private Integer numberOfResources = 0;
    private String model;
    private String generator;
    private String gcubeScope;
    private HashMap<String, String> generalProperties;

    public static Properties getProperties(String absoluteFilePath) {
        Properties props = new Properties();
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(absoluteFilePath);
                props.load(fis);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                fis.close();
            }
            catch (Exception exception) {}
        }
        return props;
    }

    public static String getListSeparator() {
        return listSeparator;
    }

    public static void setListSeparator(String listSeparator) {
        AlgorithmConfiguration.listSeparator = listSeparator;
    }

    public String getParam(String key) {
        if (this.generalProperties != null) {
            return this.generalProperties.get(key);
        }
        return null;
    }

    public void setParam(String key, String value) {
        if (this.generalProperties == null) {
            this.generalProperties = new HashMap();
        }
        this.generalProperties.put(key, value);
    }

    public void setConfigPath(String configPath) {
        if (!configPath.endsWith("/")) {
            configPath = String.valueOf(configPath) + "/";
        }
        this.configPath = configPath;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public void setNumberOfResources(Integer numberOfThreads) {
        this.numberOfResources = numberOfThreads;
    }

    public Integer getNumberOfResources() {
        return this.numberOfResources;
    }

    public void addGeneralProperties(HashMap<String, String> generalProperties) {
        for (String key : generalProperties.keySet()) {
            this.generalProperties.put(key, generalProperties.get(key));
        }
    }

    public void setGeneralProperties(HashMap<String, String> generalProperties) {
        this.generalProperties = generalProperties;
    }

    public HashMap<String, String> getGeneralProperties() {
        return this.generalProperties;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getPersistencePath() {
        return this.persistencePath;
    }

    public void setPersistencePath(String persistencePath) {
        this.persistencePath = persistencePath;
    }

    public String getAgent() {
        return this.generator;
    }

    public void setAgent(String generator) {
        this.generator = generator;
    }

    public static SessionFactory getConnectionFromConfig(AlgorithmConfiguration Input) {
        String defaultDatabaseFile = String.valueOf(Input.getConfigPath()) + defaultConnectionFile;
        Input.setDatabaseDriver(Input.getParam("DatabaseDriver"));
        Input.setDatabaseUserName(Input.getParam("DatabaseUserName"));
        Input.setDatabasePassword(Input.getParam("DatabasePassword"));
        Input.setDatabaseURL(Input.getParam("DatabaseURL"));
        SessionFactory connection = null;
        try {
            connection = DatabaseFactory.initDBConnection(defaultDatabaseFile, Input);
        }
        catch (Exception e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().trace((Object)"ERROR initializing connection");
        }
        return connection;
    }

    public void initRapidMiner() {
        System.setProperty("rapidminer.init.operators", String.valueOf(this.configPath) + RapidMinerOperatorsFile);
        RapidMiner.init();
        AnalysisLogger.setLogger(String.valueOf(this.getConfigPath()) + defaultLoggerFile);
        AnalysisLogger.getLogger().info((Object)"Rapid Miner initialized");
    }

    public String getGcubeScope() {
        return this.gcubeScope;
    }

    public void setGcubeScope(String gcubeScope) {
        this.gcubeScope = gcubeScope;
    }

    public List<String> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List<String> endpoints) {
        this.endpoints = endpoints;
    }

    public String getTableSpace() {
        return this.tableSpace;
    }

    public void setTableSpace(String tableSpace) {
        this.tableSpace = tableSpace;
    }
}

