/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.transducers;

import java.util.ArrayList;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.lexicalmatcher.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnType;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.ServiceType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.ServiceParameters;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.transducers.OccurrencePointsMerger;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;

public class OccurrencePointsDuplicatesDeleter
extends OccurrencePointsMerger {
    String tableName;
    List<String> records = new ArrayList<String>();

    @Override
    public List<StatisticalType> getInputParameters() {
        ArrayList<TableTemplates> templatesOccurrence = new ArrayList<TableTemplates>();
        templatesOccurrence.add(TableTemplates.OCCURRENCE_SPECIES);
        PrimitiveType p0 = new PrimitiveType(String.class.getName(), null, PrimitiveTypes.STRING, finalTableNameL, "the name of the produced table", "DeletedOcc_");
        InputTable p1 = new InputTable(templatesOccurrence, tableNameF, "the table containing the occurrence points (up to 100 000 points)", "");
        ColumnType p3 = new ColumnType(tableNameF, longitudeColumn, "column with longitude values", "decimallongitude", false);
        ColumnType p4 = new ColumnType(tableNameF, latitudeColumn, "column with latitude values", "decimallatitude", false);
        ColumnType p5 = new ColumnType(tableNameF, recordedByColumn, "column with RecordedBy values", "recordedby", false);
        ColumnType p6 = new ColumnType(tableNameF, scientificNameColumn, "column with Scientific Names", "scientificname", false);
        ColumnType p7 = new ColumnType(tableNameF, eventDateColumn, "column with EventDate values", "eventdate", false);
        ColumnType p8 = new ColumnType(tableNameF, lastModificationColumn, "column with Modified values", "modified", false);
        ServiceType p9 = new ServiceType(ServiceParameters.RANDOMSTRING, finalTableNameF, "name of the resulting table", "processedOccurrences_");
        PrimitiveType p10 = new PrimitiveType(Float.class.getName(), null, PrimitiveTypes.NUMBER, spatialTolerance, "the tolerance in degree for assessing that two points could be the same", "0.5");
        PrimitiveType p11 = new PrimitiveType(Float.class.getName(), null, PrimitiveTypes.NUMBER, confidence, "the overall acceptance similarity threshold over which two points are the same - from 0 to 100", "80");
        ArrayList<StatisticalType> inputs = new ArrayList<StatisticalType>();
        inputs.add(p0);
        inputs.add(p1);
        inputs.add(p3);
        inputs.add(p4);
        inputs.add(p5);
        inputs.add(p6);
        inputs.add(p7);
        inputs.add(p8);
        inputs.add(p9);
        inputs.add(p10);
        inputs.add(p11);
        DatabaseType.addDefaultDBPars(inputs);
        return inputs;
    }

    @Override
    public String getDescription() {
        return "An algorithm for deleting similar occurrences in a sets of occurrence points of species coming from the Species Discovery Facility of D4Science. Works with up to 100 000 points";
    }

    @Override
    public void init() throws Exception {
        AnalysisLogger.setLogger(String.valueOf(this.config.getConfigPath()) + AlgorithmConfiguration.defaultLoggerFile);
        this.lonFld = this.config.getParam(longitudeColumn);
        this.latFld = this.config.getParam(latitudeColumn);
        this.recordedByFld = this.config.getParam(recordedByColumn);
        this.scientificNameFld = this.config.getParam(scientificNameColumn);
        this.eventDatFld = this.config.getParam(eventDateColumn);
        this.modifDatFld = this.config.getParam(lastModificationColumn);
        this.rightTableName = this.tableName = this.config.getParam(tableNameF);
        this.leftTableName = this.tableName;
        this.finalTableName = this.config.getParam(finalTableNameF);
        this.finalTableLabel = this.config.getParam(finalTableNameL);
        this.spatialToleranceValue = Float.parseFloat(this.config.getParam(spatialTolerance));
        this.confidenceValue = Float.parseFloat(this.config.getParam(confidence));
        this.objectstoinsert = new ArrayList();
        this.objectstodelete = new ArrayList();
        this.records = new ArrayList<String>();
        this.status = 0.0f;
    }

    protected boolean isBetterThan(OccurrencePointsMerger.OccurrenceRecord leftOcc, OccurrencePointsMerger.OccurrenceRecord rightOcc) {
        if (leftOcc.modifdate != null && rightOcc.modifdate != null && leftOcc.modifdate.before(rightOcc.modifdate) || leftOcc.modifdate == null && rightOcc.modifdate != null) {
            return false;
        }
        return leftOcc.modifdate != null && rightOcc.modifdate != null && leftOcc.modifdate.after(rightOcc.modifdate) || leftOcc.modifdate != null && rightOcc.modifdate == null;
    }

    @Override
    protected void prepareFinalTable() throws Exception {
        DatabaseFactory.executeSQLUpdate(DatabaseUtils.createBlankTableFromAnotherStatement(this.tableName, this.finalTableName), this.dbconnection);
    }

    @Override
    public void takeFullRanges() {
        AnalysisLogger.getLogger().info((Object)("Taking elements from left table: " + this.leftTableName));
        this.leftRows = DatabaseFactory.executeSQLQuery(DatabaseUtils.getDinstictElements(this.tableName, this.columns.toString(), "limit 100000"), this.dbconnection);
    }

    @Override
    public void takeRange(int offsetLeft, int numLeft, int offsetRight, int numRight) {
        AnalysisLogger.getLogger().info((Object)("Taking elements from left table: " + this.leftTableName));
        this.leftRows = DatabaseFactory.executeSQLQuery(DatabaseUtils.getDinstictElements(this.leftTableName, this.columns.toString(), "offset " + offsetLeft + " limit " + numLeft), this.dbconnection);
    }

    @Override
    public void computeRange() throws Exception {
        try {
            try {
                AnalysisLogger.getLogger().trace((Object)"Processing");
                this.status = 10.0f;
                int similaritiesCounter = 0;
                int allrows = 0;
                if (this.leftRows != null) {
                    allrows = this.leftRows.size();
                }
                int rowcounter = 0;
                if (allrows > 0) {
                    for (Object row : this.leftRows) {
                        OccurrencePointsMerger.OccurrenceRecord testOcc = this.row2OccurrenceRecord((Object[])row);
                        int k = 0;
                        int insertedSize = this.objectstoinsert.size();
                        boolean candidate = true;
                        while (k < insertedSize) {
                            OccurrencePointsMerger.OccurrenceRecord yetInserted = (OccurrencePointsMerger.OccurrenceRecord)this.objectstoinsert.get(k);
                            float prob = this.extProb(yetInserted, testOcc);
                            if (prob >= this.confidenceValue) {
                                ++similaritiesCounter;
                                if (this.isBetterThan(testOcc, yetInserted)) {
                                    AnalysisLogger.getLogger().trace((Object)("Found a similarity with P=" + prob + " between (" + "\"" + testOcc.scientificName + "\"" + "," + testOcc.x + "\"" + "," + "\"" + testOcc.y + "\"" + "," + "\"" + testOcc.recordedby + "\"" + "," + "\"" + OccurrencePointsDuplicatesDeleter.convert2conventionalFormat(testOcc.eventdate) + "\"" + ") VS " + "(" + "\"" + yetInserted.scientificName + "\"" + "," + "\"" + yetInserted.x + "\"" + "," + "\"" + yetInserted.y + "\"" + "," + "\"" + yetInserted.recordedby + "\"" + "," + "\"" + OccurrencePointsDuplicatesDeleter.convert2conventionalFormat(yetInserted.eventdate) + "\"" + ")"));
                                    this.objectstoinsert.remove(k);
                                    --k;
                                    --insertedSize;
                                } else {
                                    candidate = false;
                                    break;
                                }
                            }
                            ++k;
                        }
                        if (candidate) {
                            this.objectstoinsert.add(testOcc);
                        }
                        this.status = Math.min(90.0f, 10.0f + 80.0f * (float)rowcounter / (float)allrows);
                        ++rowcounter;
                    }
                    AnalysisLogger.getLogger().trace((Object)("Found " + similaritiesCounter + " similarities on " + allrows + " distinct elements"));
                    this.status = 90.0f;
                    this.persist();
                }
            }
            catch (Exception e) {
                System.err.println("Error in computation");
                AnalysisLogger.getLogger().info((Object)e);
                throw e;
            }
        }
        finally {
            this.shutdown();
            this.status = 100.0f;
            AnalysisLogger.getLogger().trace((Object)"Occ Points Processing Finished and db closed");
        }
    }

    public void computeOLD() throws Exception {
        try {
            try {
                AnalysisLogger.getLogger().trace((Object)"Initializing DB Connection");
                this.dbconnection = DatabaseUtils.initDBSession(this.config);
                AnalysisLogger.getLogger().trace((Object)"Taking Table Description");
                AnalysisLogger.getLogger().trace((Object)("Creating final table: " + this.finalTableName));
                try {
                    DatabaseFactory.executeSQLUpdate(DatabaseUtils.dropTableStatement(this.finalTableName), this.dbconnection);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                AnalysisLogger.getLogger().trace((Object)("Preparing table: " + this.finalTableName));
                this.prepareFinalTable();
                AnalysisLogger.getLogger().trace((Object)("Extracting columns from: " + this.finalTableName));
                this.extractColumnNames();
                AnalysisLogger.getLogger().trace((Object)("Taken Table Description: " + this.columns));
                AnalysisLogger.getLogger().trace((Object)("Taking elements from table: " + this.tableName));
                List<Object> rows = DatabaseFactory.executeSQLQuery(DatabaseUtils.getDinstictElements(this.tableName, this.columns.toString(), ""), this.dbconnection);
                AnalysisLogger.getLogger().trace((Object)"Processing");
                this.status = 10.0f;
                int similaritiesCounter = 0;
                int allrows = rows.size();
                int rowcounter = 0;
                for (Object row : rows) {
                    OccurrencePointsMerger.OccurrenceRecord testOcc = this.row2OccurrenceRecord((Object[])row);
                    int k = 0;
                    int insertedSize = this.objectstoinsert.size();
                    boolean candidate = true;
                    while (k < insertedSize) {
                        OccurrencePointsMerger.OccurrenceRecord yetInserted = (OccurrencePointsMerger.OccurrenceRecord)this.objectstoinsert.get(k);
                        float prob = this.extProb(yetInserted, testOcc);
                        if (prob >= this.confidenceValue) {
                            ++similaritiesCounter;
                            if (this.isBetterThan(testOcc, yetInserted)) {
                                AnalysisLogger.getLogger().trace((Object)("Found a similarity with P=" + prob + " between (" + "\"" + testOcc.scientificName + "\"" + "," + testOcc.x + "\"" + "," + "\"" + testOcc.y + "\"" + "," + "\"" + testOcc.recordedby + "\"" + "," + "\"" + OccurrencePointsDuplicatesDeleter.convert2conventionalFormat(testOcc.eventdate) + "\"" + ") VS " + "(" + "\"" + yetInserted.scientificName + "\"" + "," + "\"" + yetInserted.x + "\"" + "," + "\"" + yetInserted.y + "\"" + "," + "\"" + yetInserted.recordedby + "\"" + "," + "\"" + OccurrencePointsDuplicatesDeleter.convert2conventionalFormat(yetInserted.eventdate) + "\"" + ")"));
                                this.objectstoinsert.remove(k);
                                --k;
                                --insertedSize;
                            } else {
                                candidate = false;
                                break;
                            }
                        }
                        ++k;
                    }
                    if (candidate) {
                        this.objectstoinsert.add(testOcc);
                    }
                    this.status = Math.min(90.0f, 10.0f + 80.0f * (float)rowcounter / (float)allrows);
                    ++rowcounter;
                }
                AnalysisLogger.getLogger().trace((Object)("Found " + similaritiesCounter + " similarities on " + allrows + " distinct elements"));
                this.status = 90.0f;
                this.persist();
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().trace((Object)("An error occurred " + e.getLocalizedMessage()));
                throw e;
            }
        }
        finally {
            if (this.dbconnection != null) {
                this.dbconnection.close();
            }
            this.status = 100.0f;
            AnalysisLogger.getLogger().trace((Object)"Occ Points Processing Finished and db closed");
        }
    }

    @Override
    public void postProcess() throws Exception {
    }
}

