/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.signals;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.preprocessing.sampling.AbsoluteSampling;
import com.rapidminer.operator.preprocessing.series.filter.SeriesMissingValueReplenishment;
import com.rapidminer.tools.OperatorService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.gcube.contentmanagement.graphtools.data.BigSamplesTable;
import org.gcube.contentmanagement.graphtools.plotting.graphs.NumericSeriesGraph;
import org.gcube.contentmanagement.graphtools.plotting.graphs.TimeSeriesGraph;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.lexicalmatcher.utils.MathFunctions;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.signals.Delta;
import org.gcube.dataanalysis.ecoengine.signals.SignalConversions;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class SignalProcessing {
    public static double[][] applyFilterBank(double[][] feature, int numCepstra, int numMelFilters, int samplingRate, int frameLength, float minCutFequency, float maxCutFrequency) throws Exception {
        int recalcMelFilters = SignalConversions.recalculateMaxMelFilters(samplingRate, numMelFilters, minCutFequency, maxCutFrequency);
        double[][] mels = new double[feature.length][numCepstra];
        int i = 0;
        double[][] dArray = feature;
        int n = feature.length;
        int n2 = 0;
        while (n2 < n) {
            double[] bin = dArray[n2];
            int[] cbin = SignalConversions.fftBinIndices(samplingRate, frameLength, numMelFilters, recalcMelFilters, minCutFequency, maxCutFrequency);
            double[] f = SignalConversions.melFilter(bin, cbin, recalcMelFilters);
            double[] cepstra = SignalConversions.cepCoefficients(f, numCepstra, recalcMelFilters);
            mels[i] = cepstra;
            ++i;
            ++n2;
        }
        double[][] deltamels = new double[feature.length][numCepstra * 3];
        int k = 0;
        while (k < feature.length) {
            int g = 0;
            while (g < mels[0].length) {
                deltamels[k][g] = mels[k][g];
                ++g;
            }
            ++k;
        }
        Delta.calcDelta(deltamels, numCepstra);
        Delta.calcDoubleDelta(deltamels, numCepstra);
        return deltamels;
    }

    public static double[][] calculateSumSpectrum(List<double[]> signals, int windowShiftSamples, int frameLength, int samplingRate) throws Exception {
        int signalLenght = signals.get(0).length;
        AnalysisLogger.getLogger().debug((Object)("TRIALS LENGHT " + signalLenght));
        ArrayList<double[][]> spectrograms = new ArrayList<double[][]>();
        AnalysisLogger.getLogger().debug((Object)"Getting Spectra");
        int j = 0;
        for (double[] signal : signals) {
            double[][] spectro = SignalConversions.spectrogram("Spectrogram", signal, samplingRate, windowShiftSamples, frameLength, false);
            AnalysisLogger.getLogger().debug((Object)("Signal Number " + (j + 1) + " spectrum lenght " + spectro.length * windowShiftSamples / samplingRate));
            spectrograms.add(spectro);
            ++j;
        }
        AnalysisLogger.getLogger().debug((Object)"Summing Spectra");
        double[][] sumSpectro = SignalProcessing.sumSpectra(spectrograms);
        spectrograms = null;
        return sumSpectro;
    }

    public static double[][] concatenateSpectra(List<double[][]> spectra) {
        double[][] firstSpectrum = spectra.get(0);
        int mi = firstSpectrum.length;
        int mj = firstSpectrum[0].length;
        int nSpectra = spectra.size();
        double[][] concatenatedSpectrum = new double[mi][mj * nSpectra];
        int k = 0;
        for (double[][] spectrum : spectra) {
            int i = 0;
            while (i < mi) {
                int j = 0;
                while (j < mj) {
                    concatenatedSpectrum[i][j + k * mj] = spectrum[i][j];
                    ++j;
                }
                ++i;
            }
            ++k;
        }
        return concatenatedSpectrum;
    }

    public static void displaySignalWithGenericTime(double[] signal, float t0, float timeshift, String name) {
        XYSeries xyseries = new XYSeries((Comparable)((Object)name));
        float time = t0;
        int i = 0;
        while (i < signal.length) {
            xyseries.add((double)time, signal[i]);
            time += timeshift;
            ++i;
        }
        XYSeriesCollection collection = new XYSeriesCollection(xyseries);
        NumericSeriesGraph nsg = new NumericSeriesGraph(name);
        nsg.render((Dataset)collection);
    }

    public static void displaySignalWithTime(double[] signal, Date[] dates, String name, String format) {
        TimeSeries series = new TimeSeries((Comparable)((Object)name));
        int i = 0;
        while (i < signal.length) {
            series.add((RegularTimePeriod)new FixedMillisecond(dates[i]), signal[i]);
            ++i;
        }
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(series);
        TimeSeriesGraph tsg = new TimeSeriesGraph(name);
        tsg.timeseriesformat = format;
        tsg.render((Dataset)dataset);
    }

    public static double[] downSample(double[] signal, int numElements, AlgorithmConfiguration config) throws Exception {
        config.initRapidMiner();
        double[] rebuiltSignal = new double[signal.length];
        Arrays.fill(rebuiltSignal, Double.NaN);
        BigSamplesTable samples = new BigSamplesTable();
        int k = 0;
        while (k < signal.length) {
            samples.addSampleRow("" + k, signal[k]);
            ++k;
        }
        ExampleSet es = samples.generateExampleSet();
        AnalysisLogger.getLogger().debug((Object)"Example Set Created");
        AbsoluteSampling sampler = (AbsoluteSampling)OperatorService.createOperator((String)"AbsoluteSampling");
        sampler.setParameter("sample_size", "" + numElements);
        sampler.setParameter("local_random_seed", "-1");
        es = sampler.apply(es);
        AnalysisLogger.getLogger().debug((Object)"Finished");
        SignalConversions.exampleSet2Signal(rebuiltSignal, es);
        return rebuiltSignal;
    }

    public static double[][] extractSumSpectrum(String file, int windowShiftSamples, int frameLength, int samplingRate) throws Exception {
        List<double[]> signals = SignalProcessing.readSignalsFromCSV(file, ",");
        int signalLenght = signals.get(0).length;
        ArrayList sumspectrograms = new ArrayList();
        ArrayList<double[][]> spectrograms = new ArrayList<double[][]>();
        AnalysisLogger.getLogger().debug((Object)"Getting Spectra");
        int j = 0;
        for (double[] signal : signals) {
            AnalysisLogger.getLogger().debug((Object)("Signal Number " + (j + 1)));
            double[][] spectro = SignalConversions.spectrogram("Spectrogram", signal, samplingRate, windowShiftSamples, frameLength, false);
            spectrograms.add(spectro);
            ++j;
        }
        AnalysisLogger.getLogger().debug((Object)"Summing Spectra");
        double[][] sumSpectro = SignalProcessing.sumSpectra(spectrograms);
        spectrograms = null;
        return sumSpectro;
    }

    public static Date[] fillTimeLine(double[] timeseconds, double samplingRate, AlgorithmConfiguration config) throws Exception {
        double[] values = new double[timeseconds.length];
        int i = 0;
        while (i < timeseconds.length) {
            values[i] = timeseconds[i] * 1000.0;
            ++i;
        }
        double[] milliseconds = SignalProcessing.fillTimeSeries(values, timeseconds, samplingRate, config);
        Date[] dates = new Date[milliseconds.length];
        int i2 = 0;
        while (i2 < milliseconds.length) {
            dates[i2] = new Date((long)milliseconds[i2]);
            ++i2;
        }
        return dates;
    }

    public static double[] fillSignal(double[] signal) throws Exception {
        ExampleSet es = SignalConversions.signal2ExampleSet(signal);
        SeriesMissingValueReplenishment sampler = (SeriesMissingValueReplenishment)OperatorService.createOperator((String)"SeriesMissingValueReplenishment");
        sampler.setParameter("attribute_name", "att0");
        sampler.setParameter("replacement", "3");
        es = sampler.apply(es);
        AnalysisLogger.getLogger().debug((Object)"Finished");
        double[] rebuiltSignal = new double[signal.length];
        SignalConversions.exampleSet2Signal(rebuiltSignal, es, 0.0);
        return rebuiltSignal;
    }

    public static double[] fillTimeSeries(double[] values, double[] timeseconds, double samplingRate, AlgorithmConfiguration config) throws Exception {
        config.initRapidMiner();
        double t0 = timeseconds[0];
        double t1 = timeseconds[timeseconds.length - 1];
        int signalength = (int)((t1 - t0) * samplingRate) + 1;
        double[] signal = new double[signalength];
        Arrays.fill(signal, Double.NaN);
        int i = 0;
        while (i < values.length) {
            if (values[i] != Double.NaN) {
                int index = (int)((timeseconds[i] - t0) * samplingRate);
                signal[index] = values[i];
            }
            ++i;
        }
        double[] rebuiltSignal = new double[signal.length];
        BigSamplesTable samples = new BigSamplesTable();
        int k = 0;
        while (k < signal.length) {
            samples.addSampleRow("" + k, signal[k]);
            ++k;
        }
        ExampleSet es = samples.generateExampleSet();
        AnalysisLogger.getLogger().debug((Object)"Example Set Created");
        SeriesMissingValueReplenishment sampler = (SeriesMissingValueReplenishment)OperatorService.createOperator((String)"SeriesMissingValueReplenishment");
        sampler.setParameter("attribute_name", "att0");
        sampler.setParameter("replacement", "3");
        es = sampler.apply(es);
        AnalysisLogger.getLogger().debug((Object)"Finished");
        SignalConversions.exampleSet2Signal(rebuiltSignal, es);
        return rebuiltSignal;
    }

    public static double[][] multiSignalAnalysis(List<double[]> signals, int samplingRate, int windowshift, int frameslength, boolean display) throws Exception {
        ArrayList<double[][]> spectra = new ArrayList<double[][]>();
        for (double[] signal : signals) {
            spectra.add(SignalConversions.spectrogram("Spectrogram", signal, samplingRate, windowshift, frameslength, display));
        }
        double[][] sumSpec = SignalProcessing.sumSpectra(spectra);
        return sumSpec;
    }

    public static List<double[]> readSignalsFromCSV(String file, String delimiter) throws Exception {
        BufferedReader br = new BufferedReader(new FileReader(new File(file)));
        String line = br.readLine();
        ArrayList<double[]> signals = new ArrayList<double[]>();
        while (line != null) {
            double[] signal = SignalProcessing.readSignalFromCSVLine(line, delimiter);
            signals.add(signal);
            line = br.readLine();
        }
        br.close();
        return signals;
    }

    public static double[] readSignalFromCSVLine(String line, String delimiter) throws Exception {
        String[] splitted = line.split(delimiter);
        double[] signal = new double[splitted.length];
        int i = 0;
        while (i < splitted.length) {
            signal[i] = Double.parseDouble(splitted[i]);
            ++i;
        }
        return signal;
    }

    public static double[][] sumSpectra(List<double[][]> spectra) {
        double[][] firstSpectrum = spectra.get(0);
        int mi = firstSpectrum.length;
        int mj = firstSpectrum[0].length;
        double[][] sumSpectrum = new double[mi][mj];
        int k = 0;
        for (double[][] spectrum : spectra) {
            int i = 0;
            while (i < mi) {
                int j = 0;
                while (j < mj) {
                    sumSpectrum[i][j] = MathFunctions.incrementAvg(sumSpectrum[i][j], spectrum[i][j], k);
                    ++j;
                }
                ++i;
            }
            ++k;
        }
        return sumSpectrum;
    }

    public static double[][] takeCentralSpectrum(double[][] spectrum, float numOfCentralSeconds, float windowShiftTime, int sampleRate) {
        float maxTime = (float)spectrum.length * windowShiftTime;
        float centralTime = maxTime / (2.0f * numOfCentralSeconds);
        AnalysisLogger.getLogger().debug((Object)("Max Time in the Spectrum " + maxTime + " Central time " + centralTime));
        int startIndex = (int)(centralTime / windowShiftTime);
        int endIndex = (int)((centralTime + numOfCentralSeconds) / windowShiftTime);
        AnalysisLogger.getLogger().debug((Object)("Recalculated lenght " + maxTime + " sec"));
        AnalysisLogger.getLogger().debug((Object)("Lenght " + spectrum.length));
        AnalysisLogger.getLogger().debug((Object)("Start " + startIndex + " End " + endIndex + " max " + spectrum.length + " Cut lenght " + (float)(endIndex - startIndex + 1) * windowShiftTime));
        double[][] cutSpectrum = new double[endIndex - startIndex + 1][spectrum[0].length];
        int i = startIndex;
        while (i <= endIndex) {
            cutSpectrum[i - startIndex] = spectrum[i];
            ++i;
        }
        return cutSpectrum;
    }

    public static void main(String[] args) throws Exception {
        AlgorithmConfiguration conf = new AlgorithmConfiguration();
        conf.setConfigPath("./cfg/");
        conf.initRapidMiner();
        double[] signal = new double[]{Double.NaN, 1.0, 2.0, 3.0, 4.0, 5.0, Double.NaN};
        double[] resignal = SignalProcessing.fillSignal(signal);
        System.out.println(resignal);
    }
}

