/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.utils;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.ExampleTable;
import com.thoughtworks.xstream.XStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.regexp.RE;
import org.gcube.contentmanagement.graphtools.data.BigSamplesTable;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.utils.Sha1;

public class Transformations {
    public static ExampleSet matrix2ExampleSet(double[][] sampleVectors) {
        int m = sampleVectors.length;
        BigSamplesTable samples = new BigSamplesTable();
        for (int k = 0; k < m; ++k) {
            samples.addSampleRow("sample", sampleVectors[k]);
        }
        return samples.generateExampleSet();
    }

    public static double[][] exampleSet2Matrix(ExampleSet set) {
        int m = set.size();
        ExampleTable table = set.getExampleTable();
        int n = table.getAttributeCount();
        double[][] matrix = new double[m][n - 1];
        for (int i = 0; i < m; ++i) {
            DataRow row = table.getDataRow(i);
            for (int j = 0; j < n - 1; ++j) {
                double d;
                if (table.getAttribute(j).isNominal()) continue;
                matrix[i][j] = d = row.get(table.getAttribute(j));
            }
        }
        return matrix;
    }

    public static double[][] traspose(double[][] matrix) {
        int m = matrix.length;
        if (m > 0) {
            int n = matrix[0].length;
            double[][] columns = new double[n][m];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < m; ++j) {
                    columns[i][j] = matrix[j][i];
                }
            }
            return columns;
        }
        return null;
    }

    public static double[] getColumn(int index, double[][] matrix) {
        int colulen = matrix.length;
        double[] column = new double[colulen];
        for (int i = 0; i < colulen; ++i) {
            column[i] = matrix[i][index];
        }
        return column;
    }

    public static void substColumn(double[] column, int index, double[][] matrix) {
        for (int i = 0; i < matrix.length; ++i) {
            matrix[i][index] = column[i];
        }
    }

    public static double[][] mergeMatrixes(double[][] matrix1, double[][] matrix2) {
        int i;
        if (matrix1 == null || matrix1.length == 0) {
            return matrix2;
        }
        if (matrix2 == null || matrix2.length == 0) {
            return matrix1;
        }
        int len1 = matrix1.length;
        int len2 = matrix2.length;
        int superlen = len1 + len2;
        double[][] supermatrix = new double[superlen][];
        for (i = 0; i < len1; ++i) {
            supermatrix[i] = matrix1[i];
        }
        for (i = len1; i < superlen; ++i) {
            supermatrix[i] = matrix2[i - len1];
        }
        return supermatrix;
    }

    public static String vector2String(double[] vector) {
        String out = "";
        for (int i = 0; i < vector.length; ++i) {
            out = i > 0 ? out + "," + vector[i] : "" + vector[i];
        }
        return out;
    }

    public static Object getObjectFromFile(String file) throws Exception {
        XStream xstream = new XStream();
        return xstream.fromXML((InputStream)new FileInputStream(file));
    }

    public static void dumpObjectToFile(String file, Object toWrite) throws Exception {
        XStream xstream = new XStream();
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        bw.write(xstream.toXML(toWrite));
        bw.close();
    }

    public static void dumpConfig(String pathToFile, AlgorithmConfiguration config) throws Exception {
        Transformations.dumpObjectToFile(pathToFile, config);
    }

    public static AlgorithmConfiguration restoreConfig(String configFile) throws Exception {
        FileInputStream fis = new FileInputStream(new File(configFile));
        AlgorithmConfiguration config = (AlgorithmConfiguration)new XStream().fromXML((InputStream)fis);
        fis.close();
        return config;
    }

    public static double indexString(String string) {
        StringBuffer sb = new StringBuffer();
        if (string == null || string.length() == 0) {
            return -1.0;
        }
        int m = string.length();
        for (int i = 0; i < m; ++i) {
            sb.append((int)string.charAt(i));
        }
        double d = Double.MAX_VALUE;
        try {
            d = Double.valueOf(sb.toString());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (d > 2.147483647E9) {
            return Transformations.indexString(string.substring(0, 3));
        }
        return d;
    }

    public static void main(String[] args) throws Exception {
        List<String> ll = Transformations.parseCVSString("h,t,,,,k,", ",");
        for (String l : ll) {
            System.out.println(l);
        }
        String s = "un'estate al mare";
        System.out.println("index: " + Transformations.indexString(s));
        System.out.println("sha1: " + Sha1.SHA1(s));
        String s1 = "un'estate al mari";
        System.out.println("index: " + Transformations.indexString(s1));
        System.out.println("sha1: " + Sha1.SHA1(s1));
        String s2 = "ciao amico mio come stai oggi? fa caldo o sono io che mi scotto?";
        System.out.println("index: " + Transformations.indexString(s2));
        System.out.println("sha1: " + Sha1.SHA1(s2));
    }

    public static List<String> parseCVSString(String row, String delimiter) throws Exception {
        ArrayList<String> elements = new ArrayList<String>();
        String phrase = row;
        int idxdelim = -1;
        boolean quot = false;
        phrase = phrase.trim();
        while ((idxdelim = phrase.indexOf(delimiter)) >= 0) {
            quot = phrase.startsWith("\"");
            if (quot) {
                phrase = phrase.substring(1);
                RE regexp = new RE("[^\\\\]\"");
                boolean matching = regexp.match(phrase);
                String quoted = "";
                if (matching) {
                    int i0 = regexp.getParenStart(0);
                    quoted = phrase.substring(0, i0 + 1).trim();
                    phrase = phrase.substring(i0 + 2).trim();
                }
                if (phrase.startsWith(delimiter)) {
                    phrase = phrase.substring(1);
                }
                elements.add(quoted);
                continue;
            }
            elements.add(phrase.substring(0, idxdelim));
            phrase = phrase.substring(idxdelim + 1).trim();
        }
        elements.add(phrase);
        return elements;
    }
}

