/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.utils;

import java.awt.Point;
import java.util.Vector;

class Nearest {
    public static final int PROJX = 1;
    public static final int PROJY = 2;
    int n = 10;
    int projaxe;
    int compare;
    int maxradius;
    int ndata;
    Point[] data;
    Point[] xindex;
    Point[] yindex;
    boolean[] flags;
    Point[] cindex;
    int cvalue;
    int cind;
    Point cp;

    public Nearest(Vector points) {
        this.ndata = points.size();
        this.data = new Point[this.ndata];
        this.xindex = new Point[this.ndata];
        this.yindex = new Point[this.ndata];
        this.flags = new boolean[this.ndata];
        for (int i = 0; i < this.ndata; ++i) {
            this.data[i] = (Point)points.elementAt(i);
            this.xindex[i] = new Point(i, this.data[i].x);
            this.yindex[i] = new Point(i, this.data[i].y);
            this.flags[i] = true;
        }
        this.cindex = this.xindex;
        this.BubbleSort();
        this.cindex = this.yindex;
        this.BubbleSort();
        this.compare = 0;
    }

    public void BubbleSort() {
        for (int i = this.ndata - 1; i >= 0; --i) {
            for (int j = 0; j < i; ++j) {
                if (this.cindex[j].y <= this.cindex[j + 1].y) continue;
                Point ptmp = this.cindex[j];
                this.cindex[j] = this.cindex[j + 1];
                this.cindex[j + 1] = ptmp;
            }
        }
    }

    public int getCompare() {
        return this.compare;
    }

    public int getMaxRadius() {
        return this.maxradius;
    }

    public int getProjectionAxe() {
        return this.projaxe;
    }

    private int DichoSearchIndex(int value) {
        int inf = 0;
        int sup = this.ndata - 1;
        if (value <= this.cindex[inf].y) {
            return inf;
        }
        if (value >= this.cindex[sup].y) {
            return sup;
        }
        while (sup > inf) {
            int centre = (inf + sup) / 2;
            if (this.cindex[centre].y == value) {
                return centre;
            }
            if (this.cindex[centre].y < value) {
                inf = centre + 1;
                continue;
            }
            sup = centre - 1;
        }
        return inf;
    }

    private void ResetFlags() {
        for (int i = 0; i < this.ndata; ++i) {
            this.flags[i] = true;
        }
    }

    public Point FindFirstNN(Point p) {
        int sparse2;
        float s2;
        int j;
        int xdim = this.xindex[this.ndata - 1].y - this.xindex[0].y;
        int ydim = this.yindex[this.ndata - 1].y - this.yindex[0].y;
        this.cp = p;
        this.ResetFlags();
        this.cindex = this.xindex;
        int index1 = this.DichoSearchIndex(p.x);
        this.cindex = this.yindex;
        int index2 = this.DichoSearchIndex(p.y);
        int i = index1 - this.n / 2;
        if (i < 0) {
            i = 0;
        }
        if ((j = index1 + this.n / 2) >= this.ndata) {
            j = this.ndata - 1;
        }
        int sparse1 = this.xindex[j].y - this.xindex[i].y;
        float s1 = (float)sparse1 / (float)xdim;
        i = index2 - this.n / 2;
        if (i < 0) {
            i = 0;
        }
        if ((j = index2 + this.n / 2) >= this.ndata) {
            j = this.ndata - 1;
        }
        if (s1 > (s2 = (float)(sparse2 = this.yindex[j].y - this.yindex[i].y) / (float)ydim)) {
            this.cindex = this.xindex;
            this.cvalue = p.x;
            this.cind = index1;
            this.projaxe = 1;
        } else {
            this.cindex = this.yindex;
            this.cvalue = p.y;
            this.cind = index2;
            this.projaxe = 2;
        }
        this.compare = 0;
        this.maxradius = 0;
        return this.FindNextNN();
    }

    public Point FindNextNN() {
        int i;
        int mini;
        float dist;
        int ir;
        float mindist;
        int il;
        for (il = this.cind; !this.flags[this.cindex[il].x] && il > 0; --il) {
        }
        if (this.flags[this.cindex[il].x]) {
            mindist = this.ComputeDistance(this.cp, this.data[this.cindex[il].x]);
            ++this.compare;
        } else {
            mindist = 250000.0f;
        }
        if (this.cind < this.ndata - 1) {
            for (ir = this.cind + 1; !this.flags[this.cindex[ir].x] && ir < this.ndata - 1; ++ir) {
            }
            if (this.flags[this.cindex[ir].x]) {
                dist = this.ComputeDistance(this.cp, this.data[this.cindex[ir].x]);
                ++this.compare;
            } else {
                dist = 250000.0f;
            }
            if (mindist < dist) {
                this.maxradius = (int)Math.sqrt(mindist);
                mini = il;
            } else {
                mini = ir;
                this.maxradius = (int)Math.sqrt(dist);
                mindist = dist;
            }
        } else {
            mini = il;
            ir = this.ndata - 1;
            this.maxradius = (int)Math.sqrt(mindist);
        }
        for (i = il - 1; i > 0 && this.maxradius > Math.abs(this.cvalue - this.cindex[i].y); --i) {
            if (!this.flags[this.cindex[i].x]) continue;
            dist = this.ComputeDistance(this.cp, this.data[this.cindex[i].x]);
            ++this.compare;
            if (!(dist < mindist)) continue;
            mindist = dist;
            mini = i;
        }
        for (i = ir + 1; i < this.ndata && this.maxradius > Math.abs(this.cindex[i].y - this.cvalue); ++i) {
            if (!this.flags[this.cindex[i].x]) continue;
            dist = this.ComputeDistance(this.cp, this.data[this.cindex[i].x]);
            ++this.compare;
            if (!(dist < mindist)) continue;
            mindist = dist;
            mini = i;
        }
        this.flags[this.cindex[mini].x] = false;
        return this.data[this.cindex[mini].x];
    }

    public Point FindNearestNeighborCrude(Point p) {
        int mini = 0;
        this.compare = 0;
        float mindist = this.ComputeDistance(p, this.data[mini]);
        for (int i = 0; i < this.ndata; ++i) {
            float dist = this.ComputeDistance(p, this.data[i]);
            ++this.compare;
            if (!(dist < mindist)) continue;
            mini = i;
            mindist = dist;
        }
        return this.data[mini];
    }

    public float ComputeDistance(Point p1, Point p2) {
        float dx = p2.x - p1.x;
        float dy = p2.y - p1.y;
        return dx * dx + dy * dy;
    }
}

