package org.gcube.dataanalysis.ecoengine.transducers.charts;

import java.awt.Image;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import org.gcube.contentmanagement.graphtools.data.conversions.ImageTools;
import org.gcube.contentmanagement.graphtools.plotting.graphs.LineGraph;
import org.gcube.contentmanagement.graphtools.plotting.graphs.TimeSeriesGraph;
import org.gcube.contentmanagement.graphtools.plotting.graphs.TransectLineGraph;
import org.gcube.contentmanagement.graphtools.utils.DateGuesser;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnType;
import org.gcube.dataanalysis.ecoengine.utils.TimeAnalyzer;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class TimeSeriesChartsTransducerer extends QuantitiesAttributesChartsTransducerer {

	@Override
	protected void setInputParameters() {
		super.setInputParameters();
		ColumnType p = new ColumnType(inputTableParameter, timeParameter, "The column containing time information", "year", false);
		inputs.add(p);
	}

	@Override
	public String getDescription() {
		return "An algorithm producing time series charts of attributes vs. quantities. Charts are displayed per quantity column and only the top ten quantities are reported.";
	}

	String timepattern = "";
	SimpleDateFormat formatter = null;
	Date sampleTime = null;

	public Date getTime(String timel) {
		try {
			if (formatter == null) {
				TimeAnalyzer analyzer = new TimeAnalyzer();
				sampleTime = analyzer.string2Date(timel);
				timepattern = analyzer.getPattern();
				AnalysisLogger.getLogger().debug("TimeSeriesChart: Time pattern: " + timepattern);
				formatter = new SimpleDateFormat(timepattern);
			}

			return formatter.parse(timel);
		} catch (ParseException e) {
			e.printStackTrace();
			return null;
		}
	}

	public String getChartPattern(Date time) {

		if (timepattern.equals("s") || DateGuesser.isJavaDateOrigin(time)) {
			return "HH:mm:ss:SS";
		} else {
			if (timepattern.length() == 4)
				return "yyyy";
			else
				return "MM-dd-yy";
		}
	}

	@Override
	public Image[] createCharts(String[] dimensions, String quantity, String time, List<Object> rows, boolean displaychart) {

		if (dimensions==null)
			dimensions = new String[0];
		
		TimeSeriesCollection dataset = new TimeSeriesCollection();
		TimeSeries series = null;
		if (dimensions.length>0)
			series = new TimeSeries("Trend of " + quantity + " for " + Arrays.toString(dimensions).replace("[", "").replace("]", ""));
		else
			series = new TimeSeries("Trend of " + quantity);
		dataset.addSeries(series);

		DefaultCategoryDataset[] linedatasets = new DefaultCategoryDataset[dimensions.length];

		for (Object row : rows) {
			Object[] array = (Object[]) row;
			Double q = null;
			Date timeD = null;
			String timel = "" + array[array.length - 1];
			try {
				q = Double.parseDouble("" + array[array.length - 2]);
				timeD = getTime(timel);
			} catch (Exception e) {
			}

			if (q != null && timeD != null) {
				FixedMillisecond ms = new FixedMillisecond(timeD);
				series.add(ms, q);

				for (int dimIdx=0;dimIdx<dimensions.length;dimIdx++) {
					String dimensionValue = "";
					if (array[dimIdx] != null)
						dimensionValue = "" + array[dimIdx];
					if (dimensionValue.length() > 0) {
						DefaultCategoryDataset lineds = linedatasets[dimIdx];
						if (lineds == null){
							lineds = new DefaultCategoryDataset();
							linedatasets[dimIdx]=lineds;
						}
						lineds.addValue(q, "singlets", timel + ";[" + dimensionValue + "]");
					}
				}
			}
		}

		Image chartTS = ImageTools.toImage(TimeSeriesGraph.createStaticChart(dataset, getChartPattern(sampleTime), "Variations of " + quantity).createBufferedImage(680, 420));

		if (displaychart) {
			TimeSeriesGraph tsg = new TimeSeriesGraph("Variations of " + quantity);
			tsg.timeseriesformat = getChartPattern(sampleTime);
			tsg.render(dataset);
			for (int i = 0; i < dimensions.length; i++) {
				TransectLineGraph tlg = new TransectLineGraph("Variations of " + dimensions[i]);
				tlg.render(linedatasets[i]);
			}
		}

		Image[] charts = new Image[1 + dimensions.length];
		charts[0] = chartTS;
		for (int i = 0; i < dimensions.length; i++) {
			Image linechartTS = ImageTools.toImage(LineGraph.createStaticChart(linedatasets[i], "Variations of " + dimensions[i]).createBufferedImage(680, 420));
			charts[i+1] = linechartTS;
		}
		return charts;
	}

}
