/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.graphtools.abstracts;

import java.awt.Container;
import java.awt.Image;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.gcube.contentmanagement.graphtools.data.conversions.ImageTools;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.portlets.user.timeseries.charts.support.types.GraphData;
import org.gcube.portlets.user.timeseries.charts.support.types.GraphGroups;
import org.gcube.portlets.user.timeseries.charts.support.types.Point;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public abstract class GenericStandaloneGraph
extends ApplicationFrame {
    private static final long serialVersionUID = 1L;
    protected boolean big = false;

    public GenericStandaloneGraph(String title) {
        super(title);
    }

    protected abstract Dataset generateDataset();

    protected abstract JFreeChart createChart(Dataset var1);

    protected abstract GenericStandaloneGraph getInstance(String var1);

    public void render(Dataset set) {
        this.render(-1.0, -1.0, set);
    }

    public void render(double x, double y, Dataset set) {
        JFreeChart chart = this.createChart(set);
        ChartPanel jp = new ChartPanel(chart);
        this.setContentPane((Container)jp);
        this.pack();
        if (this.big) {
            this.setBounds(0, 0, (int)this.getBounds().getWidth() * 2, (int)this.getBounds().getHeight() * 2);
        }
        if (x == -1.0 || y == -1.0) {
            RefineryUtilities.centerFrameOnScreen((Window)((Object)this));
        } else {
            RefineryUtilities.positionFrameOnScreen((Window)((Object)this), (double)x, (double)y);
        }
        this.setVisible(true);
    }

    public List<Image> renderGraphGroupImage(int width, int height, GraphGroups graphgroups) {
        ArrayList<Image> images = new ArrayList<Image>();
        Map<String, GraphData> graphmap = graphgroups.getGraphs();
        double x = 0.0;
        double y = 0.0;
        double max = 1.0;
        for (String key : graphmap.keySet()) {
            GenericStandaloneGraph graph = this.getInstance(key);
            Dataset datas = graph.convert2Dataset(graphmap.get(key));
            images.add(graph.renderImgObject(width, height, datas));
            y += 0.1;
            if (!((x += 0.1) > max) && !(y > max)) continue;
            x = 0.0;
            y = 0.0;
        }
        return images;
    }

    public void renderImages(String filePath, int width, int height, GraphGroups graphgroups) {
        List<Image> images = this.renderGraphGroupImage(width, height, graphgroups);
        int i = 0;
        for (Image img : images) {
            BufferedImage bimage = ImageTools.toBufferedImage(img);
            File outputfile = new File(String.valueOf(filePath) + "_" + i + ".png");
            try {
                ImageIO.write((RenderedImage)bimage, "png", outputfile);
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().error((Object)"renderImages->Error in writing files ", (Throwable)e);
            }
            ++i;
        }
    }

    public Image renderImgObject(int width, int height, Dataset set) {
        JFreeChart chart = this.createChart(set);
        Image image = ImageTools.toImage(chart.createBufferedImage(width, height));
        return image;
    }

    public void renderGraphGroup(GraphGroups graphgroups) {
        Map<String, GraphData> graphmap = graphgroups.getGraphs();
        double x = 0.0;
        double y = 0.0;
        double max = 1.0;
        for (String key : graphmap.keySet()) {
            GenericStandaloneGraph graph = this.getInstance(key);
            Dataset datas = graph.convert2Dataset(graphmap.get(key));
            graph.render(x, y, datas);
            y += 0.1;
            if (!((x += 0.1) > max) && !(y > max)) continue;
            x = 0.0;
            y = 0.0;
        }
    }

    protected Dataset convert2Dataset(GraphData st) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        List<Point<? extends Number, ? extends Number>> pointslist = st.getData();
        int numbOfRows = pointslist.size();
        if (numbOfRows > 0) {
            int numbOfCols = pointslist.get(0).getEntries().size();
            int x = 0;
            while (x < numbOfRows) {
                String xlabel = pointslist.get(x).getLabel();
                int y = 0;
                while (y < numbOfCols) {
                    double value = pointslist.get(x).getEntries().get(y).getValue().doubleValue();
                    String ylabel = pointslist.get(x).getEntries().get(y).getLabel();
                    dataset.addValue(value, (Comparable)((Object)xlabel), (Comparable)((Object)ylabel));
                    ++y;
                }
                ++x;
            }
        }
        return dataset;
    }
}

