/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.signals.ssa;

import java.util.ArrayList;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.signals.ssa.SSADataset;
import org.gcube.dataanalysis.ecoengine.signals.ssa.SSAGroupList;
import org.gcube.dataanalysis.ecoengine.signals.ssa.SSAUnselectList;
import org.gcube.dataanalysis.ecoengine.signals.ssa.SingularSpectrumAnalysis;

public class SSAWorkflow {
    public static SSADataset applyCompleteWorkflow(List<Double> timeseries, int analysisWindowLength, float eigenValuesPercentageThreshold, int nPointsToForecast, boolean reportReconstructedSignal) {
        SSADataset data = new SSADataset();
        data.setTimeSeries(timeseries);
        data.setL(analysisWindowLength);
        data.setPercThreshold(eigenValuesPercentageThreshold);
        SingularSpectrumAnalysis.inclosure(data);
        System.gc();
        SingularSpectrumAnalysis.singularDecomposition(data);
        System.gc();
        SingularSpectrumAnalysis.setMovingAverage(data);
        System.gc();
        SingularSpectrumAnalysis.averagedCovariance(data);
        System.gc();
        SingularSpectrumAnalysis.functionEigenValue(data);
        ArrayList<SSAGroupList> groupsModel = new ArrayList<SSAGroupList>();
        ArrayList<SSAUnselectList> groups = new ArrayList<SSAUnselectList>();
        AnalysisLogger.getLogger().debug((Object)"Listing All the Eigenvalues");
        int i = 0;
        while (i < data.getPercentList().size()) {
            double currentperc = data.getPercentList().get(i);
            AnalysisLogger.getLogger().debug((Object)("Eigenvalue: Number: " + i + " Percentage: " + currentperc));
            if (currentperc > (double)eigenValuesPercentageThreshold) {
                groups.add(new SSAUnselectList(i, currentperc));
            }
            ++i;
        }
        groupsModel.add(new SSAGroupList(groups));
        SingularSpectrumAnalysis.grouping(groupsModel, data);
        SingularSpectrumAnalysis.diagonalAveraging(data);
        double[] signal = new double[data.getTimeSeries().size()];
        int i2 = 0;
        while (i2 < data.getTimeSeries().size()) {
            signal[i2] = data.getTimeSeries().get(i2);
            ++i2;
        }
        SingularSpectrumAnalysis.forecast(data, nPointsToForecast, reportReconstructedSignal);
        double[] rsignal = new double[data.getForecastList().size()];
        int i3 = 0;
        while (i3 < data.getForecastList().size()) {
            rsignal[i3] = data.getForecastList().get(i3);
            ++i3;
        }
        data.setReconstructedSignal(rsignal);
        data.setForecastSignal(rsignal);
        AnalysisLogger.getLogger().debug((Object)"SSA workflow DONE");
        return data;
    }
}

