/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.spatialdistributions;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.ServiceType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.ServiceParameters;
import org.gcube.dataanalysis.ecoengine.models.cores.neuralnetworks.neurosolutions.NeuralNet;
import org.gcube.dataanalysis.ecoengine.spatialdistributions.AquamapsNative;
import org.hibernate.SessionFactory;

public class AquamapsNNNS
extends AquamapsNative {
    private NeuralNet neuralnet;

    @Override
    public String getName() {
        return "AQUAMAPS_NEURAL_NETWORK_NS";
    }

    @Override
    public String getDescription() {
        return "Aquamaps Algorithm calculated by neural network";
    }

    @Override
    public List<StatisticalType> getInputParameters() {
        List<StatisticalType> parameters = super.getInputParameters();
        PrimitiveType p1 = new PrimitiveType(String.class.getName(), null, PrimitiveTypes.STRING, "SpeciesName", "Name of the Species for which the distribution has to be produced", "Fis-30189");
        ServiceType p2 = new ServiceType(ServiceParameters.USERNAME, "UserName", "LDAP username");
        parameters.add(p1);
        parameters.add(p2);
        return parameters;
    }

    @Override
    public void init(AlgorithmConfiguration config, SessionFactory dbHibConnection) {
        super.init(config, dbHibConnection);
        String persistencePath = config.getPersistencePath();
        String filename = String.valueOf(persistencePath) + "neuralnetwork_" + config.getParam("SpeciesName") + "_" + config.getParam("UserName");
        this.neuralnet = AquamapsNNNS.loadNN(filename);
    }

    @Override
    public float calcProb(Object mainInfo, Object area) {
        String species = this.getMainInfoID(mainInfo);
        String csquarecode = (String)((Object[])area)[0];
        Object[] wholevector = (Object[])area;
        Object[] inputvector = new Object[wholevector.length - 6];
        int i = 0;
        while (i < inputvector.length) {
            inputvector[i] = wholevector[i + 1];
            ++i;
        }
        float probability = 0.0f;
        probability = this.propagate(inputvector);
        return probability;
    }

    private synchronized float propagate(Object[] inputvector) {
        double[] output = new double[1];
        try {
            output = this.neuralnet.Output(NeuralNet.preprocessObjects(inputvector));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        float probability = ((float)output[0] + 1.0f) / 2.0f;
        if ((double)probability > 0.1) {
            AnalysisLogger.getLogger().debug((Object)(" Probability " + probability));
        }
        return probability;
    }

    @Override
    public float getInternalStatus() {
        return 100.0f;
    }

    public static synchronized NeuralNet loadNN(String nomeFile) {
        NeuralNet nn = null;
        FileInputStream stream = null;
        try {
            try {
                stream = new FileInputStream(nomeFile);
                ObjectInputStream ois = new ObjectInputStream(stream);
                nn = (NeuralNet)ois.readObject();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                AnalysisLogger.getLogger().debug((Object)("Error in reading the object from file " + nomeFile + " ."));
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        return nn;
    }
}

