/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.LexicalEngineConfiguration;
import org.gcube.contentmanagement.lexicalmatcher.utils.FileTools;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.DatabaseParameters;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;

public class DatabaseFactory {
    public static SessionFactory initDBConnection(String configurationFile) throws Exception {
        String xml = FileTools.readXMLDoc(configurationFile);
        SessionFactory DBSessionFactory = null;
        Configuration cfg = new Configuration();
        cfg = cfg.configure(DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(xml.getBytes())));
        DBSessionFactory = cfg.buildSessionFactory();
        return DBSessionFactory;
    }

    public static List<StatisticalType> getDefaultDatabaseConfiguration(String configurationFile) throws Exception {
        ArrayList<StatisticalType> defaultconfig = new ArrayList<StatisticalType>();
        File fl = new File(configurationFile);
        FileInputStream stream = new FileInputStream(fl);
        SAXReader saxReader = new SAXReader();
        Document document = saxReader.read((InputStream)stream);
        List nodes = document.selectNodes("//hibernate-configuration/session-factory/property");
        for (Node currentnode : nodes) {
            String element = currentnode.valueOf("@name");
            if (element.equals("connection.driver_class")) {
                defaultconfig.add(new DatabaseType(DatabaseParameters.DATABASEDRIVER, "DatabaseDriver", "db driver", currentnode.getText()));
            }
            if (element.equals("connection.url")) {
                defaultconfig.add(new DatabaseType(DatabaseParameters.DATABASEURL, "DatabaseURL", "db url", currentnode.getText()));
            }
            if (element.equals("connection.username")) {
                defaultconfig.add(new DatabaseType(DatabaseParameters.DATABASEUSERNAME, "DatabaseUserName", "db user name", currentnode.getText()));
            }
            if (element.equals("connection.password")) {
                defaultconfig.add(new DatabaseType(DatabaseParameters.DATABASEPASSWORD, "DatabasePassword", "db password", currentnode.getText()));
            }
            if (!element.equals("dialect")) continue;
            defaultconfig.add(new DatabaseType(DatabaseParameters.DATABASEDIALECT, "DatabaseDialect", "db dialect", currentnode.getText()));
        }
        return defaultconfig;
    }

    public static SessionFactory initDBConnection(String configurationFile, LexicalEngineConfiguration config) throws Exception {
        if (config == null) {
            return DatabaseFactory.initDBConnection(configurationFile);
        }
        File fl = new File(configurationFile);
        FileInputStream stream = new FileInputStream(fl);
        SAXReader saxReader = new SAXReader();
        Document document = saxReader.read((InputStream)stream);
        List nodes = document.selectNodes("//hibernate-configuration/session-factory/property");
        for (Node currentnode : nodes) {
            String element = currentnode.valueOf("@name");
            if (element.equals("connection.driver_class")) {
                if (config.getDatabaseDriver() != null && config.getDatabaseDriver().length() > 0) {
                    currentnode.setText(config.getDatabaseDriver());
                } else {
                    config.setDatabaseDriver(currentnode.getText());
                }
            }
            if (element.equals("connection.url")) {
                if (config.getDatabaseURL() != null && config.getDatabaseURL().length() > 0) {
                    currentnode.setText(config.getDatabaseURL());
                } else {
                    config.setDatabaseURL(currentnode.getText());
                }
            }
            if (element.equals("connection.username")) {
                if (config.getDatabaseUserName() != null && config.getDatabaseUserName().length() > 0) {
                    currentnode.setText(config.getDatabaseUserName());
                } else {
                    config.setDatabaseUserName(currentnode.getText());
                }
            }
            if (element.equals("connection.password")) {
                if (config.getDatabasePassword() != null && config.getDatabasePassword().length() > 0) {
                    currentnode.setText(config.getDatabasePassword());
                } else {
                    config.setDatabasePassword(currentnode.getText());
                }
            }
            if (element.equals("dialect")) {
                if (config.getDatabaseDialect() != null && config.getDatabaseDialect().length() > 0) {
                    currentnode.setText(config.getDatabaseDialect());
                } else {
                    config.setDatabaseDialect(currentnode.getText());
                }
            }
            if (element.equals("c3p0.idleConnectionTestPeriod")) {
                if (config.getDatabaseIdleConnectionTestPeriod() != null) {
                    currentnode.setText(config.getDatabaseIdleConnectionTestPeriod());
                } else {
                    config.setDatabaseIdleConnectionTestPeriod(currentnode.getText());
                }
            }
            if (!element.equals("c3p0.automaticTestTable")) continue;
            if (config.getDatabaseAutomaticTestTable() != null) {
                currentnode.setText(config.getDatabaseAutomaticTestTable());
                continue;
            }
            config.setDatabaseAutomaticTestTable(currentnode.getText());
        }
        Configuration cfg = new Configuration();
        cfg = cfg.configure(DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(document.asXML().getBytes())));
        cfg.setProperty("hibernate.hbm2ddl.auto", "create");
        SessionFactory DBSessionFactory = null;
        DBSessionFactory = cfg.buildSessionFactory();
        stream.close();
        return DBSessionFactory;
    }

    public static List<Object> executeHQLQuery(String query, SessionFactory DBSessionFactory, boolean useSQL) {
        List obj = null;
        Session ss = null;
        ss = DBSessionFactory.getCurrentSession();
        ss.beginTransaction();
        Object qr = null;
        qr = useSQL ? ss.createSQLQuery(query) : ss.createQuery(query);
        List result = null;
        try {
            result = qr.list();
            ss.getTransaction().commit();
        }
        catch (Exception e) {
            System.out.println("Could not execute query " + e.getMessage());
            e.printStackTrace();
            DatabaseFactory.rollback((org.hibernate.Session)ss);
        }
        if (result == null) {
            System.out.println("Hibernate doesn't return a valid object when org.gcube.contentmanagement.lexicalmatcher retrieve UserState Object");
        }
        if (result != null && result.size() != 0) {
            obj = result;
        }
        return obj;
    }

    public static Connection getDBConnection(String drivername, String username, String password, String databaseurl) throws Exception {
        Class.forName(drivername);
        Connection conn = DriverManager.getConnection(databaseurl, username, password);
        return conn;
    }

    public static void executeUpdateNoTransaction(String query, String drivername, String username, String password, String databaseurl, boolean useSQL) throws Exception {
        Class.forName(drivername);
        Connection conn = DriverManager.getConnection(databaseurl, username, password);
        Statement stmt = conn.createStatement();
        stmt.executeUpdate(query);
        stmt.close();
        conn.close();
    }

    public static void executeUpdateNoTransaction(String query, SessionFactory DBSessionFactory, boolean useSQL) throws Exception {
        Object ss = null;
    }

    public static void executeHQLUpdate(String query, SessionFactory DBSessionFactory, boolean useSQL) throws Exception {
        Session ss = null;
        try {
            ss = DBSessionFactory.getCurrentSession();
            ss.beginTransaction();
            Object qr = null;
            qr = useSQL ? ss.createSQLQuery(query) : ss.createQuery(query);
            qr.executeUpdate();
            ss.getTransaction().commit();
        }
        catch (Exception e) {
            DatabaseFactory.rollback((org.hibernate.Session)ss);
            throw e;
        }
    }

    public static void executeNativeUpdate(String query, SessionFactory DBSessionFactory) {
        Session ss = null;
        try {
            ss = DBSessionFactory.getCurrentSession();
            System.out.println("executing query");
            ss.beginTransaction();
            Query qr = null;
            qr = DBSessionFactory.getCurrentSession().getNamedQuery("mySp").setParameter("param", (Object)query);
            qr.executeUpdate();
            ss.getTransaction().commit();
        }
        catch (Exception e) {
            DatabaseFactory.rollback((org.hibernate.Session)ss);
            e.printStackTrace();
        }
    }

    public static void executeSQLUpdate(String query, SessionFactory DBSessionFactory) throws Exception {
        DatabaseFactory.executeHQLUpdate(query, DBSessionFactory, true);
    }

    public static List<Object> executeSQLQuery(String query, SessionFactory DBSessionFactory) {
        return DatabaseFactory.executeHQLQuery(query, DBSessionFactory, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rollback(org.hibernate.Session ss) {
        try {
            if (ss != null && ss.getTransaction() != null) {
                ss.getTransaction().rollback();
            }
        }
        catch (Exception ex) {
        }
        finally {
            try {
                ss.close();
            }
            catch (Exception ee) {}
        }
    }

    public static void saveObject(Object obj, SessionFactory DBSessionFactory) throws Exception {
        if (DBSessionFactory != null) {
            Session ss = null;
            try {
                ss = DBSessionFactory.getCurrentSession();
                ss.beginTransaction();
                ss.saveOrUpdate(obj);
                ss.getTransaction().commit();
            }
            catch (Exception e) {
                DatabaseFactory.rollback((org.hibernate.Session)ss);
                throw e;
            }
        }
    }
}

