/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.processing.factories;

import java.util.ArrayList;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.interfaces.ComputationalAgent;
import org.gcube.dataanalysis.ecoengine.interfaces.Transducerer;
import org.gcube.dataanalysis.ecoengine.processing.factories.DynamicTransducerersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.GeneratorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.ProcessorsFactory;

public class TransducerersFactory {
    public static Transducerer getTransducerer(AlgorithmConfiguration config) throws Exception {
        ComputationalAgent ca = ProcessorsFactory.getProcessor(config, config.getConfigPath() + AlgorithmConfiguration.transducererFile);
        if (ca != null) {
            ca.setConfiguration(config);
            return (Transducerer)ca;
        }
        return DynamicTransducerersFactory.getTransducerer(config);
    }

    public static List<String> getAllTransducerers(AlgorithmConfiguration config) throws Exception {
        List<String> trans = ProcessorsFactory.getClasses(config.getConfigPath() + AlgorithmConfiguration.transducererFile);
        List<String> dtrans = DynamicTransducerersFactory.getTransducerersNames(config);
        trans.addAll(dtrans);
        return trans;
    }

    public static List<StatisticalType> getTransducerParameters(AlgorithmConfiguration config, String algorithmName) throws Exception {
        List<StatisticalType> inputs = ProcessorsFactory.getParameters(config.getConfigPath() + AlgorithmConfiguration.transducererFile, algorithmName);
        if (inputs != null) {
            return inputs;
        }
        config.setAgent(algorithmName);
        inputs = DynamicTransducerersFactory.getTransducerer(config).getInputParameters();
        AnalysisLogger.getLogger().debug((Object)("Dynamic INPUTS:" + inputs));
        return inputs;
    }

    public static StatisticalType getTransducerOutput(AlgorithmConfiguration config, String algorithmName) throws Exception {
        StatisticalType output = ProcessorsFactory.getOutputDescriptions(config.getConfigPath() + AlgorithmConfiguration.transducererFile, algorithmName);
        if (output != null) {
            return output;
        }
        config.setAgent(algorithmName);
        output = DynamicTransducerersFactory.getTransducerer(config).getOutput();
        AnalysisLogger.getLogger().debug((Object)("Dynamic Output:" + output));
        return output;
    }

    public static StatisticalType getModelOutput(String configPath, String algorithmName) throws Exception {
        StatisticalType output = ProcessorsFactory.getOutputDescriptions(configPath + AlgorithmConfiguration.modelsFile, algorithmName);
        return output;
    }

    public static String getDescription(AlgorithmConfiguration config, String algorithmName) throws Exception {
        String input = ProcessorsFactory.getDescription(config.getConfigPath() + AlgorithmConfiguration.transducererFile, algorithmName);
        if (input != null) {
            return input;
        }
        config.setAgent(algorithmName);
        input = DynamicTransducerersFactory.getTransducerer(config).getDescription();
        AnalysisLogger.getLogger().debug((Object)("Dynamic DESCRIPTION:" + input));
        return input;
    }

    public static List<ComputationalAgent> getTransducerers(AlgorithmConfiguration config) throws Exception {
        ArrayList<ComputationalAgent> trans = new ArrayList<ComputationalAgent>();
        trans.add(TransducerersFactory.getTransducerer(config));
        ProcessorsFactory.addAgent2List(trans, GeneratorsFactory.getGenerator(config));
        Transducerer dynamicTransducer = DynamicTransducerersFactory.getTransducerer(config);
        if (dynamicTransducer != null) {
            trans.add(dynamicTransducer);
        }
        return trans;
    }
}

