/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.spatialdistributions;

import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.models.cores.neuralnetworks.Neural_Network;
import org.gcube.dataanalysis.ecoengine.spatialdistributions.BayesianDistribution;

public class FeedForwardNeuralNetworkDistribution
extends BayesianDistribution {
    private Neural_Network neuralnet;

    @Override
    public float calcProb(Object mainInfo, Object area) {
        Object[] vector = (Object[])area;
        double[] features = new double[this.neuralnet.getNumberOfInputs() - 1];
        for (int i = 0; i < vector.length; ++i) {
            if (vector[i] == null) {
                vector[i] = 0;
            }
            if (i >= features.length) continue;
            features[i] = Double.parseDouble("" + vector[i]);
        }
        return (float)this.neuralnet.getCorrectValueFromOutput(this.neuralnet.propagate(features)[0]);
    }

    @Override
    public void singleStepPreprocess(Object mainInfo, Object area) {
        String persistencePath = this.config.getPersistencePath();
        String filename = this.modelFile.getAbsolutePath();
        this.neuralnet = Neural_Network.loadNN(filename);
        AnalysisLogger.getLogger().debug((Object)("Using neural network with emission range: (" + this.neuralnet.minfactor + " ; " + this.neuralnet.maxfactor + ""));
    }

    @Override
    public void singleStepPostprocess(Object mainInfo, Object allAreasInformation) {
    }

    @Override
    public String getName() {
        return "FEED_FORWARD_A_N_N_DISTRIBUTION";
    }

    @Override
    public String getDescription() {
        return "A Bayesian method using a Feed Forward Neural Network to simulate a function from the features space (R^n) to R. A modeling algorithm that relies on Neural Networks to simulate a real valued function. It accepts as input a table containing the training dataset and some parameters affecting the algorithm behaviour such as the number of neurons, the learning threshold and the maximum number of iterations.";
    }
}

