/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.interfaces;

import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.interfaces.GenericAlgorithm;

public abstract class SpatialProbabilityDistributionNode
implements GenericAlgorithm {
    public abstract void initSingleNode(AlgorithmConfiguration var1);

    public abstract float getInternalStatus();

    public abstract int executeNode(int var1, int var2, int var3, int var4, boolean var5, String var6, String var7, String var8);

    public abstract void setup(AlgorithmConfiguration var1) throws Exception;

    public abstract int getNumberOfSpecies();

    public abstract int getNumberOfGeoInfo();

    public abstract int getNumberOfProcessedSpecies();

    public abstract void stop();

    public abstract void postProcess(boolean var1, boolean var2);

    public static void main(String[] args) throws Exception {
        try {
            System.out.println("Generic Node: Process Started ");
            try {
                for (int i = 0; i < args.length; ++i) {
                    System.out.println("Generic Node: RECEIVED INPUT " + args[i]);
                }
            }
            catch (Exception i) {
                // empty catch block
            }
            System.out.println("Generic Node: checking arguments from " + args[0]);
            String[] rargs = args[0].split("_");
            int order = Integer.parseInt(rargs[0]);
            System.out.println("Generic Node: order: " + order);
            int chunksize = Integer.parseInt(rargs[1]);
            System.out.println("Generic Node: chunk: " + chunksize);
            int speciesOrder = Integer.parseInt(rargs[2]);
            System.out.println("Generic Node: species: " + speciesOrder);
            int speciesChunksize = Integer.parseInt(rargs[3]);
            System.out.println("Generic Node: species chunk size: " + speciesChunksize);
            String path = rargs[4];
            System.out.println("Generic Node: path: " + path);
            String algorithmClass = rargs[5];
            System.out.println("Generic Node: algorithmClass: " + algorithmClass);
            Boolean duplicate = Boolean.parseBoolean(rargs[6]);
            System.out.println("Generic Node: duplicate message: " + duplicate);
            String nodeConfiguration = rargs[7];
            System.out.println("Generic Node: config: " + nodeConfiguration);
            String logfile = args[1];
            System.out.println("Generic Node: logfile: " + logfile);
            System.out.println("Generic Node: executing class");
            SpatialProbabilityDistributionNode node = (SpatialProbabilityDistributionNode)Class.forName(algorithmClass).newInstance();
            node.executeNode(order, chunksize, speciesOrder, speciesChunksize, duplicate, path, nodeConfiguration, logfile);
        }
        catch (Exception e) {
            System.out.println("ERROR " + e.getMessage());
            System.out.println(e);
        }
    }
}

