/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.spatialdistributions;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.ALG_PROPS;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnTypesList;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.OutputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.ServiceType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.ServiceParameters;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.interfaces.SpatialProbabilityDistributionGeneric;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.hibernate.SessionFactory;

public abstract class BayesianDistribution
implements SpatialProbabilityDistributionGeneric {
    protected static String FeaturesTableP = "FeaturesTable";
    protected static String FeaturesTableColumnsP = "FeaturesColumnNames";
    protected static String FinalTableLabel = "FinalTableLabel";
    protected static String FinalTableName = "FinalTableName";
    protected static String FinalTableValue = "tvalue";
    protected static String FinalTableValueType = "real";
    protected static String GroupingFactor = "GroupingFactor";
    protected static String ModelName = "ModelName";
    protected static String UserName = "UserName";
    protected float status = 10.0f;
    protected String featuresTable;
    protected String featuresTableColumns;
    protected String finalTableName;
    protected String finalTableLabel;
    protected String modelName;
    protected File modelFile;
    protected String userName;
    protected String groupingFactor;
    protected SessionFactory dbConnection;
    protected AlgorithmConfiguration config;

    @Override
    public String getMainInfoType() {
        return String.class.getName();
    }

    @Override
    public String getGeographicalInfoType() {
        return Object[].class.getName();
    }

    @Override
    public List<Object> getMainInfoObjects() {
        if (this.groupingFactor.length() == 0) {
            ArrayList<Object> lo = new ArrayList<Object>();
            lo.add("1");
            return lo;
        }
        return DatabaseFactory.executeSQLQuery("select distinct " + this.groupingFactor + " from " + this.featuresTableColumns, this.dbConnection);
    }

    @Override
    public List<Object> getGeographicalInfoObjects() {
        return DatabaseFactory.executeSQLQuery("select distinct " + this.featuresTableColumns + " from " + this.featuresTable, this.dbConnection);
    }

    @Override
    public void storeDistribution(Map<Object, Map<Object, Float>> distribution) throws Exception {
        StringBuffer sb = new StringBuffer();
        int distribscounter = 0;
        int distrsize = distribution.size();
        for (Object key : distribution.keySet()) {
            Map<Object, Float> innerdistrib = distribution.get(key);
            int counter = 0;
            int innerdistrsize = innerdistrib.size();
            for (Object vector : innerdistrib.keySet()) {
                float value = innerdistrib.get(vector).floatValue();
                Object[] elements = (Object[])vector;
                if (this.groupingFactor.length() > 0) {
                    sb.append("(" + key + ",");
                } else {
                    sb.append("(");
                }
                for (Object elem : elements) {
                    sb.append(elem + ",");
                }
                sb.append(value + ")");
                if (counter < innerdistrsize - 1) {
                    sb.append(",");
                }
                ++counter;
            }
            if (distribscounter >= distrsize - 1) continue;
            sb.append(",");
        }
        int len = sb.length() - 1;
        String insertBuffer = DatabaseUtils.insertFromBuffer(this.finalTableName, this.featuresTableColumns + "," + FinalTableValue, sb);
        if (this.groupingFactor.trim().length() > 0) {
            insertBuffer = DatabaseUtils.insertFromBuffer(this.finalTableName, this.groupingFactor + "," + this.featuresTableColumns + "," + FinalTableValue, sb);
        }
        AnalysisLogger.getLogger().debug((Object)"Writing Distribution into the DB ");
        DatabaseFactory.executeSQLUpdate(insertBuffer, this.dbConnection);
        AnalysisLogger.getLogger().debug((Object)"Done!");
    }

    @Override
    public float getInternalStatus() {
        return this.status;
    }

    @Override
    public String getMainInfoID(Object mainInfo) {
        if (this.groupingFactor.length() == 0) {
            return "1";
        }
        return "" + ((Object[])mainInfo)[0];
    }

    @Override
    public String getGeographicalID(Object geoInfo) {
        return "";
    }

    @Override
    public ALG_PROPS[] getProperties() {
        ALG_PROPS[] p = new ALG_PROPS[]{ALG_PROPS.PHENOMENON_VS_GEOINFO};
        return p;
    }

    @Override
    public void postProcess() {
        this.status = 100.0f;
        if (this.dbConnection != null) {
            this.dbConnection.close();
        }
    }

    @Override
    public List<StatisticalType> getInputParameters() {
        ArrayList<StatisticalType> parameters = new ArrayList<StatisticalType>();
        ArrayList<TableTemplates> templateOccs = new ArrayList<TableTemplates>();
        templateOccs.add(TableTemplates.GENERIC);
        InputTable p1 = new InputTable(templateOccs, FeaturesTableP, "a Table containing features vectors", "occurrences");
        ColumnTypesList p2 = new ColumnTypesList(FeaturesTableP, FeaturesTableColumnsP, "column names of the features", false);
        PrimitiveType p3 = new PrimitiveType(String.class.getName(), null, PrimitiveTypes.STRING, FinalTableLabel, "table name of the resulting distribution", "Distrib_");
        ServiceType p4 = new ServiceType(ServiceParameters.RANDOMSTRING, FinalTableName, "table name of the distribution", "distrib_");
        PrimitiveType p5 = new PrimitiveType(String.class.getName(), null, PrimitiveTypes.STRING, GroupingFactor, "identifier for grouping sets of vectors (blank for automatic enum)", "speciesid");
        PrimitiveType p6 = new PrimitiveType(File.class.getName(), null, PrimitiveTypes.FILE, ModelName, "neuralnet_");
        ServiceType p7 = new ServiceType(ServiceParameters.USERNAME, UserName, "LDAP username");
        parameters.add(p1);
        parameters.add(p2);
        parameters.add(p3);
        parameters.add(p4);
        parameters.add(p5);
        parameters.add(p6);
        parameters.add(p7);
        DatabaseType.addDefaultDBPars(parameters);
        return parameters;
    }

    @Override
    public StatisticalType getOutput() {
        ArrayList<TableTemplates> template = new ArrayList<TableTemplates>();
        template.add(TableTemplates.TESTSET);
        return new OutputTable(template, this.finalTableLabel, this.finalTableName, "Output table");
    }

    @Override
    public void init(AlgorithmConfiguration config) throws Exception {
        this.status = 0.0f;
        AnalysisLogger.getLogger().debug((Object)"Initializing Database Connection");
        this.config = config;
        this.finalTableLabel = config.getParam(FinalTableLabel);
        this.finalTableName = config.getParam(FinalTableName);
        this.featuresTable = config.getParam(FeaturesTableP);
        this.featuresTableColumns = config.getParam(FeaturesTableColumnsP);
        this.groupingFactor = config.getParam(GroupingFactor);
        if (this.groupingFactor == null) {
            this.groupingFactor = "";
        }
        this.modelFile = new File(config.getParam(ModelName));
        this.modelName = this.modelFile.getName();
        this.userName = config.getParam(UserName);
        this.dbConnection = DatabaseUtils.initDBSession(config);
        try {
            AnalysisLogger.getLogger().debug((Object)("Dropping table " + this.finalTableName));
            String dropStatement = DatabaseUtils.dropTableStatement(this.finalTableName);
            DatabaseFactory.executeSQLUpdate(dropStatement, this.dbConnection);
            AnalysisLogger.getLogger().debug((Object)("Table " + this.finalTableName + " dropped"));
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)("Could not drop table " + this.finalTableName));
        }
        String[] features = this.featuresTableColumns.split(AlgorithmConfiguration.getListSeparator());
        String columns = "";
        this.featuresTableColumns = "";
        for (int i = 0; i < features.length; ++i) {
            columns = columns + features[i] + " real";
            this.featuresTableColumns = this.featuresTableColumns + features[i];
            if (i >= features.length - 1) continue;
            columns = columns + ",";
            this.featuresTableColumns = this.featuresTableColumns + ",";
        }
        String createStatement = "create table " + this.finalTableName + " ( " + columns + ", " + FinalTableValue + " " + FinalTableValueType + ")";
        if (this.groupingFactor.length() > 0) {
            createStatement = "create table " + this.finalTableName + " ( " + this.groupingFactor + " character varying " + columns + ", " + FinalTableValue + " " + FinalTableValueType + ")";
        }
        AnalysisLogger.getLogger().debug((Object)("Creating table: " + this.finalTableName + " by statement: " + createStatement));
        DatabaseFactory.executeSQLUpdate(createStatement, this.dbConnection);
        AnalysisLogger.getLogger().debug((Object)("Table: " + this.finalTableName + " created"));
        this.status = 10.0f;
    }
}

