package org.gcube.dataanalysis.environment.explorer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class JsonMapper {

	
	public static HashMap<String, Object> parse(String json) {

		Object genericobject = new com.google.gson.JsonParser().parse(json);
		com.google.gson.JsonObject object = null;
		HashMap<String, Object> map = new HashMap<String, Object>();
		
		if (genericobject instanceof com.google.gson.JsonObject){
			object = (JsonObject) genericobject;
			parseMap(map,object);
		}
		else if (genericobject instanceof com.google.gson.JsonArray){
			JsonArray ArrObject = (JsonArray) new com.google.gson.JsonParser().parse(json);
			Iterator<JsonElement> iterator = ArrObject.iterator();
			while (iterator.hasNext()) {
				JsonElement element = iterator.next();
				if (element instanceof JsonObject){
					if (!element.isJsonPrimitive()) {
						parseMap(map, (JsonObject) element);
					}
				}
			}
		}
		
		return map;
	}
	
	private static void parseMap(HashMap<String, Object> map, JsonObject object ){
	
		Set<Map.Entry<String, JsonElement>> set = object.entrySet();
		Iterator<Map.Entry<String, JsonElement>> iterator = set.iterator();
		
		while (iterator.hasNext()) {
			Map.Entry<String, JsonElement> entry = iterator.next();
			String key = entry.getKey();
			JsonElement value = entry.getValue();
			if (!value.isJsonPrimitive()) {
				map.put(key, parse(value.toString()));
			} else {
				map.put(key, value.getAsString());
			}
		}
	
	}
	
}
