package org.gcube.dataanalysis.environment.test;

import org.gcube.dataanalysis.environment.thredds.ThreddsMetadataInserter;
import org.gcube.dataanalysis.environment.utils.ELog;
import org.gcube.dataanalysis.environment.utils.MetadataInsertionGeonetwork;

public class TestMetadataInsertion {

	public static void main(String[] args) throws Exception{
		String threddsCatalogUrl = "http://thredds.research-infrastructures.eu:8080/thredds/catalog/public/netcdf/catalog.xml";
		String geonetworkUrl = "http://geoserver-dev.d4science-ii.research-infrastructures.eu/geonetwork";
		String geonetworkUsername = "admin";
		String geonetworkPassword = "admin";
		String geoserverUsername= "admin";
		String geoserverPassword="gcube@geo2010";
		long t0 = System.currentTimeMillis();
		ThreddsMetadataInserter.updateGeonetwork(threddsCatalogUrl, geonetworkUrl, geonetworkUsername, geonetworkPassword,geoserverUsername,geoserverPassword);
		ELog.debug("ThreddsDataExplorer-> Elapsed: "+(System.currentTimeMillis()-t0));
		
		//Custom Update:
		ELog.debug("ThreddsDataExplorer-> "+MetadataInsertionGeonetwork.addThreddsMetadata(geonetworkUrl, geonetworkUsername, geonetworkPassword, geoserverUsername,geoserverPassword,"Bathymetry", "bathymetry", "z: Bathymetry file collected at GEBCO gebco08.nc", "http://thredds.research-infrastructures.eu:8080/thredds/dodsC/public/netcdf/gebco_08.nc",-180,+180,-90,+90));
	}
	
}
