/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.environment.explorer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.gcube.common.geoserverinterface.GeoCaller;
import org.gcube.common.geoserverinterface.GeonetworkCaller;
import org.gcube.common.geoserverinterface.GeonetworkCommonResourceInterface;
import org.gcube.common.geoserverinterface.bean.CswLayersResult;
import org.gcube.common.geoserverinterface.bean.LayerCsw;
import org.gcube.common.geoserverinterface.bean.MetadataInfo;
import org.gcube.dataanalysis.environment.explorer.JsonMapper;
import org.gcube.dataanalysis.environment.explorer.PointToWFS;
import org.gcube.dataanalysis.environment.thredds.ThreddsDataExplorer;
import org.gcube.dataanalysis.environment.thredds.ThreddsMetadataInserter;
import org.gcube.dataanalysis.environment.utils.ELog;
import org.gcube.dataanalysis.environment.utils.HttpRequest;
import org.gcube.dataanalysis.environment.utils.SupportedStorages;

public class EnvDataExplorer {
    private static String defaultGeoNetworkURL = "http://geoserver.d4science-ii.research-infrastructures.eu/geonetwork";
    private static String defaultGeoNetworkUser = "admin";
    private static String defaultGeoNetworkPassword = "admin";
    private static String defaultGeoServerUser = "admin";
    private static String defaultGeoServerPassword = "gcube@geo2010";

    public static void setLogger(Logger logger) {
        ELog.setLogger(logger);
    }

    private static String callWFS(String geoServer, String workspace, String layer, float x, float y) {
        float tolerance = 0.25f;
        String toSearch = String.valueOf(workspace) + ":" + layer;
        if (layer.contains(":")) {
            toSearch = layer;
        }
        String wfsURL = PointToWFS.getWfsFeatureUrl(geoServer, toSearch, PointToWFS.pointToBoundingBox(x, y, tolerance), 1, "json");
        ELog.debug("EnvDataExplorer-> Requesting URL: " + wfsURL);
        String returned = null;
        try {
            returned = HttpRequest.sendGetRequest(wfsURL, null);
        }
        catch (Exception e) {
            ELog.debug("EnvDataExplorer-> ERROR " + e.getLocalizedMessage());
        }
        if (returned != null) {
            ELog.debug("EnvDataExplorer-> Found Intersection: " + returned);
        } else {
            ELog.debug("EnvDataExplorer-> Found Nothing!");
        }
        return returned;
    }

    public static String getGeoServer(String workspace, String layer) {
        return EnvDataExplorer.getGeoServer(defaultGeoNetworkURL, defaultGeoNetworkUser, defaultGeoNetworkPassword, workspace, layer);
    }

    public static String getGeoServer(String geoNetworkUrl, String geoNetworkUsername, String geoNetworkPassword, String workspace, String layer) {
        GeoCaller geoCaller = null;
        String geoserverFound = null;
        try {
            geoCaller = new GeoCaller(geoNetworkUrl, geoNetworkUsername, geoNetworkPassword, null, null, null, GeonetworkCommonResourceInterface.GeoserverMethodResearch.MOSTUNLOAD);
            CswLayersResult cswlr = geoCaller.getLayersFromCsw(workspace, 1, 1, true, true, GeoCaller.FILTER_TYPE.ANY_TEXT, layer);
            geoserverFound = ((LayerCsw)cswlr.getLayers().get(0)).getGeoserverUrl();
            int index = geoserverFound.indexOf("?");
            if (index != -1) {
                geoserverFound = geoserverFound.substring(0, geoserverFound.indexOf("?"));
            }
            geoserverFound = geoserverFound.replaceFirst("(/wms)$", "").replaceFirst("(/wfs)$", "");
        }
        catch (Exception e) {
            ELog.debug("EnvDataExplorer-> Error in getting geoserver");
        }
        if (geoserverFound == null) {
            ELog.debug("EnvDataExplorer-> Found No Geoserver with layer " + layer);
        } else {
            ELog.debug("EnvDataExplorer-> Found a Geoserver with layer " + layer + " at " + geoserverFound);
        }
        return geoserverFound;
    }

    public static LayerCsw getGeoServerCSW(String geoNetworkUrl, String geoNetworkUsername, String geoNetworkPassword, String geoServerUser, String geoServerPassword, String workspace, String layer) {
        GeoCaller geoCaller = null;
        String geoserverFound = null;
        LayerCsw laycsw = new LayerCsw(null, null, null, null);
        try {
            int index;
            geoCaller = new GeoCaller(geoNetworkUrl, geoNetworkUsername, geoNetworkPassword, null, geoServerUser, geoServerPassword, GeonetworkCommonResourceInterface.GeoserverMethodResearch.MOSTUNLOAD);
            CswLayersResult cswlr = geoCaller.getLayersFromCsw(workspace, 1, 10, true, true, GeoCaller.FILTER_TYPE.ANY_TEXT, layer);
            List layerslist = cswlr.getLayers();
            boolean found = false;
            for (LayerCsw l : layerslist) {
                if (!l.getTitle().equalsIgnoreCase(layer)) continue;
                laycsw = l;
                geoserverFound = l.getGeoserverUrl();
                ELog.debug("EnvDataExplorer-> Layer Name correspondence found");
                found = true;
                break;
            }
            if (!found) {
                ELog.debug("EnvDataExplorer-> Layer Name corresponds not found - using csw");
                laycsw = (LayerCsw)layerslist.get(0);
                geoserverFound = laycsw.getGeoserverUrl();
            }
            if ((index = geoserverFound.indexOf("?")) != -1) {
                geoserverFound = geoserverFound.substring(0, geoserverFound.indexOf("?"));
            }
            geoserverFound = geoserverFound.replaceFirst("(/wms)$", "").replaceFirst("(/wfs)$", "");
            laycsw.setGeoserverUrl(geoserverFound);
        }
        catch (Exception e) {
            ELog.debug("EnvDataExplorer-> Error in getting geoserver");
        }
        if (geoserverFound == null) {
            ELog.debug("EnvDataExplorer-> Found No Geoserver with layer " + layer);
        } else {
            ELog.debug("EnvDataExplorer-> Found a Geoserver with layer " + layer + " at " + geoserverFound);
        }
        return laycsw;
    }

    private static HashMap<String, String> parseCSV(String csvString) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String[] splitRows = csvString.split("\n");
            String[] names = splitRows[0].split(",");
            String[] entries = splitRows[1].split(",");
            int len = entries.length;
            int i = 0;
            while (i < len) {
                map.put(names[i], entries[i]);
                ++i;
            }
        }
        catch (Exception e) {
            ELog.debug("EnvDataExplorer-> Error in parsing CSV info: " + e.getLocalizedMessage());
        }
        return map;
    }

    private static HashMap<String, String> info2Map(String geoserver, String workspace, String layer, float x, float y) {
        try {
            String jsonString = EnvDataExplorer.callWFS(geoserver, workspace, layer, x, y);
            HashMap<String, Object> map = JsonMapper.parse(jsonString);
            HashMap mapout = (HashMap)((HashMap)map.get("features")).get("properties");
            return mapout;
        }
        catch (Exception e) {
            ELog.debug("EnvDataExplorer-> Error in getting properties");
            return new HashMap<String, String>();
        }
    }

    private static List<String> Map2List(HashMap<String, String> map) {
        ArrayList<String> keys = new ArrayList<String>();
        if (map != null) {
            for (String key : map.keySet()) {
                keys.add(key);
            }
        }
        return keys;
    }

    public static HashMap<String, String> retrieveEnvInfoGeoServer(String geoserverUrl, String workspace, String layer, float x, float y) {
        if (geoserverUrl != null) {
            return EnvDataExplorer.info2Map(geoserverUrl, workspace, layer, x, y);
        }
        return new HashMap<String, String>();
    }

    public static HashMap<String, String> retrieveEnvInfoGeoNetwork(String geoNetworkUrl, String geoNetworkUsername, String geoNetworkPassword, String geoserverUsername, String geoserverPassword, String workspace, String layerTitle, float x, float y) {
        MetadataInfo info = EnvDataExplorer.retrieveStoredDatasetInfo(geoNetworkUrl, geoNetworkUsername, geoNetworkPassword, geoserverUsername, geoserverPassword, layerTitle);
        if (info == null || info.getDescription().equals(SupportedStorages.GEOSERVER.name())) {
            LayerCsw lay = EnvDataExplorer.getGeoServerCSW(geoNetworkUrl, geoNetworkUsername, geoNetworkPassword, geoserverUsername, geoserverPassword, workspace, layerTitle);
            String geoserverUrl = lay.getGeoserverUrl();
            String layerName = lay.getName();
            return EnvDataExplorer.retrieveEnvInfoGeoServer(geoserverUrl, workspace, layerName, x, y);
        }
        String threddsOpenDapUrl = info.getUrl();
        HashMap<String, String> map = new ThreddsDataExplorer().mapFeatures(layerTitle, threddsOpenDapUrl, x, y);
        return map;
    }

    public static String retrieveNetcdfWCSGeoNetwork(String workspace, String layerTitle) {
        return EnvDataExplorer.retrieveNetcdfWCSGeoNetwork(defaultGeoNetworkURL, defaultGeoNetworkUser, defaultGeoNetworkPassword, defaultGeoServerUser, defaultGeoServerPassword, workspace, layerTitle);
    }

    public static String retrieveNetcdfWCSGeoNetwork(String geoNetworkUrl, String geoNetworkUsername, String geoNetworkPassword, String geoserverUsername, String geoserverPassword, String workspace, String layerTitle) {
        MetadataInfo info = EnvDataExplorer.retrieveStoredDatasetInfo(geoNetworkUrl, geoNetworkUsername, geoNetworkPassword, geoserverUsername, geoserverPassword, layerTitle);
        if (info != null && !info.getDescription().equals(SupportedStorages.GEOSERVER.name())) {
            String threddsOpenDapUrl = info.getUrl();
            threddsOpenDapUrl = threddsOpenDapUrl.replace("/thredds/dodsC/", "/thredds/wcs/");
            return String.valueOf(threddsOpenDapUrl) + "?service=WCS&version=1.0.0";
        }
        return null;
    }

    public static String retrieveNetcdfWMSGeoNetwork(String workspace, String layerTitle) {
        return EnvDataExplorer.retrieveNetcdfWMSGeoNetwork(defaultGeoNetworkURL, defaultGeoNetworkUser, defaultGeoNetworkPassword, defaultGeoServerUser, defaultGeoServerPassword, workspace, layerTitle);
    }

    public static String retrieveNetcdfWMSGeoNetwork(String geoNetworkUrl, String geoNetworkUsername, String geoNetworkPassword, String geoserverUsername, String geoserverPassword, String workspace, String layerTitle) {
        MetadataInfo info = EnvDataExplorer.retrieveStoredDatasetInfo(geoNetworkUrl, geoNetworkUsername, geoNetworkPassword, geoserverUsername, geoserverPassword, layerTitle);
        if (info != null && !info.getDescription().equals(SupportedStorages.GEOSERVER.name())) {
            String threddsOpenDapUrl = info.getUrl();
            threddsOpenDapUrl = threddsOpenDapUrl.replace("/thredds/dodsC/", "/thredds/wms/");
            return String.valueOf(threddsOpenDapUrl) + "?service=WMS&version=1.3.0";
        }
        return null;
    }

    public static List<HashMap<String, String>> retrieveEnvInfoGeoNetwork(String workspace, String layer, float[][] xy) {
        return EnvDataExplorer.retrieveEnvInfoGeoNetwork(defaultGeoNetworkURL, defaultGeoNetworkUser, defaultGeoNetworkPassword, defaultGeoServerUser, defaultGeoServerPassword, workspace, layer, xy);
    }

    public static List<HashMap<String, String>> retrieveEnvInfoGeoNetwork(String geoNetworkUrl, String geoNetworkUsername, String geoNetworkPassword, String geoserverUsername, String geoserverPassword, String workspace, String layerTitle, float[][] xy) {
        MetadataInfo info = EnvDataExplorer.retrieveStoredDatasetInfo(geoNetworkUrl, geoNetworkUsername, geoNetworkPassword, geoserverUsername, geoserverPassword, layerTitle);
        if (info == null || info.getDescription().equals(SupportedStorages.GEOSERVER.name())) {
            LayerCsw lay = EnvDataExplorer.getGeoServerCSW(geoNetworkUrl, geoNetworkUsername, geoNetworkPassword, geoserverUsername, geoserverPassword, workspace, layerTitle);
            String geoserverUrl = lay.getGeoserverUrl();
            String layerName = lay.getName();
            return EnvDataExplorer.bulkProcessGeoServer(geoserverUrl, workspace, layerName, xy);
        }
        String threddsOpenDapUrl = info.getUrl();
        return new ThreddsDataExplorer().mapFeaturesForSet(layerTitle, threddsOpenDapUrl, xy);
    }

    public static List<HashMap<String, String>> bulkProcessGeoServer(String geoserverUrl, String workspace, String layer, float[][] xy) {
        ArrayList<HashMap<String, String>> hashList = new ArrayList<HashMap<String, String>>();
        int i = 0;
        while (i < xy.length) {
            float x = xy[i][0];
            float y = xy[i][1];
            hashList.add(EnvDataExplorer.retrieveEnvInfoGeoServer(geoserverUrl, workspace, layer, x, y));
            ++i;
        }
        return hashList;
    }

    public static HashMap<String, String> retrieveEnvInfoGeoNetwork(String workspace, String layer, float x, float y) {
        return EnvDataExplorer.retrieveEnvInfoGeoNetwork(defaultGeoNetworkURL, defaultGeoNetworkUser, defaultGeoNetworkPassword, defaultGeoServerUser, defaultGeoServerPassword, workspace, layer, x, y);
    }

    public static List<String> getLayerFeaturesGeoServer(String geoserverUrl, String workspace, String layer) {
        if (geoserverUrl != null) {
            return EnvDataExplorer.Map2List(EnvDataExplorer.info2Map(geoserverUrl, workspace, layer, 0.0f, 0.0f));
        }
        return new ArrayList<String>();
    }

    public static List<String> getLayerFeaturesGeoNetwork(String geoNetworkUrl, String geoNetworkUsername, String geoNetworkPassword, String geoserverUsername, String geoserverPassword, String workspace, String layer, float x, float y) {
        MetadataInfo info = EnvDataExplorer.retrieveStoredDatasetInfo(geoNetworkUrl, geoNetworkUsername, geoNetworkPassword, geoserverUsername, geoserverPassword, layer);
        if (info == null || info.getDescription().equals(SupportedStorages.GEOSERVER.name())) {
            LayerCsw lay = EnvDataExplorer.getGeoServerCSW(geoNetworkUrl, geoNetworkUsername, geoNetworkPassword, geoserverUsername, geoserverPassword, workspace, layer);
            String geoserverUrl = lay.getGeoserverUrl();
            String layerName = lay.getName();
            return EnvDataExplorer.getLayerFeaturesGeoServer(geoserverUrl, workspace, layerName);
        }
        String geoserverUrl = EnvDataExplorer.getGeoServer(geoNetworkUrl, geoNetworkUsername, geoNetworkPassword, workspace, layer);
        return EnvDataExplorer.getLayerFeaturesGeoServer(geoserverUrl, workspace, layer);
    }

    public static List<String> getLayerFeaturesGeoNetwork(String workspace, String layer) {
        LayerCsw lay = EnvDataExplorer.getGeoServerCSW(defaultGeoNetworkURL, defaultGeoNetworkUser, defaultGeoNetworkPassword, defaultGeoServerUser, defaultGeoServerPassword, workspace, layer);
        String geoserverUrl = lay.getGeoserverUrl();
        String layerName = lay.getName();
        return EnvDataExplorer.getLayerFeaturesGeoServer(geoserverUrl, workspace, layerName);
    }

    public static MetadataInfo retrieveStoredDatasetInfo(String geonetworkUrl, String geonetworkUsername, String geonetworkPassword, String geoserverUsername, String geoserverPassword, String layerTitle) {
        GeonetworkCaller geonetworkCaller = new GeonetworkCaller(geonetworkUrl, geonetworkUsername, geonetworkPassword, geoserverUsername, geoserverPassword);
        LayerCsw layer = geonetworkCaller.getLayersInformation(GeoCaller.FILTER_TYPE.TITLE, ThreddsMetadataInserter.treatLayerTitleForSearch(layerTitle));
        MetadataInfo metadataInfo = null;
        if (layer != null) {
            metadataInfo = new MetadataInfo();
            String endPoint = layer.getGeoserverUrl();
            metadataInfo.setUrl(endPoint);
            ELog.debug("Found Layer on Geoserver " + endPoint);
            if (endPoint.endsWith(".nc")) {
                metadataInfo.setDescription(SupportedStorages.THREDDS.toString());
            } else {
                metadataInfo.setDescription(SupportedStorages.GEOSERVER.toString());
            }
            metadataInfo.setName(layer.getName());
            metadataInfo.setTitle(layer.getTitle());
        }
        return metadataInfo;
    }

    public static void main(String[] args) {
        MetadataInfo mi = EnvDataExplorer.retrieveStoredDatasetInfo(defaultGeoNetworkURL, defaultGeoNetworkUser, defaultGeoNetworkPassword, defaultGeoServerUser, defaultGeoServerPassword, "Cloud fraction cami0000090164x128L26c030918.nc");
        ELog.debug(mi.getUrl());
    }
}

