package org.gcube.dataanalysis.environment.test;

import java.util.HashMap;
import java.util.List;

import org.gcube.dataanalysis.environment.explorer.EnvDataExplorer;

public class TestDataExplorer {

	public static void main(String[] args) {
		String layer = "enviroments";
		String workspace = "wsenvironment";
		float x = 0.1f;
		float y = 0.1f;
		long t0=System.currentTimeMillis();
		
		//EXAMPLE 1: GEONETWORK Interaction : get the list of features associated to the layer
		//get the list of the features contained in the layer
		System.out.println("EXAMPLE 1: GET LIST: ");
		List<String> list = EnvDataExplorer.getLayerFeaturesGeoNetwork(workspace,layer);
		System.out.println("FEATURES LIST: "+ list);
		System.out.println("ELAPSED: "+(System.currentTimeMillis()-t0));
		
		//EXAMPLE 2: GEONETWORK Interaction : default connection will be used, pointing to D4science
		//get the features associated to the point
		System.out.println("EXAMPLE 2: GEONETWORK DEFAULT");
		t0=System.currentTimeMillis();
		HashMap<String, String> map = EnvDataExplorer.retrieveEnvInfoGeoNetwork(workspace,layer,x,y);
		System.out.println("PARAMETERS MAP: "+ map);
		System.out.println("ELAPSED: "+(System.currentTimeMillis()-t0));
		
		//EXAMPLE 3: GEOSERVER Interaction
		System.out.println("EXAMPLE 3: GEOSERVER DIRECT");
		t0 = System.currentTimeMillis();
		//use an explicit geoserver url
		HashMap<String, String> map2 = EnvDataExplorer.retrieveEnvInfoGeoServer("http://geoserver.d4science-ii.research-infrastructures.eu:80/geoserver/",workspace,layer,x,y);
		System.out.println("PARAMETERS MAP: "+ map2);
		System.out.println("ELAPSED: "+(System.currentTimeMillis()-t0));

		//EXAMPLE 4: GEONETWORK PARAMETERS Interaction
		System.out.println("EXAMPLE 4: GEONETWORK WITH PARAMETERS");
		t0 = System.currentTimeMillis();
		//use an explicit geoserver url
		HashMap<String, String> map3 = EnvDataExplorer.retrieveEnvInfoGeoNetwork("http://geoserver.d4science-ii.research-infrastructures.eu/geonetwork/","username","password","geoserverusername","geoserverpassword",workspace,layer,x,y);
		System.out.println("PARAMETERS MAP: "+ map3);
		System.out.println("ELAPSED: "+(System.currentTimeMillis()-t0));

		//EXAMPLE 5: GET the GEOSERVER containing the layer - for fast sequent interactions
		System.out.println("EXAMPLE 5: GEOSERVER RETRIEVE");
		t0 = System.currentTimeMillis();
		//use an explicit geoserver url
		String geoserverURL = EnvDataExplorer.getGeoServer(workspace,layer);
		System.out.println("GEOSERVER URL: "+ geoserverURL);
		System.out.println("ELAPSED: "+(System.currentTimeMillis()-t0));

				
		
	}
}
