package org.gcube.dataanalysis.environment.thredds;

import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;

import org.gcube.common.geoserverinterface.geonetwork.csw.NamespaceCswResolver;
import org.gcube.common.geoserverinterface.geonetwork.utils.InputStreamUtil;
import org.gcube.dataanalysis.environment.utils.ELog;
import org.gcube.dataanalysis.environment.utils.HttpRequest;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

import ucar.ma2.Array;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers.Member;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.FeatureCollection;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.point.PointDatasetImpl;
import ucar.nc2.ft.point.standard.StandardPointCollectionImpl;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public class ThreddsDataExplorer {

	// http://thredds.research-infrastructures.eu:8080/thredds/catalog/public/netcdf/catalog.xml
	public static String timePrefix = "time:";

	public static List<String> getFiles(String catalogURL) throws Exception {

		String xml = HttpRequest.sendGetRequest(catalogURL, null);
		XPath xpath = XPathFactory.newInstance().newXPath();
		xpath.setNamespaceContext(new NamespaceCswResolver());
		XPathExpression xPathExpression = xpath.compile("//child::*[local-name()='catalog']/child::*[local-name()='dataset']/child::*[local-name()='dataset']");
		InputSource inputSource = new InputSource(InputStreamUtil.stringToInputStream(xml));
		NodeList nodes = (NodeList) xPathExpression.evaluate(inputSource, XPathConstants.NODESET);
		List<String> fileNames = new ArrayList<String>();
		for (int i = 0; i < nodes.getLength(); i++) {
			Node node = nodes.item(i);
			String name = node.getAttributes().getNamedItem("name").getNodeValue();
			if (name != null)
				fileNames.add(name);
		}

		return fileNames;
	}

	// A GridDatatype is like a specialized Variable that explicitly handles X,Y,Z,T dimensions
	public HashMap<String, String> manageGridDataset(String layerTitle, String filename, double x, double y) throws Exception {
		HashMap<String, String> valuesMap = new HashMap<String, String>();
		GridDataset gds = ucar.nc2.dt.grid.GridDataset.open(filename);
		List<GridDatatype> gridTypes = gds.getGrids();
		String layerT = layerTitle;
		if (layerTitle.lastIndexOf(' ')>=0)
			layerT = layerTitle.substring(0, layerTitle.lastIndexOf(' '));
		layerT = layerT.toLowerCase();
		for (GridDatatype gdt : gridTypes) {
			String description = ThreddsMetadataInserter.treatDescription(gdt.getDescription()).trim();
			ELog.debug("ThreddsDataExplorer->CHECKING " + gdt.getFullName() + "<->" + description + " VS " + layerT);
			if (description.replace(" ", "").toLowerCase().startsWith(layerT.replace(" ", ""))) {
				ELog.debug("ThreddsDataExplorer->PROCESSING " + gdt.getFullName() + "<->" + gdt.getDescription());
				GridDatatype grid = gds.findGridDatatype(gdt.getName());
				GridCoordSystem gcs = grid.getCoordinateSystem();
				/*
				 * CoordinateAxis xAxis = gcs.getXHorizAxis(); CoordinateAxis yAxis = gcs.getYHorizAxis(); CoordinateAxis1D zAxis = gcs.getVerticalAxis(); // may be null
				 */

				long timeSteps = 0;
				java.util.Date[] dates = null;
				if (gcs.hasTimeAxis1D()) {
					CoordinateAxis1DTime tAxis1D = gcs.getTimeAxis1D();
					dates = tAxis1D.getTimeDates();
					timeSteps = dates.length;
				} else if (gcs.hasTimeAxis()) {
					CoordinateAxis tAxis = gcs.getTimeAxis();
					timeSteps = tAxis.getSize();
				}

				int[] xy = gcs.findXYindexFromLatLon(y, x, null);
				for (int j = 0; j < timeSteps; j++) {
					Array data = grid.readDataSlice(j, 0, xy[1], xy[0]); // note order is t, z, y, x
					Double val = takeFirstDouble(data);

					if (!val.isNaN()) {
						String date = "" + j;
						if (dates != null)
							date = dates[j].toString();
						// System.out.printf("Value at %s %f %f == %f%n", date, y, x, val);
						valuesMap.put(timePrefix + date, "" + val);
					}
				}
				break;
			}
		}
		return valuesMap;
	}

	public static Double takeFirstDouble(Array data) {
		long datal = data.getSize();
		Double val = Double.NaN;
		try {
			for (int k = 0; k < datal; k++) {
				Double testVal = data.getDouble(k);
				if (!testVal.isNaN()) {
					val = testVal;
					break;
				}
			}
		} catch (Exception ee) {
			ELog.debug("ThreddsDataExplorer-> WARNING: Error in getting value: " + ee.getLocalizedMessage());
		}
		return val;
	}

	public HashMap<String, String> managePointsDataset2(String layerTitle, String filename, double x, double y) throws Exception {

		HashMap<String, String> valuesMap = new HashMap<String, String>();

		NetcdfFile ncFile = ucar.nc2.dataset.NetcdfDataset.openFile(filename, null);
		List<Variable> vars = ncFile.getVariables();
		for (Variable var : vars) {
			ELog.debug("ThreddsDataExplorer-> VALUE FOR VAR - " + var.getDescription() + " : " + NoDatasetFiles.getVarPoint(var, x, y));

		}
		return valuesMap;
	}

	// A GridDatatype is like a specialized Variable that explicitly handles X,Y,Z,T dimensions

	public HashMap<String, String> managePointsDataset(String layerTitle, String filename, double x, double y) throws Exception {
		HashMap<String, String> valuesMap = new HashMap<String, String>();
		float tolerance = 0.25f;

		// ELog.debug("->FILENAME "+filename);
		Formatter errlog = new Formatter();
		FeatureDataset fdataset = FeatureDatasetFactoryManager.open(FeatureType.POINT, filename, null, errlog);

		PointDatasetImpl ds = (PointDatasetImpl) fdataset;

		List<FeatureCollection> lfc = ds.getPointFeatureCollectionList();
		// FeatureCollection fc = ds.getPointFeatureCollectionList().get(0);

		for (FeatureCollection fc : lfc) {

			StandardPointCollectionImpl spf = (StandardPointCollectionImpl) fc;
			PointFeatureIterator iter = null;
			while ((y - tolerance>-90)&&
					(x-tolerance>-180)&&
					(y+tolerance<90)&&
					(x+tolerance<180)){
				LatLonRect rect = new LatLonRect(new LatLonPointImpl(y - tolerance, x - tolerance), new LatLonPointImpl(y + tolerance, x + tolerance));
				PointFeatureCollection coll = spf.subset(rect, null);
				iter = coll.getPointFeatureIterator(100 * 1000); // 100Kb buffer
//				iter = spf.getPointFeatureIterator(100 * 1000);
			if (iter.getCount() == 0)
				iter.finish();
			else 
				break;
			tolerance = tolerance + 0.25f;
			ELog.debug("ThreddsDataExplorer-> tolerance = "+tolerance);
			}
			
			if (iter!=null){
				try {
					
					while (iter.hasNext()) {
						ucar.nc2.ft.PointFeature pf = iter.next();
						ELog.debug("ThreddsDataExplorer-> EarthLoc: " + pf.getLocation());
						ELog.debug("ThreddsDataExplorer-> EarthTime: " + pf.getObservationTime());
						StructureData sd = pf.getData();
						List<Member> mems = sd.getMembers();
						for (Member m : mems) {
							String unit = m.getUnitsString();
							if ((unit != null) && (unit.length() > 0)) {
								ELog.debug("ThreddsDataExplorer-> description: " + m.getDescription());
								ELog.debug("ThreddsDataExplorer-> data param: " + m.getDataParam());
								ELog.debug("ThreddsDataExplorer-> name: " + m.getName());
								ELog.debug("ThreddsDataExplorer-> unit: " + m.getUnitsString());
								ELog.debug("ThreddsDataExplorer-> type: " + m.getDataType());
								Array arr = sd.getArray(m.getName());
								ELog.debug("ThreddsDataExplorer-> is Time: " + m.getDataType());
								Double val = takeFirstDouble(arr);

								ELog.debug("ThreddsDataExplorer-> extracted value: " + val);
							}
						}
						ELog.debug("ThreddsDataExplorer-> EarthTime: ");
					}
				} finally {
					iter.finish();
				}
			}
			break;
		}
		// PointDatasetRemote pdr = new PointDatasetRemote(fc.getCollectionFeatureType(),filename, ds.getDataVariables(), new LatLonRect(new LatLonPointImpl(-90,-180),new LatLonPointImpl(90,180)), ds.getDateRange());

		// ELog.debug(lfc.toString());

		// ds.getBoundingBox();
		/*
		 * List<Attribute> listA = ds.getGlobalAttributes(); for (Attribute a : listA) { ELog.debug("Attribute: " + a.getName());
		 * 
		 * }
		 * 
		 * List<VariableSimpleIF> listvsif = ds.getDataVariables(); for (VariableSimpleIF a : listvsif) { DataType dt = a.getDataType(); ELog.debug("VARIABLE: " + a.getName() + " :: " + a.getDescription() + " -- " + dt); }
		 */
		return valuesMap;
	}

	// A GridDatatype is like a specialized Variable that explicitly handles X,Y,Z,T dimensions
	public static boolean isGridDataset(String filename) {
		try {
			Formatter errlog = new Formatter();
			FeatureDataset fdataset = FeatureDatasetFactoryManager.open(FeatureType.GRID, filename, null, errlog);
			if (fdataset == null) {
				// System.out.printf("GRID Parse failed --> %s\n", errlog);
				ELog.debug("ThreddsDataExplorer-> NOT GRID");
				return false;
			} else
				return true;
		} catch (Exception e) {
			return false;
		}
	}

	public static boolean isDataset(String filename) throws Exception {
		boolean isdataset = false;
		try {
			Formatter errlog = new Formatter();
			FeatureType[] fts = FeatureType.values();
			for (int i = 0; i < fts.length; i++) {
				FeatureDataset fdataset = FeatureDatasetFactoryManager.open(fts[i], filename, null, errlog);
				if (fdataset == null) {
					// System.out.printf(fts[i]+": Parse failed --> %s\n",errlog);
				} else {
					ELog.debug("ThreddsDataExplorer-> "+fts[i] + " OK!");
					isdataset = true;
				}
			}
		} catch (Exception e) {
		}
		return isdataset;
	}

	public List<HashMap<String, String>> mapFeaturesForSet(String layerTitle, String filename, float[][] xy) {
		List<HashMap<String, String>> mapList = new ArrayList<HashMap<String, String>>();
		for (int i = 0; i < xy.length; i++) {
			mapList.add(mapFeatures(layerTitle, filename, (double) xy[i][0], (double) xy[i][1]));
		}
		return mapList;
	}

	public HashMap<String, String> mapFeatures(String layerTitle, String filename, double x, double y) {
		try {
			if (isGridDataset(filename)) {
				ELog.debug("ThreddsDataExplorer-> FILE is of GridDataset Type");
				return manageGridDataset(layerTitle, filename, x, y);
			} else if (!isDataset(filename)) {
				HashMap<String, String> map = new HashMap<String, String>();
				NoDatasetFiles file = new NoDatasetFiles(filename);
				try {
					file.open();
					double value = file.getZ(x, y);
					if (value != Double.NaN) {
						map.put(timePrefix + "0", "" + value);
					}
				} catch (Exception e) {
					e.printStackTrace();
					ELog.debug("ThreddsDataExplorer-> Error in getting Z dimension");
				}
				file.close();
				return map;
			} else
				ELog.debug("ThreddsDataExplorer-> ERROR: currently not supported DATA TYPE");
		} catch (Exception e) {
			e.printStackTrace();
		}
		return new HashMap<String, String>();
	}

	public static void main(String args[]) throws Exception {
		// new ThreddsDataExplorer().openGridDataset("http://thredds.research-infrastructures.eu:8080/thredds/dodsC/public/netcdf/testData.nc", 43.88d, 112.7d);
//		 Map<String, String> map = new ThreddsDataExplorer().mapFeatures("http://thredds.research-infrastructures.eu:8080/thredds/dodsC/public/netcdf/tos_O1_2001-2002.nc", 173.0d, 11.5d);
		// Map<String, String> map = new ThreddsDataExplorer().mapFeatures("http://thredds.research-infrastructures.eu:8080/thredds/dodsC/public/netcdf/testData.nc", 173.0d, 11.5d);
		// Map<String, String> map = new ThreddsDataExplorer().mapFeatures("http://thredds.research-infrastructures.eu:8080/thredds/dodsC/public/netcdf/gebco_08.nc", 173.0d, 11.5d);
		// Map<String, String> map = new ThreddsDataExplorer().mapFeatures("http://thredds.research-infrastructures.eu:8080/thredds/dodsC/public/netcdf/testData.nc", 173.0d, 11.5d);
		// Map<String, String> map = new ThreddsDataExplorer().mapFeatures("http://thredds.research-infrastructures.eu:8080/thredds/dodsC/public/netcdf/19981111_0045.nc", 98.82d, 41.74d);
		// Map<String, String> map = new ThreddsDataExplorer().mapFeatures("http://thredds.research-infrastructures.eu:8080/thredds/dodsC/public/netcdf/ECMWF_ERA-40_subset.nc", 173.0d, 11.5d);
		// Map<String, String> map = new ThreddsDataExplorer().mapFeatures("http://thredds.research-infrastructures.eu:8080/thredds/dodsC/public/netcdf/GLASS.nc", 173.0d, 11.5d);
		// Map<String, String> map = new ThreddsDataExplorer().mapFeatures("http://thredds.research-infrastructures.eu:8080/thredds/dodsC/public/netcdf/IMAGE0002.nc", 173.0d, 11.5d);
		// Map<String, String> map = new ThreddsDataExplorer().mapFeatures("http://thredds.research-infrastructures.eu:8080/thredds/dodsC/public/netcdf/WMI_Lear.nc", 173.0d, 11.5d);
		// Map<String, String> map = new ThreddsDataExplorer().mapFeatures("http://thredds.research-infrastructures.eu:8080/thredds/dodsC/public/netcdf/WMI_Lear.nc", 173.0d, 11.5d);
		// Map<String, String> map = new ThreddsDataExplorer().mapFeatures("dods://thredds.research-infrastructures.eu:8080/thredds/dodsC/public/netcdf/madis-maritime.nc", 173.0d, 11.5d);
		// Map<String, String> map = new ThreddsDataExplorer().mapFeatures("Mean sea level pressure","http://thredds.research-infrastructures.eu:8080/thredds/dodsC/public/netcdf/ECMWF_ERA-40_subset.nc", 173.0d, 11.5d);
//		Map<String, String> map = new ThreddsDataExplorer().managePointsDataset("", "http://thredds.research-infrastructures.eu:8080/thredds/dodsC/public/netcdf/madis-mesonet.nc", 173.0d, 11.5d);
		//Map<String, String> map = new ThreddsDataExplorer().mapFeatures("Temperature", "http://thredds.research-infrastructures.eu:8080/thredds/dodsC/public/netcdf/myov02-med-ingv-tem-reanalysis_1359540530431.nc", 17.512207d, 41.372686);
//		Map<String, String> map = new ThreddsDataExplorer().mapFeatures("mole concentration of phosphate in sea water", "http://thredds.research-infrastructures.eu:8080/thredds/dodsC/public/netcdf/myov02-med-ogs-bio-reanalysis_1359568166986.nc", 17.512207d, 41.372686);
//		Map<String, String> map = new ThreddsDataExplorer().mapFeatures("concentration", "http://thredds.research-infrastructures.eu:8080/thredds/dodsC/public/netcdf/myov02-med-ogs-bio-reanalysis_1359567916730.nc", 17.512207d, 41.372686);
		Map<String, String> map = new ThreddsDataExplorer().mapFeatures("meridional", "http://thredds.research-infrastructures.eu:8080/thredds/dodsC/public/netcdf/global-reanalysis-phys-001-004-a-ran-fr-glorys2-gridv_1359585682713.nc", 17.512207d, 41.372686);
		
		ELog.debug("MAP: " + map);
		ObjectOutputStream oos = new  ObjectOutputStream(new FileOutputStream("mapPhosphate.dat"));
		oos.writeObject(map);
		oos.close();
	}

	public static void main1(String[] args) throws Exception {
		List<String> files = getFiles("http://thredds.research-infrastructures.eu:8080/thredds/catalog/public/netcdf/catalog.xml");
		ELog.debug(""+files);

	}

}
