package org.gcube.dataanalysis.environment.thredds;

import java.util.List;

import org.gcube.common.geoserverinterface.GeoCaller.FILTER_TYPE;
import org.gcube.common.geoserverinterface.GeonetworkCaller;
import org.gcube.common.geoserverinterface.bean.LayerCsw;
import org.gcube.dataanalysis.environment.utils.ELog;
import org.gcube.dataanalysis.environment.utils.MetadataInsertionGeonetwork;

import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;

public class ThreddsMetadataInserter {

	public static String Separator = " ";

	public static void addGridDatasetToGeoNetwork(String fileurl, String filename, String geonetworkUrl, String geonetworkUsername, String geonetworkPassword, String geoserverUsername, String geoserverPassword) throws Exception {

		GridDataset gds = ucar.nc2.dt.grid.GridDataset.open(fileurl);
		List<GridDatatype> gridTypes = gds.getGrids();
		for (GridDatatype gdt : gridTypes) {

			GridDatatype grid = gds.findGridDatatype(gdt.getName());
			GridCoordSystem gcs = grid.getCoordinateSystem();

			String officialDescription = treatDescription(gdt.getDescription()).trim();
			if (officialDescription.length() > 0) {
				String unit = gdt.getUnitsString().trim();
				if ((unit.length() > 0) && (!unit.startsWith("(")))
					unit = "(" + unit + ")";

				ELog.debug("ThreddsDataExplorer-> ADDING TO GEONET: " + officialDescription);

				CoordinateAxis xAxis = gcs.getXHorizAxis();
				CoordinateAxis yAxis = gcs.getYHorizAxis();
				double x1 = (xAxis.getMinValue() - 180);
				double x2 = (xAxis.getMaxValue() - 180);
				double y1 = yAxis.getMinValue();
				double y2 = yAxis.getMaxValue();

				if (x1 < -180)
					x1 = -180;
				if (x1 > 180)
					x1 = 180;
				if (x2 > 180)
					x2 = 180;
				if (x2 < -180)
					x2 = -180;
				if (y1 < -90)
					y1 = -90;
				if (y1 > 90)
					y1 = 90;
				if (y2 > 90)
					y2 = 90;
				if (y2 < -90)
					y2 = -90;

				ELog.debug("ThreddsDataExplorer-> Bounding Box: " + "(" + x1 + "," + x2 + "," + y1 + "," + y2 + ")");

				MetadataInsertionGeonetwork.addThreddsMetadata(

				geonetworkUrl, geonetworkUsername, geonetworkPassword, geoserverUsername, geoserverPassword, officialDescription + Separator + treatFileName(filename), filename + ":" + gdt.getFullName().trim(), gdt.getFullName().trim() + ": " + officialDescription + " " + unit + " from " + treatFileName(filename), fileurl, (xAxis.getMinValue() - 180), (xAxis.getMaxValue() - 180), yAxis.getMinValue(), yAxis.getMaxValue());
			}
		}
	}

	public static void updateGeonetwork(String threddsCatalogUrl, String geonetworkUrl, String geonetworkUsername, String geoserverUsername, String geoserverPassword, String geonetworkPassword) throws Exception {

		List<String> files = ThreddsDataExplorer.getFiles(threddsCatalogUrl);

		String threddsprefix = threddsCatalogUrl.substring(0, threddsCatalogUrl.lastIndexOf("/")).replace("/catalog/", "/dodsC/");
		for (String file : files) {
			String threddsFile = threddsprefix + "/" + file;
			ELog.debug("ThreddsDataExplorer-> FILE " + threddsFile);
			if (ThreddsDataExplorer.isGridDataset(threddsFile)) {
				if (!isFileOnGeoNetwork(geonetworkUrl, geonetworkUsername, geonetworkPassword, geoserverUsername, geoserverPassword, file))
					addGridDatasetToGeoNetwork(threddsFile, file, geonetworkUrl, geonetworkUsername, geonetworkPassword, geoserverUsername, geoserverPassword);
				else
					ELog.debug("ThreddsDataExplorer-> YET PRESENT");
			}
		}

	}

	public static boolean isFileOnGeoNetwork(String geonetworkUrl, String geonetworkUsername, String geonetworkPassword, String geoserverUsername, String geoserverPassword, String filename) {
		GeonetworkCaller geonetworkCaller = new GeonetworkCaller(geonetworkUrl, geonetworkUsername, geonetworkPassword,geoserverUsername, geoserverPassword);
		LayerCsw layer = null;
		try {
			layer = geonetworkCaller.getLayersInformation(FILTER_TYPE.ANY_TEXT, treatFileName(filename));
		} catch (Exception e) {
			ELog.debug("WARNING: Error in retrieving filename " + filename + " from GeoNewtork -> " + e.getLocalizedMessage());
		}
		if (layer != null) {
			/*
			 * String endPoint = layer.getGeoserverUrl(); if (endPoint.equals(filename))
			 */
			return true;
		}
		return false;
	}

	public static String treatFileName(String file) {
		return file.replace("_", "").replace("-", "");
	}

	public static String treatDescription(String description) {
		description = description.toLowerCase();
		return description.replace("_", " ").replace("-", " ").replaceAll("[^A-Za-z0-9 ]", "");
	}

	public static String treatLayerTitle(String name) {
		if (name.toLowerCase().endsWith(".nc")){
			return name.substring(name.lastIndexOf(" ")).trim();
		}
		else{
			return name;
			/*
//		name = name.toLowerCase();
		StringTokenizer tokenizer = new StringTokenizer(name, " ");
		StringBuffer sb = new StringBuffer();
		int i = 0;
		while (tokenizer.hasMoreTokens()) {
			String currentToken = tokenizer.nextToken();
			int cToklen = currentToken.length();
			if ((cToklen > 2) || (cToklen < 2)) {
				if (((cToklen == 1) && (i == 0)) || (cToklen > 2))
					sb.append(currentToken + " ");
			}
			i++;
		}
		ELog.debug("TITLE :::: " + sb.toString().trim());
		return sb.toString().trim();
		*/
		}
		
	}
	
	public static String treatLayerTitleForSearch(String name) {
		String name1 = treatLayerTitle(name);
//		name1 = name1.toLowerCase().replace(" the ", "");
		return name1;
	}

	public static void main(String[] args) throws Exception {
		String threddsCatalogUrl = "http://thredds.research-infrastructures.eu:8080/thredds/catalog/public/netcdf/catalog.xml";
		String geonetworkUrl = "http://geoserver-dev.d4science-ii.research-infrastructures.eu/geonetwork";
		String geonetworkUsername = "admin";
		String geonetworkPassword = "admin";
		String geoServerUser = "admin";
		String geoServerPassword = "gCube@geo2010";
		long t0 = System.currentTimeMillis();
		updateGeonetwork(threddsCatalogUrl, geonetworkUrl, geonetworkUsername, geonetworkPassword,geoServerUser,geoServerPassword);
		ELog.debug("ThreddsDataExplorer-> Elapsed: " + (System.currentTimeMillis() - t0));
		// ELog.debug(isFileOnGeoNetwork(geonetworkUrl, geonetworkUsername, geonetworkPassword, "ECMWFERA40subset.nc"));
	}

}
