/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.environment.thredds;

import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.gcube.common.geoserverinterface.geonetwork.csw.NamespaceCswResolver;
import org.gcube.common.geoserverinterface.geonetwork.utils.InputStreamUtil;
import org.gcube.dataanalysis.environment.thredds.NoDatasetFiles;
import org.gcube.dataanalysis.environment.thredds.ThreddsMetadataInserter;
import org.gcube.dataanalysis.environment.utils.ELog;
import org.gcube.dataanalysis.environment.utils.HttpRequest;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import ucar.ma2.Array;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.FeatureCollection;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.point.PointDatasetImpl;
import ucar.nc2.ft.point.standard.StandardPointCollectionImpl;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public class ThreddsDataExplorer {
    public static String timePrefix = "time:";

    public static List<String> getFiles(String catalogURL) throws Exception {
        String xml = HttpRequest.sendGetRequest(catalogURL, null);
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext((NamespaceContext)new NamespaceCswResolver());
        XPathExpression xPathExpression = xpath.compile("//child::*[local-name()='catalog']/child::*[local-name()='dataset']/child::*[local-name()='dataset']");
        InputSource inputSource = new InputSource(InputStreamUtil.stringToInputStream((String)xml));
        NodeList nodes = (NodeList)xPathExpression.evaluate(inputSource, XPathConstants.NODESET);
        ArrayList<String> fileNames = new ArrayList<String>();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            String name = node.getAttributes().getNamedItem("name").getNodeValue();
            if (name != null) {
                fileNames.add(name);
            }
            ++i;
        }
        return fileNames;
    }

    public HashMap<String, String> manageGridDataset(String layerTitle, String filename, double x, double y) throws Exception {
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        GridDataset gds = GridDataset.open((String)filename);
        List gridTypes = gds.getGrids();
        String layerT = layerTitle;
        if (layerTitle.lastIndexOf(32) >= 0) {
            layerT = layerTitle.substring(0, layerTitle.lastIndexOf(32));
        }
        layerT = layerT.toLowerCase();
        for (GridDatatype gdt : gridTypes) {
            String description = ThreddsMetadataInserter.treatDescription(gdt.getDescription()).trim();
            ELog.debug("ThreddsDataExplorer->CHECKING " + gdt.getFullName() + "<->" + description + " VS " + layerT);
            if (!description.replace(" ", "").toLowerCase().startsWith(layerT.replace(" ", ""))) continue;
            ELog.debug("ThreddsDataExplorer->PROCESSING " + gdt.getFullName() + "<->" + gdt.getDescription());
            GridDatatype grid = gds.findGridDatatype(gdt.getName());
            GridCoordSystem gcs = grid.getCoordinateSystem();
            long timeSteps = 0L;
            Date[] dates = null;
            if (gcs.hasTimeAxis1D()) {
                CoordinateAxis1DTime tAxis1D = gcs.getTimeAxis1D();
                dates = tAxis1D.getTimeDates();
                timeSteps = dates.length;
            } else if (gcs.hasTimeAxis()) {
                CoordinateAxis tAxis = gcs.getTimeAxis();
                timeSteps = tAxis.getSize();
            }
            int[] xy = gcs.findXYindexFromLatLon(y, x, null);
            int j = 0;
            while ((long)j < timeSteps) {
                Array data = grid.readDataSlice(j, 0, xy[1], xy[0]);
                Double val = ThreddsDataExplorer.takeFirstDouble(data);
                if (!val.isNaN()) {
                    String date = "" + j;
                    if (dates != null) {
                        date = dates[j].toString();
                    }
                    valuesMap.put(String.valueOf(timePrefix) + date, "" + val);
                }
                ++j;
            }
            break block0;
        }
        return valuesMap;
    }

    public static Double takeFirstDouble(Array data) {
        long datal = data.getSize();
        Double val = Double.NaN;
        try {
            int k = 0;
            while ((long)k < datal) {
                Double testVal = data.getDouble(k);
                if (!testVal.isNaN()) {
                    val = testVal;
                    break;
                }
                ++k;
            }
        }
        catch (Exception ee) {
            ELog.debug("ThreddsDataExplorer-> WARNING: Error in getting value: " + ee.getLocalizedMessage());
        }
        return val;
    }

    public HashMap<String, String> managePointsDataset2(String layerTitle, String filename, double x, double y) throws Exception {
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        NetcdfFile ncFile = NetcdfDataset.openFile((String)filename, null);
        List vars = ncFile.getVariables();
        for (Variable var : vars) {
            ELog.debug("ThreddsDataExplorer-> VALUE FOR VAR - " + var.getDescription() + " : " + NoDatasetFiles.getVarPoint(var, x, y));
        }
        return valuesMap;
    }

    public HashMap<String, String> managePointsDataset(String layerTitle, String filename, double x, double y) throws Exception {
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        float tolerance = 0.25f;
        Formatter errlog = new Formatter();
        FeatureDataset fdataset = FeatureDatasetFactoryManager.open((FeatureType)FeatureType.POINT, (String)filename, null, (Formatter)errlog);
        PointDatasetImpl ds = (PointDatasetImpl)fdataset;
        List lfc = ds.getPointFeatureCollectionList();
        Iterator iterator = lfc.iterator();
        if (iterator.hasNext()) {
            FeatureCollection fc = (FeatureCollection)iterator.next();
            StandardPointCollectionImpl spf = (StandardPointCollectionImpl)fc;
            PointFeatureIterator iter = null;
            while (y - (double)tolerance > -90.0 && x - (double)tolerance > -180.0 && y + (double)tolerance < 90.0 && x + (double)tolerance < 180.0) {
                LatLonRect rect = new LatLonRect((LatLonPoint)new LatLonPointImpl(y - (double)tolerance, x - (double)tolerance), (LatLonPoint)new LatLonPointImpl(y + (double)tolerance, x + (double)tolerance));
                PointFeatureCollection coll = spf.subset(rect, null);
                iter = coll.getPointFeatureIterator(100000);
                if (iter.getCount() != 0) break;
                iter.finish();
                ELog.debug("ThreddsDataExplorer-> tolerance = " + (tolerance += 0.25f));
            }
            if (iter != null) {
                try {
                    while (iter.hasNext()) {
                        PointFeature pf = iter.next();
                        ELog.debug("ThreddsDataExplorer-> EarthLoc: " + pf.getLocation());
                        ELog.debug("ThreddsDataExplorer-> EarthTime: " + pf.getObservationTime());
                        StructureData sd = pf.getData();
                        List mems = sd.getMembers();
                        for (StructureMembers.Member m : mems) {
                            String unit = m.getUnitsString();
                            if (unit == null || unit.length() <= 0) continue;
                            ELog.debug("ThreddsDataExplorer-> description: " + m.getDescription());
                            ELog.debug("ThreddsDataExplorer-> data param: " + m.getDataParam());
                            ELog.debug("ThreddsDataExplorer-> name: " + m.getName());
                            ELog.debug("ThreddsDataExplorer-> unit: " + m.getUnitsString());
                            ELog.debug("ThreddsDataExplorer-> type: " + m.getDataType());
                            Array arr = sd.getArray(m.getName());
                            ELog.debug("ThreddsDataExplorer-> is Time: " + m.getDataType());
                            Double val = ThreddsDataExplorer.takeFirstDouble(arr);
                            ELog.debug("ThreddsDataExplorer-> extracted value: " + val);
                        }
                        ELog.debug("ThreddsDataExplorer-> EarthTime: ");
                    }
                }
                finally {
                    iter.finish();
                }
            }
        }
        return valuesMap;
    }

    public static boolean isGridDataset(String filename) {
        try {
            Formatter errlog = new Formatter();
            FeatureDataset fdataset = FeatureDatasetFactoryManager.open((FeatureType)FeatureType.GRID, (String)filename, null, (Formatter)errlog);
            if (fdataset == null) {
                ELog.debug("ThreddsDataExplorer-> NOT GRID");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isDataset(String filename) throws Exception {
        boolean isdataset = false;
        try {
            Formatter errlog = new Formatter();
            FeatureType[] fts = FeatureType.values();
            int i = 0;
            while (i < fts.length) {
                FeatureDataset fdataset = FeatureDatasetFactoryManager.open((FeatureType)fts[i], (String)filename, null, (Formatter)errlog);
                if (fdataset != null) {
                    ELog.debug("ThreddsDataExplorer-> " + fts[i] + " OK!");
                    isdataset = true;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isdataset;
    }

    public List<HashMap<String, String>> mapFeaturesForSet(String layerTitle, String filename, float[][] xy) {
        ArrayList<HashMap<String, String>> mapList = new ArrayList<HashMap<String, String>>();
        int i = 0;
        while (i < xy.length) {
            mapList.add(this.mapFeatures(layerTitle, filename, xy[i][0], xy[i][1]));
            ++i;
        }
        return mapList;
    }

    public HashMap<String, String> mapFeatures(String layerTitle, String filename, double x, double y) {
        try {
            if (ThreddsDataExplorer.isGridDataset(filename)) {
                ELog.debug("ThreddsDataExplorer-> FILE is of GridDataset Type");
                return this.manageGridDataset(layerTitle, filename, x, y);
            }
            if (!ThreddsDataExplorer.isDataset(filename)) {
                HashMap<String, String> map = new HashMap<String, String>();
                NoDatasetFiles file = new NoDatasetFiles(filename);
                try {
                    file.open();
                    double value = file.getZ(x, y);
                    if (value != Double.NaN) {
                        map.put(String.valueOf(timePrefix) + "0", "" + value);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ELog.debug("ThreddsDataExplorer-> Error in getting Z dimension");
                }
                file.close();
                return map;
            }
            ELog.debug("ThreddsDataExplorer-> ERROR: currently not supported DATA TYPE");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new HashMap<String, String>();
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, String> map = new ThreddsDataExplorer().mapFeatures("meridional", "http://thredds.research-infrastructures.eu:8080/thredds/dodsC/public/netcdf/global-reanalysis-phys-001-004-a-ran-fr-glorys2-gridv_1359585682713.nc", 17.512207, 41.372686);
        ELog.debug("MAP: " + map);
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream("mapPhosphate.dat"));
        oos.writeObject(map);
        oos.close();
    }

    public static void main1(String[] args) throws Exception {
        List<String> files = ThreddsDataExplorer.getFiles("http://thredds.research-infrastructures.eu:8080/thredds/catalog/public/netcdf/catalog.xml");
        ELog.debug("" + files);
    }
}

