/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.scripts;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.UUID;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.model.protocol.smp.Handler;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.dataanalysis.executor.scripts.OSCommandGenericWorker;

public class ExecuteScript {
    private float status;
    private static String JOBOUTPUT = "job.txt";
    private static String CONFIGFILENAME = "config.dat";
    GCUBELog logger;
    private static String genericWorkerDir = "/genericworker/";

    public float getStatus() {
        return this.status;
    }

    public ExecuteScript() {
    }

    public ExecuteScript(GCUBELog logger) {
        this.logger = logger;
    }

    public void executeScript(List<String> localfileNames, List<String> remotefiles, String tempRootDir, String toExecute, String argument, String identifier, String scope, String serviceClass, String serviceName, String owner, String remoteDirectory, String session, String NodeConfiguration, boolean deletefiles) throws Exception {
        this.status = 0.0f;
        StringBuffer sb = new StringBuffer();
        File tempDir = null;
        try {
            File workerDir;
            Handler.activateProtocol();
            String locDir = session;
            if (session == null) {
                locDir = ("" + UUID.randomUUID()).replace("-", "");
            }
            if (!(workerDir = new File("." + genericWorkerDir)).exists()) {
                workerDir.mkdir();
            }
            String randomu = new File(tempRootDir).getAbsolutePath() + genericWorkerDir + locDir + "/";
            this.logger.debug((Object)("GenericWorker-> Creating local directory " + randomu));
            sb.append("Creating local directory " + randomu + "\n");
            tempDir = new File(randomu);
            boolean dirc = true;
            if (!tempDir.exists()) {
                dirc = tempDir.mkdir();
            }
            if (dirc) {
                this.logger.debug((Object)"GenericWorker-> Retrieving files");
                sb.append("Retrieving files\n");
                int i = 0;
                for (String fileurl : remotefiles) {
                    URL smpFile = new URL(fileurl);
                    URLConnection uc = smpFile.openConnection();
                    InputStream is = uc.getInputStream();
                    this.logger.debug((Object)("GenericWorker-> Retrieving from " + fileurl + " to :" + tempDir.getAbsolutePath() + "/" + localfileNames.get(i)));
                    sb.append("Retrieving from " + fileurl + " to :" + tempDir.getAbsolutePath() + "/" + localfileNames.get(i));
                    ExecuteScript.inputStreamToFile(is, tempDir.getAbsolutePath() + "/" + localfileNames.get(i));
                    is.close();
                    ++i;
                }
                if (NodeConfiguration != null) {
                    BufferedWriter oos = new BufferedWriter(new FileWriter(new File(tempDir, CONFIGFILENAME)));
                    oos.write(NodeConfiguration);
                    oos.close();
                }
                this.logger.debug((Object)"GenericWorker-> Files Retrieved");
                sb.append("Files Retrieved\n");
                this.logger.debug((Object)("GenericWorker-> Executing script in " + System.getProperty("os.name")));
                sb.append("Executing script\n");
                String line = "";
                if (System.getProperty("os.name").startsWith("Windows")) {
                    line = new OSCommandGenericWorker().ExecuteGetLine("cmd /c cd " + tempDir.getAbsolutePath() + "\n " + toExecute + " " + argument + "\n exit\n", this.logger);
                } else {
                    line = new OSCommandGenericWorker().ExecuteGetLine("chmod +x " + tempDir.getAbsolutePath() + "/" + toExecute + "", this.logger);
                    String arg = (argument + "_" + CONFIGFILENAME).replace(" ", "_");
                    line = new OSCommandGenericWorker().ExecuteGetLine(tempDir.getAbsolutePath() + "/" + toExecute + " " + tempDir.getAbsolutePath() + "/ " + arg + "\nexit\n", this.logger);
                }
                if (line != null && line.equals("ERROR")) {
                    throw new Exception("ERROR executing script");
                }
                this.logger.debug((Object)("GenericWorker-> Script executed: " + line));
                sb.append("Script executed: " + line + "\n");
                this.logger.debug((Object)"GenericWorker-> all done");
            } else {
                this.logger.debug((Object)"GenericWorker-> Failed to create directory");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.debug((Object)("GenericWorker-> ERROR: " + e.getLocalizedMessage()));
            this.status = 100.0f;
            throw e;
        }
        finally {
            try {
                if (deletefiles && tempDir != null) {
                    this.logger.debug((Object)"GenericWorker-> ... deleting local files");
                    for (File singlefile : tempDir.listFiles()) {
                        boolean del = singlefile.delete();
                        if (!del) {
                            this.logger.debug((Object)("GenericWorker-> ERROR deleting " + singlefile.getName() + " " + del));
                            continue;
                        }
                        this.logger.debug((Object)("GenericWorker-> deleted LOCAL FILE " + singlefile.getName() + " " + del));
                    }
                    this.logger.debug((Object)"GenericWorker-> deleting temporary directory");
                    tempDir.delete();
                }
            }
            catch (Exception e3) {
                e3.printStackTrace();
                this.logger.debug((Object)"GenericWorker-> Error deleting files");
            }
            this.status = 100.0f;
        }
    }

    private void save2Storage(String filename, String suffix, String localdirectory, String remotedirectory, String scope$, String serviceClass, String serviceName, String owner) {
        try {
            this.logger.debug((Object)("GenericWorker-> getting scope " + scope$));
            GCUBEScope scope = GCUBEScope.getScope((String)scope$);
            IClient client = new StorageClient(serviceClass, serviceName, owner, AccessType.SHARED, scope).getClient();
            String localf = localdirectory + filename;
            String remotef = remotedirectory + filename;
            this.logger.debug((Object)("GenericWorker-> updating file " + localf + " to " + remotef));
            String id = client.put(true).LFile(localf).RFile(remotef);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.debug((Object)e);
        }
    }

    private static void inputStreamToFile(InputStream is, String path) throws FileNotFoundException, IOException {
        FileOutputStream out = new FileOutputStream(new File(path));
        byte[] buf = new byte[1024];
        int len = 0;
        while ((len = is.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        out.close();
    }
}

