/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.lexicalmatcher.analysis.guesser.treeStructure.chunks;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import org.gcube.dataanalysis.lexicalmatcher.analysis.core.Engine;
import org.gcube.dataanalysis.lexicalmatcher.analysis.core.LexicalEngineConfiguration;
import org.gcube.dataanalysis.lexicalmatcher.utils.LexicalLogger;
import org.gcube.dataanalysis.lexicalmatcher.utils.MathFunctions;

public abstract class ChunkSet {
    protected String seriesName;
    protected String seriesColumn;
    protected int chunkSize;
    private int maxNumberOfChunks;
    ArrayList<Integer> chunkSet;
    protected int chunkSetSize;
    protected BigInteger numberOfEntries;
    protected int chunkIndex;
    protected LexicalEngineConfiguration config;
    protected Engine engine;

    public ChunkSet(int MaxNumberOfChunks, int ChunkSize, String SeriesName, String SeriesColumn, LexicalEngineConfiguration Config, Engine engine) throws Exception {
        this.engine = engine;
        this.config = Config;
        this.setSeriesName(SeriesName);
        this.setSeriesColumn(SeriesColumn);
        this.setChunkSize(ChunkSize);
        this.maxNumberOfChunks = MaxNumberOfChunks;
        this.generateChunkSet();
    }

    public ChunkSet(int MaxNumberOfChunks, int ChunkSize, String SeriesName, String SeriesColumn, BigInteger numberOfEntries, LexicalEngineConfiguration Config, Engine engine) throws Exception {
        this.engine = engine;
        this.config = Config;
        this.setSeriesName(SeriesName);
        this.setSeriesColumn(SeriesColumn);
        this.setChunkSize(ChunkSize);
        this.setNumberOfEntries(numberOfEntries);
        this.maxNumberOfChunks = MaxNumberOfChunks;
        this.generateChunkSet();
    }

    public void generateChunkSet() throws Exception {
        LexicalLogger.getLogger().trace("ChunkSet->generateChunkSet-> \tGenerating Chunk Set for " + this.seriesName + " " + this.seriesColumn);
        int numberOfChunks = this.calculateNumberOfCycles();
        this.chunkSet = MathFunctions.generateRandoms(this.maxNumberOfChunks, 0, numberOfChunks);
        this.chunkIndex = 0;
        this.chunkSetSize = numberOfChunks;
    }

    protected abstract BigDecimal calculateNumberOfElements() throws Exception;

    protected int calculateNumberOfCycles() throws Exception {
        int numberofcycles = 0;
        BigDecimal numberOfElements = this.calculateNumberOfElements();
        BigDecimal[] arraydecimal = numberOfElements.divideAndRemainder(new BigDecimal(BigInteger.valueOf(this.chunkSize)));
        BigDecimal intcycles = arraydecimal[0];
        BigDecimal oddcycles = arraydecimal[1];
        numberofcycles = intcycles.intValue();
        if (numberofcycles == 0 && oddcycles.intValue() > 0) {
            ++numberofcycles;
        }
        return numberofcycles;
    }

    public void setSeriesName(String seriesName) {
        this.seriesName = seriesName;
    }

    public String getSeriesName() {
        return this.seriesName;
    }

    public void setSeriesColumn(String seriesColumn) {
        this.seriesColumn = seriesColumn;
    }

    public String getSeriesColumn() {
        return this.seriesColumn;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setNumberOfEntries(BigInteger numberOfEntries) {
        this.numberOfEntries = numberOfEntries;
    }

    public BigInteger getNumberOfEntries() {
        return this.numberOfEntries;
    }

    public abstract Object nextChunk();
}

