/**
 * 
 */
package org.gcube.dataanalysis.copernicus.motu.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;

/**
 * @author Paolo Fabriani
 *
 */
public class TimeUtil {

    public static String toString(Calendar c) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        return format.format(c.getTime());
    }

    public static Calendar toCalendar(String s) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        Calendar c = Calendar.getInstance();
        try {
            c.setTime(format.parse(s));
        } catch (Exception e) {
            return toCalendar2(s);
        }

        return c;
    }

    private static Calendar toCalendar2(String s) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c = Calendar.getInstance();
        try {
            c.setTime(format.parse(s));
        } catch (Exception e) {
            return toCalendar3(s);
        }

        return c;
    }

    private static Calendar toCalendar3(String s) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(
                "yyyy-MM-dd'T'hh:mm:ss.SSS'Z'");
        Calendar c = Calendar.getInstance();
        c.setTime(format.parse(s));
        return c;
    }

    public static void main(String[] args) throws Exception {
        String t = "2013-01-01T00:00:00.000Z";
        toCalendar(t);
    }
    
}
