/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.motu.client;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.UUID;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.gcube.dataanalysis.copernicus.motu.util.MotuWorkspace;

public class ChunkMerger {
    private static final Logger LOGGER = Logger.getLogger(ChunkMerger.class);
    private MotuWorkspace workspace;

    public ChunkMerger() {
        MotuWorkspace workspace = new MotuWorkspace(UUID.randomUUID().toString());
        workspace.setExecutionsRoot("/tmp/motu-chunk-merger");
        workspace.setInputLocation("input");
        workspace.setOutputLocation("output");
        workspace.ensureStructureExists();
        this.workspace = workspace;
    }

    public void mergeAll(File sourceDir, File destFile) throws IOException, Exception {
        this.distributeFiles(sourceDir, this.workspace.getInputLocation());
        for (File f : this.workspace.getInputLocation().listFiles()) {
            if (!f.isDirectory()) continue;
            this.process(f, destFile);
        }
    }

    private void distributeFiles(File sourceDir, File destDir) throws IOException {
        File[] files;
        for (File file : files = sourceDir.listFiles()) {
            String name = file.getName();
            name = name.replaceAll("-", "/");
            FileUtils.copyFile((File)file, (File)new File(destDir, name));
        }
    }

    private void process(File sourceDir, File destination) throws IOException, Exception {
        for (File f : sourceDir.listFiles()) {
            File nc;
            if (!f.isDirectory() || (nc = new File(sourceDir, f.getName() + ".nc")).exists()) continue;
            this.process(f, nc);
        }
        LOGGER.debug((Object)"all files are ready for appending/concatenating");
        String type = "";
        for (File f : sourceDir.listFiles()) {
            type = f.getName().substring(0, 1);
        }
        if ("t".equals(type)) {
            this.concatenate(sourceDir, destination);
        } else if ("v".equals(type)) {
            this.append(sourceDir, destination);
        } else {
            throw new Exception("unsupported dimension for merging: " + type);
        }
    }

    private void concatenate(File sourceDir, File destFile) throws Exception {
        Vector<File> files = new Vector<File>();
        for (File f : sourceDir.listFiles()) {
            if (f.isDirectory() || !f.getName().endsWith(".nc")) continue;
            files.add(f);
        }
        Collections.sort(files);
        if (files.isEmpty()) {
            throw new Exception("no files to concatenate");
        }
        if (files.size() == 1) {
            FileUtils.moveFile((File)((File)files.get(0)), (File)destFile);
        } else {
            File first = (File)files.get(0);
            File timedFirst = new File(first.getAbsolutePath() + "-time.nc");
            String cmd1 = "ncks -O -h --mk_rec_dmn time " + first.getAbsolutePath() + " " + timedFirst.getAbsolutePath();
            LOGGER.debug((Object)cmd1);
            this.workspace.exec(cmd1, sourceDir, "log.txt");
            String cmd2 = "ncrcat -h " + timedFirst.getAbsolutePath();
            for (int i = 1; i < files.size(); ++i) {
                cmd2 = cmd2 + " " + ((File)files.get(i)).getAbsolutePath();
            }
            cmd2 = cmd2 + " " + destFile.getAbsolutePath();
            LOGGER.debug((Object)cmd2);
            this.workspace.exec(cmd2, sourceDir, "log.txt");
        }
    }

    private void append(File sourceDir, File destFile) throws Exception {
        Vector<File> files = new Vector<File>();
        for (File f : sourceDir.listFiles()) {
            if (f.isDirectory() || !f.getName().endsWith(".nc")) continue;
            files.add(f);
        }
        Collections.sort(files);
        if (files.size() == 0) {
            throw new Exception("no files to append");
        }
        if (files.size() == 1) {
            FileUtils.moveFile((File)((File)files.get(0)), (File)destFile);
        } else {
            File tmpMerged = new File(sourceDir, "appended.nc");
            for (File f : files) {
                String cmd = "ncks -h -A " + f.getAbsolutePath() + " " + tmpMerged.getAbsolutePath();
                this.workspace.exec(cmd, sourceDir, "log.txt");
            }
            FileUtils.moveFile((File)tmpMerged, (File)destFile);
        }
    }
}

