/**
 * 
 */
package org.gcube.dataanalysis.copernicus.cmems;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author Paolo Fabriani
 *
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class CmemsProduct {

    /*
     * abztract, description, 
     * geographical_area, spatial_resolution, 
     * update_frequency, 
     * dgf
     */
    
    private String abztract;
    private String id;
    private String display_priority;
    private String external_shortname;
    private String version;
    private String short_description;
    private String creation_date;
    private String update_date;
    private String quicklooks;
    private String feature_type;
    private String forecast_length;
    private String all_keywords;
    private String geographical_area;
    private String mission_type;
    private String model_assimilation;
    private String ocean_variables;
    private String ocean_keys;
    private String processing_level;
    private String west;
    private String east;
    private String south;
    private String north;
    private String spatial_resolution_row;
    private String spatial_resolution_row_unit;
    private String spatial_resolution_column;
    private String spatial_resolution_column_unit;
    private String coord_ref_sys;
    private String vertical_min;
    private String vertical_max;
    private String vertical_crs;
    private String vertical_levels;
    private String temporal_resolution;
    private String vertical_coverage;
    private String temporal_begin;
    private String temporal_end;
    private String temporal_extent;
    private String temporal_scale;
    private String update_frequency;
    private String update_schedule;
    private String production_unit;
    private String credit;
    private String documentation;
    private String mail;
    private String ftp;
    private String dgf;
    private String tds;
    private String wms;
    private String service_desk;
    private String upstream_production;
    private String upstream_validation;
    private String downstream_validation;
    private String downstream_production;
    private String MYO_OK;
    private String _version;

    @JsonProperty("abstract")
    public String getAbstract() {
        return abztract;
    }

    public void setAbstract(String abztract) {
        this.abztract = abztract;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty("display_priority")
    public String getDisplayPriority() {
        return display_priority;
    }

    public void setDisplayPriority(String display_priority) {
        this.display_priority = display_priority;
    }

    @JsonProperty("external_shortname")
    public String getExternalShortname() {
        return external_shortname;
    }

    public void setExternalShortname(String external_shortname) {
        this.external_shortname = external_shortname;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @JsonProperty("short_description")
    public String getShortDescription() {
        return short_description;
    }

    public void setShortDescription(String short_description) {
        this.short_description = short_description;
    }

    @JsonProperty("creation_date")
    public String getCreationDate() {
        return creation_date;
    }

    public void setCreationDate(String creation_date) {
        this.creation_date = creation_date;
    }

    @JsonProperty("update_date")
    public String getUpdateDate() {
        return update_date;
    }

    public void setUpdateDate(String update_date) {
        this.update_date = update_date;
    }

    public String getQuicklooks() {
        return quicklooks;
    }

    public void setQuicklooks(String quicklooks) {
        this.quicklooks = quicklooks;
    }

    @JsonProperty("feature_type")
    public String getFeatureType() {
        return feature_type;
    }

    public void setFeatureType(String feature_type) {
        this.feature_type = feature_type;
    }

    @JsonProperty("forecast_length")
    public String getForecastLength() {
        return forecast_length;
    }

    public void setForecastLength(String forecast_length) {
        this.forecast_length = forecast_length;
    }

    @JsonProperty("all_keywords")
    public String getAllKeywords() {
        return all_keywords;
    }

    public void setAll_keywords(String all_keywords) {
        this.all_keywords = all_keywords;
    }

    @JsonProperty("geographical_area")
    public String getGeographicalArea() {
        return geographical_area;
    }

    public void setGeographical_area(String geographical_area) {
        this.geographical_area = geographical_area;
    }

    @JsonProperty("mission_type")
    public String getMissionType() {
        return mission_type;
    }

    public void setMission_type(String mission_type) {
        this.mission_type = mission_type;
    }

    @JsonProperty("model_assimilation")
    public String getModelAssimilation() {
        return model_assimilation;
    }

    public void setModel_assimilation(String model_assimilation) {
        this.model_assimilation = model_assimilation;
    }

    @JsonProperty("ocean_variables")
    public String getOceanVariables() {
        return ocean_variables;
    }

    public void setOcean_variables(String ocean_variables) {
        this.ocean_variables = ocean_variables;
    }

    @JsonProperty("ocean_keys")
    public String getOceanKeys() {
        return ocean_keys;
    }

    public void setOcean_keys(String ocean_keys) {
        this.ocean_keys = ocean_keys;
    }

    @JsonProperty("processing_level")
    public String getProcessingLevel() {
        return processing_level;
    }

    public void setProcessing_level(String processing_level) {
        this.processing_level = processing_level;
    }

    public String getWest() {
        return west;
    }

    public void setWest(String west) {
        this.west = west;
    }

    public String getEast() {
        return east;
    }

    public void setEast(String east) {
        this.east = east;
    }

    public String getSouth() {
        return south;
    }

    public void setSouth(String south) {
        this.south = south;
    }

    public String getNorth() {
        return north;
    }

    public void setNorth(String north) {
        this.north = north;
    }

    @JsonProperty("spatial_resolution_row")
    public String getSpatialResolutionRow() {
        return spatial_resolution_row;
    }

    public void setSpatial_resolution_row(String spatial_resolution_row) {
        this.spatial_resolution_row = spatial_resolution_row;
    }

    @JsonProperty("spatial_resolution_row_unit")
    public String getSpatialResolutionRowUnit() {
        return spatial_resolution_row_unit;
    }

    public void setSpatial_resolution_row_unit(
            String spatial_resolution_row_unit) {
        this.spatial_resolution_row_unit = spatial_resolution_row_unit;
    }

    @JsonProperty("spatial_resolution_column")
    public String getSpatialResolutionColumn() {
        return spatial_resolution_column;
    }

    public void setSpatial_resolution_column(String spatial_resolution_column) {
        this.spatial_resolution_column = spatial_resolution_column;
    }

    @JsonProperty("spatial_resolution_column_unit")
    public String getSpatialResolutionColumnUnit() {
        return spatial_resolution_column_unit;
    }

    public void setSpatial_resolution_column_unit(
            String spatial_resolution_column_unit) {
        this.spatial_resolution_column_unit = spatial_resolution_column_unit;
    }

    @JsonProperty("coord_ref_sys")
    public String getCoordRefSys() {
        return coord_ref_sys;
    }

    public void setCoord_ref_sys(String coord_ref_sys) {
        this.coord_ref_sys = coord_ref_sys;
    }

    @JsonProperty("vertical_min")
    public String getVerticalMin() {
        return vertical_min;
    }

    public void setVertical_min(String vertical_min) {
        this.vertical_min = vertical_min;
    }

    @JsonProperty("vertical_max")
    public String getVerticalMax() {
        return vertical_max;
    }

    public void setVertical_max(String vertical_max) {
        this.vertical_max = vertical_max;
    }

    @JsonProperty("vertical_crs")
    public String getVerticalCrs() {
        return vertical_crs;
    }

    public void setVertical_crs(String vertical_crs) {
        this.vertical_crs = vertical_crs;
    }

    @JsonProperty("vertical_levels")
    public String getVerticalLevels() {
        return vertical_levels;
    }

    public void setVertical_levels(String vertical_levels) {
        this.vertical_levels = vertical_levels;
    }

    @JsonProperty("temporal_resolution")
    public String getTemporalResolution() {
        return temporal_resolution;
    }

    public void setTemporal_resolution(String temporal_resolution) {
        this.temporal_resolution = temporal_resolution;
    }

    @JsonProperty("vertical_coverage")
    public String getVerticalCoverage() {
        return vertical_coverage;
    }

    public void setVertical_coverage(String vertical_coverage) {
        this.vertical_coverage = vertical_coverage;
    }

    @JsonProperty("temporal_begin")
    public String getTemporalBegin() {
        return temporal_begin;
    }

    public void setTemporal_begin(String temporal_begin) {
        this.temporal_begin = temporal_begin;
    }

    @JsonProperty("temporal_end")
    public String getTemporalEnd() {
        return temporal_end;
    }

    public void setTemporalEnd(String temporal_end) {
        this.temporal_end = temporal_end;
    }

    @JsonProperty("temporal_extent")
    public String getTemporalExtent() {
        return temporal_extent;
    }

    public void setTemporal_extent(String temporal_extent) {
        this.temporal_extent = temporal_extent;
    }

    @JsonProperty("temporal_scale")
    public String getTemporalScale() {
        return temporal_scale;
    }

    public void setTemporal_scale(String temporal_scale) {
        this.temporal_scale = temporal_scale;
    }

    @JsonProperty("update_frequency")
    public String getUpdateFrequency() {
        return update_frequency;
    }

    public void setUpdate_frequency(String update_frequency) {
        this.update_frequency = update_frequency;
    }

    @JsonProperty("update_schedule")
    public String getUpdateSchedule() {
        return update_schedule;
    }

    public void setUpdate_schedule(String update_schedule) {
        this.update_schedule = update_schedule;
    }

    @JsonProperty("production_unit")
    public String getProductionUnit() {
        return production_unit;
    }

    public void setProduction_unit(String production_unit) {
        this.production_unit = production_unit;
    }

    public String getCredit() {
        return credit;
    }

    public void setCredit(String credit) {
        this.credit = credit;
    }

    public String getDocumentation() {
        return documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    @JsonProperty("MAIL")
    public String getMail() {
        return mail;
    }

    public void setMail(String mail) {
        this.mail = mail;
    }

    @JsonProperty("FTP")
    public String getFtp() {
        return ftp;
    }

    public void setFtp(String ftp) {
        this.ftp = ftp;
    }

    @JsonProperty("DGF")
    public String getDgf() {
        return dgf;
    }

    public void setDgf(String dgf) {
        this.dgf = dgf;
    }

    @JsonProperty("TDS")
    public String getTds() {
        return tds;
    }

    public void setTds(String tds) {
        this.tds = tds;
    }

    @JsonProperty("WMS")
    public String getWms() {
        return wms;
    }

    public void setWms(String wms) {
        this.wms = wms;
    }

    @JsonProperty("service_desk")
    public String getServiceDesk() {
        return service_desk;
    }

    public void setService_desk(String service_desk) {
        this.service_desk = service_desk;
    }

    @JsonProperty("upstream-production")
    public String getUpstreamProduction() {
        return upstream_production;
    }

    public void setUpstream_production(String upstream_production) {
        this.upstream_production = upstream_production;
    }

    @JsonProperty("upstream-validation")
    public String getUpstreamValidation() {
        return upstream_validation;
    }

    public void setUpstream_validation(String upstream_validation) {
        this.upstream_validation = upstream_validation;
    }

    @JsonProperty("downstream-validation")
    public String getDownstreamValidation() {
        return downstream_validation;
    }

    public void setDownstream_validation(String downstream_validation) {
        this.downstream_validation = downstream_validation;
    }

    @JsonProperty("downstream-production")
    public String getDownstreamProduction() {
        return downstream_production;
    }

    public void setDownstream_production(String downstream_production) {
        this.downstream_production = downstream_production;
    }

    @JsonProperty("MYO-OK")
    public String getMYO_OK() {
        return MYO_OK;
    }

    public void setMYO_OK(String mYO_OK) {
        MYO_OK = mYO_OK;
    }

    public String getVersion_() {
        return _version;
    }

    @JsonProperty("_version_")
    public void setVersion_(String _version) {
        this._version = _version;
    }

}
